def 列表_筛选_最大长度过滤(列表, 最大长度):
    """
    过滤掉列表中长度大于指定值的元素，并返回过滤后的新列表。

    参数:
        - 列表 (list): 包含字符串或其他序列类型元素的列表。
        - 最大长度 (int): 保留元素的最大长度。

    返回:
        - 过滤后的新列表 (list): 只包含长度小于等于指定值的元素的列表。如果处理过程中发生异常，则返回错误信息。

    示例:
        结果 = 列表_筛选_最大长度过滤(["apple", "banana", "cherry"], 5)
        print("过滤后的新列表:", 结果)
    """
    try:
        # 使用列表推导式过滤掉长度大于最大长度的元素
        过滤后的新列表 = [元素 for 元素 in 列表 if len(元素) <= 最大长度]
        return 过滤后的新列表
    except Exception as e:
        # 捕获所有异常并返回错误信息
        return f"处理失败: {e}"