def 文本_取右边(被查找的文本, 欲寻找的文本, 起始寻找位置=0, 是否不区分大小写=False):
    """
    从被查找的文本中寻找指定的文本，并返回该文本右边的所有字符。如果找不到，返回空字符串。

    参数:
        - 被查找的文本 (str): 要在其中进行查找的文本。
        - 欲寻找的文本 (str): 需要寻找的目标文本。
        - 起始寻找位置 (int, optional): 开始查找的位置索引，默认为 0。
        - 是否不区分大小写 (bool, optional): 如果为 True，查找时不区分大小写；如果为 False，区分大小写。默认值为 False。

    返回:
        - str: 欲寻找的文本右边的文本内容。如果找不到或出现异常，返回空字符串。

    示例用法:
        被查找的文本 = "这是一个示例文本，Python是一种很强大的编程语言"
        欲寻找的文本 = "Python"
        结果 = 文本_取右边(被查找的文本, 欲寻找的文本, 1, True)
        print(结果)  # 输出：是一种很强大的编程语言
    """
    try:
        if 是否不区分大小写:
            被查找的文本 = 被查找的文本.lower()
            欲寻找的文本 = 欲寻找的文本.lower()

        寻找位置 = 被查找的文本.find(欲寻找的文本, 起始寻找位置)
        if 寻找位置 != -1:
            return 被查找的文本[寻找位置 + len(欲寻找的文本):]
        else:
            return ""
    except Exception:
        return ""