def 文本_取指定变量文本行(文本, 行号):
    """
    从给定的文本中提取指定行号的文本内容。如果行号无效或出现异常，返回空字符串。

    参数:
        - 文本 (str): 包含多行文本的字符串。
        - 行号 (int): 要提取的文本行的行号（从1开始）。

    返回:
        - str: 指定行号的文本内容。如果行号无效或出现异常，返回空字符串。

    示例用法:
        源文本 = "这是第一行\n这是第二行\n这是第三行"
        行号 = 2
        文本行 = 文本_取指定变量文本行(源文本, 行号)
        print("第", 行号, "行的文本:", 文本行)  # 输出：这是第二行
    """
    try:
        行列表 = 文本.splitlines()
        行数 = len(行列表)
        if 1 <= 行号 <= 行数:
            return 行列表[行号 - 1]
        else:
            return ""
    except Exception:
        return ""