def 文本_替换行内容(文本, 行数, 替换内容):
    """
    将指定行的内容替换为给定内容。

    参数：
        - 文本 (str): 要进行操作的多行字符串。
        - 行数 (int): 要替换的行号（从1开始）。
        - 替换内容 (str): 用于替换行的字符串。

    返回值：
        - str: 替换后的文本。如果行数超出范围或发生异常，返回False。

    示例用法：
    源文本 = "这是第一行\n这是第二行\n这是第三行"
    行号 = 2
    替换文本 = "曾凤翔"
    替换后文本 = 文本_替换行内容(源文本, 行号, 替换文本)
    print("替换后的文本:")
    print(替换后文本)
    """
    try:
        # 将文本按行拆分为列表
        行列表 = 文本.splitlines()

        # 行数从1开始计数，列表索引从0开始计数，需要减1
        行数 -= 1

        # 检查行数是否在有效范围内
        if 0 <= 行数 < len(行列表):
            # 替换指定行的内容
            行列表[行数] = 替换内容
            # 重新拼接成字符串并返回
            return '\n'.join(行列表)
        else:
            # 行数超出范围，返回原文本
            return False
    except Exception:
        return False