def 文本文件_取指定行内容_取中间(文件路径, 行号, 左字符串, 右字符串):
    """
    获取指定文本文件中特定行的内容，并取两个字符串之间的部分。

    注意：文本编码格式需要为UTF-8

    参数:
        - 文件路径 (str): 要读取的文本文件的路径。
        - 行号 (int): 要获取内容的行号（从1开始）。
        - 左字符串 (str): 用于定位行内容左侧的字符串。
        - 右字符串 (str): 用于定位行内容右侧的字符串。

    返回:
        - str: 左字符串和右字符串之间的内容。失败返回 None。

    示例:
        行内容中间 = 文本文件_取指定行内容_取中间('示例.txt', 3, 'aaa----', '----ccc')
        if 行内容中间 is not None:
            print("行内容中间:", 行内容中间)
        else:
            print("获取行内容失败")
    """
    try:
        with open(文件路径, 'r', encoding='utf-8') as file:
            行内容 = file.readlines()

        if 行号 < 1 or 行号 > len(行内容):
            return None

        # 获取指定行并去除行尾的换行符
        指定行内容 = 行内容[行号 - 1].rstrip('\n')

        # 查找左字符串和右字符串的位置
        左字符串位置 = 指定行内容.find(左字符串)
        if 左字符串位置 == -1:
            return None

        右字符串位置 = 指定行内容.find(右字符串, 左字符串位置 + len(左字符串))
        if 右字符串位置 == -1:
            return None

        # 获取左字符串和右字符串之间的内容
        中间内容 = 指定行内容[左字符串位置 + len(左字符串):右字符串位置]

        return 中间内容
    except Exception:
        return None