def 算数_保留小数点后指定位数(数字, 位数):
    """
    保留给定数值小数点后指定位数的函数。

    参数:
        数字 (float): 需要保留小数位的数值。
        位数 (int): 保留的小数位数。

    返回:
        float: 保留小数点后指定位数后的数值。如果出现异常则返回 False。

    使用示例:
        结果 = 算数_保留小数点后指定位数(3.1415926, 2)
        print(结果)  # 输出结果为 3.14
    """
    try:
        数字字符串 = str(数字)
        小数点索引 = 数字字符串.find('.')
        if 小数点索引 != -1:
            小数部分 = 数字字符串[小数点索引 + 1:]
            if len(小数部分) < 位数:
                小数部分 += '0' * (位数 - len(小数部分))
            return float(数字字符串[:小数点索引 + 位数 + 1])
        else:
            return float(数字字符串 + '.' + '0' * 位数)
    except Exception:
        return False