def 进制转换_二进制转八进制(二进制字符串):
    """
    将二进制字符串转换为八进制字符串。

    参数:
        二进制字符串 (str): 要转换的二进制字符串。

    返回:
        str: 转换后的八进制字符串，如果输入不是有效的二进制字符串则返回 None。

    示例:
        八进制字符串 = 进制转换_二进制转八进制('110010101011')
        print(八进制字符串)  # 输出：'6253'
    """
    try:
        # 将二进制字符串补齐到八的倍数
        补齐后的二进制 = 二进制字符串.zfill((len(二进制字符串) + 2) // 3 * 3)
        # 分割为每3位一组
        二进制分组 = [补齐后的二进制[i:i + 3] for i in range(0, len(补齐后的二进制), 3)]
        # 转换为八进制
        八进制字符串 = ''.join(str(int(组, 2)) for 组 in 二进制分组)
        return 八进制字符串
    except Exception:
        return None
