def 邮件POP3_获取邮件内容(服务器对象, 邮件索引):
    """
    获取指定索引的邮件内容。

    参数:
        - 服务器对象 (poplib.POP3): 已经连接的POP3服务器对象。
        - 邮件索引 (int): 要获取的邮件的索引。

    返回值:
        - bytes: 邮件内容的字节串。如果出现异常或指定索引的邮件不存在，返回假(False)。
    """
    try:
        # 获取指定索引的邮件内容
        局_响应, 局_邮件列表, _ = 服务器对象.list()
        if 邮件索引 > len(局_邮件列表) or 邮件索引 <= 0:  # 索引从1开始，所以索引必然不可能小于或等于0，也不可能大于邮件的数量。
            return False  # 邮件不存在，返回 False

        局_响应, 局_邮件内容, _ = 服务器对象.retr(邮件索引)
        局_邮件内容字节串 = b'\n'.join(局_邮件内容)
        return 局_邮件内容字节串
    except Exception:
        return False