---
name: Bug report
about: Create a report to help us improve
title: "[BUG]: "
labels: ''
assignees: ''

---

# Bug Report

**Describe the Bug**
A clear and concise description of the problem.

**To Reproduce**
Steps or code snippets to reproduce the behavior, like:
```
1. Install AgentNeo using `pip install agentneo`
2. Run the following code:
   # Your code here
3. Launch the dashboard using `launch_dashboard(port=3000)`
4. Observe the error or unexpected behavior.
```

**Expected Behavior**
A clear and concise description of what you expected to happen.

**Actual Behavior**
Describe what actually happened, including any error messages or unexpected results.

**Logs and Screenshots**
If applicable, add logs, stack traces, or screenshots to help explain the issue.

**Environment Details**
- **Operating System**: [e.g., Windows 10, Ubuntu 20.04, macOS Catalina]
- **Python Version**: [e.g., 3.9.10]
- **AgentNeo Version**: [e.g., 1.0.0]
- **Relevant Packages**: [e.g., OpenAI SDK 0.9.0, LiteLLM 1.2.3]

**AgentNeo Configuration**
Provide any custom configuration settings or code modifications:
```python
# Your custom configuration or code here
```

**Additional Context**
Add any other information about the problem here, such as:
- Network configuration
- Firewall settings
- Previous attempts to fix the issue
