# Generated by Django 5.2 on 2025-04-19 19:46

import django.core.validators
import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models

import django_ca.modelfields
import django_ca.models


class Migration(migrations.Migration):
    replaces = [
        ("django_ca", "0001_initial"),
        ("django_ca", "0002_auto_20170304_1434"),
        ("django_ca", "0003_auto_20170304_1434"),
        ("django_ca", "0004_auto_20170304_1442"),
        ("django_ca", "0005_auto_20170307_1839"),
        ("django_ca", "0006_auto_20170505_1251"),
        ("django_ca", "0007_auto_20171119_1100"),
        ("django_ca", "0008_auto_20171203_2001"),
        ("django_ca", "0009_auto_20181128_2050"),
        ("django_ca", "0010_auto_20181128_2054"),
        ("django_ca", "0011_auto_20181208_1708"),
        ("django_ca", "0012_auto_20190405_2345"),
        ("django_ca", "0013_certificateauthority_crl_number"),
        ("django_ca", "0014_auto_20190518_1046"),
        ("django_ca", "0015_auto_20190518_1050"),
        ("django_ca", "0016_auto_20190706_1548"),
        ("django_ca", "0017_auto_20200112_1657"),
        ("django_ca", "0018_certificate_profile"),
        ("django_ca", "0019_certificate_autogenerated"),
        ("django_ca", "0020_auto_20201213_2014"),
        ("django_ca", "0021_auto_20210416_1557"),
        ("django_ca", "0022_auto_20210430_1124"),
        ("django_ca", "0023_auto_20210429_0000"),
        ("django_ca", "0024_auto_20210430_1131"),
        ("django_ca", "0025_auto_20210430_1132"),
        ("django_ca", "0026_auto_20210501_1258"),
        ("django_ca", "0027_certificateauthority_acme_profile"),
        ("django_ca", "0028_alter_certificate_revoked_reason_and_more"),
        ("django_ca", "0029_certificate_updated_certificateauthority_updated_and_more"),
        ("django_ca", "0030_alter_certificateauthority_issuer_alt_name_and_more"),
        ("django_ca", "0031_certificateauthority_sign_certificate_policies"),
        ("django_ca", "0032_certificateauthority_ocsp_responder_key_validity_and_more"),
        ("django_ca", "0033_alter_certificate_options"),
        ("django_ca", "0034_certificateauthority_acme_registration"),
        ("django_ca", "0035_certificateorder"),
        ("django_ca", "0036_certificateauthority_api_enabled"),
        ("django_ca", "0037_alter_certificateauthority_name_and_more"),
        ("django_ca", "0038_auto_20231228_1932"),
        ("django_ca", "0039_certificateauthority_sign_authority_information_access_and_more"),
        ("django_ca", "0040_auto_20240120_0931"),
        ("django_ca", "0041_remove_certificateauthority_crl_url_and_more"),
        ("django_ca", "0042_certificateauthority_key_backend_options_and_more"),
        ("django_ca", "0043_auto_20240221_2153"),
        ("django_ca", "0044_remove_certificateauthority_private_key_path"),
        ("django_ca", "0045_rename_valid_from_certificate_not_before_and_more"),
        ("django_ca", "0046_rename_expires_certificate_not_after_and_more"),
        ("django_ca", "0047_certificaterevocationlist"),
        ("django_ca", "0048_auto_20241017_2104"),
        ("django_ca", "0049_remove_certificateauthority_crl_number"),
        ("django_ca", "0050_certificateauthority_ocsp_key_backend_alias_and_more"),
        ("django_ca", "0051_auto_20241201_2038"),
        ("django_ca", "0052_remove_certificaterevocationlist_django_ca_c_ca_id_965937_idx_and_more"),
    ]

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="CertificateAuthority",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("not_after", models.DateTimeField()),
                ("cn", models.CharField(max_length=128, verbose_name="CommonName")),
                ("serial", models.CharField(max_length=64, unique=True)),
                ("name", models.CharField(help_text="A human-readable name", max_length=256, unique=True)),
                ("enabled", models.BooleanField(default=True)),
                (
                    "parent",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="children",
                        to="django_ca.certificateauthority",
                    ),
                ),
                ("revoked", models.BooleanField(default=False)),
                (
                    "revoked_date",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[django_ca.models.validate_past],
                        verbose_name="Revoked on",
                    ),
                ),
                (
                    "revoked_reason",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("aa_compromise", "Attribute Authority compromised"),
                            ("affiliation_changed", "Affiliation changed"),
                            ("ca_compromise", "CA compromised"),
                            ("certificate_hold", "On Hold"),
                            ("cessation_of_operation", "Cessation of operation"),
                            ("key_compromise", "Key compromised"),
                            ("privilege_withdrawn", "Privilege withdrawn"),
                            ("remove_from_crl", "Removed from CRL"),
                            ("superseded", "Superseded"),
                            ("unspecified", "Unspecified"),
                        ],
                        default="",
                        max_length=32,
                        verbose_name="Reason for revocation",
                    ),
                ),
                ("not_before", models.DateTimeField()),
                (
                    "compromised",
                    models.DateTimeField(
                        blank=True,
                        help_text="Optional: When this certificate was compromised. You can change this date later.",
                        null=True,
                        validators=[django_ca.models.validate_past],
                        verbose_name="Date of compromise",
                    ),
                ),
                (
                    "acme_enabled",
                    models.BooleanField(
                        default=False,
                        help_text="Whether it is possible to use ACME for this CA.",
                        verbose_name="Enable ACME",
                    ),
                ),
                (
                    "acme_requires_contact",
                    models.BooleanField(
                        default=True,
                        help_text="If this CA requires a contact address during account registration.",
                        verbose_name="Requires contact",
                    ),
                ),
                (
                    "caa_identity",
                    models.CharField(
                        blank=True,
                        help_text="CAA identity for this CA (NOTE: Not currently used!).",
                        max_length=32,
                        verbose_name="CAA identity",
                    ),
                ),
                (
                    "terms_of_service",
                    models.URLField(
                        blank=True,
                        help_text="URL to Terms of Service for this CA",
                        verbose_name="Terms of Service",
                    ),
                ),
                ("website", models.URLField(blank=True, help_text="Website for your CA.")),
                ("pub", django_ca.modelfields.CertificateField(verbose_name="Public key")),
                (
                    "acme_profile",
                    models.CharField(
                        default=django_ca.models.default_profile,
                        help_text="Profile used when generating ACME certificates.",
                        max_length=32,
                        verbose_name="Profile",
                    ),
                ),
                ("updated", models.DateTimeField(auto_now=True)),
                (
                    "sign_certificate_policies",
                    django_ca.modelfields.CertificatePoliciesField(
                        blank=True,
                        default=None,
                        help_text="Add a Certificate Policies extension when signing certificates.",
                        null=True,
                        verbose_name="Certificate Policies",
                    ),
                ),
                (
                    "ocsp_responder_key_validity",
                    models.PositiveSmallIntegerField(
                        default=3,
                        help_text="How long <strong>(in days)</strong> OCSP responder keys may be valid.",
                        validators=[django.core.validators.MinValueValidator(1)],
                        verbose_name="OCSP responder key validity",
                    ),
                ),
                (
                    "ocsp_response_validity",
                    models.PositiveIntegerField(
                        default=86400,
                        help_text="How long <strong>(in seconds)</strong> OCSP responses may be considered valid by the client.",
                        validators=[django.core.validators.MinValueValidator(600)],
                        verbose_name="OCSP response validity",
                    ),
                ),
                (
                    "acme_registration",
                    models.BooleanField(
                        default=True,
                        help_text="Allow ACME clients to register new accounts.",
                        verbose_name="ACME account registration.",
                    ),
                ),
                (
                    "api_enabled",
                    models.BooleanField(
                        default=False,
                        help_text="Whether it is possible to use the API for this CA.",
                        verbose_name="Enable API",
                    ),
                ),
                (
                    "sign_authority_information_access",
                    django_ca.modelfields.AuthorityInformationAccessField(
                        blank=True,
                        default=None,
                        help_text="Add a Authority  Information Access extension when signing certificates.",
                        null=True,
                        verbose_name="Authority Information Access",
                    ),
                ),
                (
                    "sign_crl_distribution_points",
                    django_ca.modelfields.CRLDistributionPointsField(
                        blank=True,
                        default=None,
                        help_text="Add a CRL Distribution Points extension when signing certificates.",
                        null=True,
                        verbose_name="CRL Distribution Points",
                    ),
                ),
                (
                    "sign_issuer_alternative_name",
                    django_ca.modelfields.IssuerAlternativeNameField(
                        blank=True,
                        default=None,
                        help_text="Add an Issuer Alternative Name extension when signing certificates.",
                        null=True,
                        verbose_name="Issuer Alternative Name",
                    ),
                ),
                (
                    "key_backend_options",
                    models.JSONField(blank=True, default=dict, help_text="Key backend options"),
                ),
                (
                    "key_backend_alias",
                    models.CharField(help_text="Backend to handle private keys.", max_length=256),
                ),
                (
                    "ocsp_key_backend_alias",
                    models.CharField(
                        help_text="Backend to handle private keys for OCSP responder certificates.",
                        max_length=256,
                    ),
                ),
                (
                    "ocsp_key_backend_options",
                    models.JSONField(
                        blank=True,
                        default=django_ca.models.ocsp_key_backend_options_default,
                        help_text="Key backend options for using OCSP responder private keys.",
                    ),
                ),
            ],
            options={
                "verbose_name": "Certificate Authority",
                "verbose_name_plural": "Certificate Authorities",
            },
        ),
        migrations.CreateModel(
            name="Watcher",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("name", models.CharField(blank=True, default="", max_length=64, verbose_name="CommonName")),
                ("mail", models.EmailField(max_length=254, unique=True, verbose_name="E-Mail")),
            ],
        ),
        migrations.CreateModel(
            name="Certificate",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("not_after", models.DateTimeField()),
                ("cn", models.CharField(max_length=128, verbose_name="CommonName")),
                ("serial", models.CharField(max_length=64, unique=True)),
                ("revoked", models.BooleanField(default=False)),
                (
                    "revoked_date",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[django_ca.models.validate_past],
                        verbose_name="Revoked on",
                    ),
                ),
                (
                    "revoked_reason",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("aa_compromise", "Attribute Authority compromised"),
                            ("affiliation_changed", "Affiliation changed"),
                            ("ca_compromise", "CA compromised"),
                            ("certificate_hold", "On Hold"),
                            ("cessation_of_operation", "Cessation of operation"),
                            ("key_compromise", "Key compromised"),
                            ("privilege_withdrawn", "Privilege withdrawn"),
                            ("remove_from_crl", "Removed from CRL"),
                            ("superseded", "Superseded"),
                            ("unspecified", "Unspecified"),
                        ],
                        default="",
                        max_length=32,
                        verbose_name="Reason for revocation",
                    ),
                ),
                (
                    "ca",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="django_ca.certificateauthority",
                        verbose_name="Certificate Authority",
                    ),
                ),
                (
                    "watchers",
                    models.ManyToManyField(blank=True, related_name="certificates", to="django_ca.watcher"),
                ),
                ("not_before", models.DateTimeField()),
                (
                    "compromised",
                    models.DateTimeField(
                        blank=True,
                        help_text="Optional: When this certificate was compromised. You can change this date later.",
                        null=True,
                        validators=[django_ca.models.validate_past],
                        verbose_name="Date of compromise",
                    ),
                ),
                (
                    "profile",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Profile that was used to generate this certificate.",
                        max_length=32,
                    ),
                ),
                (
                    "autogenerated",
                    models.BooleanField(
                        default=False, help_text="If this certificate was automatically generated."
                    ),
                ),
                (
                    "csr",
                    django_ca.modelfields.CertificateSigningRequestField(
                        blank=True, null=True, verbose_name="CSR"
                    ),
                ),
                ("pub", django_ca.modelfields.CertificateField(verbose_name="Public key")),
                ("updated", models.DateTimeField(auto_now=True)),
            ],
            options={
                "abstract": False,
                "permissions": (
                    ("revoke_certificate", "Can revoke a certificate"),
                    ("sign_certificate", "Can sign a certificate"),
                ),
            },
        ),
        migrations.CreateModel(
            name="AcmeAccount",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("created", models.DateTimeField(default=django.utils.timezone.now)),
                ("updated", models.DateTimeField(auto_now=True)),
                (
                    "pem",
                    models.TextField(validators=[django_ca.models.pem_validator], verbose_name="Public key"),
                ),
                ("thumbprint", models.CharField(max_length=64, unique=True)),
                ("slug", models.SlugField(default=django_ca.models.acme_slug, unique=True)),
                (
                    "kid",
                    models.URLField(
                        unique=True,
                        validators=[django.core.validators.URLValidator(schemes=("http", "https"))],
                        verbose_name="Key ID",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[("valid", "Valid"), ("deactivated", "Deactivated"), ("revoked", "Revoked")],
                        default="valid",
                        max_length=12,
                    ),
                ),
                (
                    "contact",
                    models.TextField(
                        blank=True, help_text="Contact addresses for this account, one per line."
                    ),
                ),
                ("terms_of_service_agreed", models.BooleanField(default=False)),
                (
                    "ca",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="django_ca.certificateauthority",
                        verbose_name="Certificate Authority",
                    ),
                ),
            ],
            options={
                "verbose_name": "ACME Account",
                "verbose_name_plural": "ACME Accounts",
                "unique_together": {("ca", "thumbprint")},
            },
            bases=(django_ca.models.DjangoCAModel,),
        ),
        migrations.CreateModel(
            name="AcmeOrder",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("slug", models.SlugField(default=django_ca.models.acme_slug, unique=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("invalid", "Invalid"),
                            ("pending", "Pending"),
                            ("processing", "Processing"),
                            ("ready", "Ready"),
                            ("valid", "Valid"),
                        ],
                        default="pending",
                        max_length=10,
                    ),
                ),
                ("expires", models.DateTimeField(default=django_ca.models.acme_order_expires)),
                ("not_before", models.DateTimeField(null=True)),
                ("not_after", models.DateTimeField(null=True)),
                (
                    "account",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="orders",
                        to="django_ca.acmeaccount",
                    ),
                ),
            ],
            options={
                "verbose_name": "ACME Order",
                "verbose_name_plural": "ACME Orders",
            },
            bases=(django_ca.models.DjangoCAModel,),
        ),
        migrations.CreateModel(
            name="AcmeAuthorization",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("slug", models.SlugField(default=django_ca.models.acme_slug, unique=True)),
                ("type", models.CharField(choices=[("dns", "DNS")], default="dns", max_length=8)),
                ("value", models.CharField(max_length=255)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("pending", "Pending"),
                            ("valid", "Valid"),
                            ("invalid", "Invalid"),
                            ("deactivated", "Deactivated"),
                            ("expired", "Expired"),
                            ("revoked", "Revoked"),
                        ],
                        default="pending",
                        max_length=12,
                    ),
                ),
                ("wildcard", models.BooleanField(default=False)),
                (
                    "order",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="authorizations",
                        to="django_ca.acmeorder",
                    ),
                ),
            ],
            options={
                "verbose_name": "ACME Authorization",
                "verbose_name_plural": "ACME Authorizations",
                "unique_together": {("order", "type", "value")},
            },
        ),
        migrations.CreateModel(
            name="CertificateOrder",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("updated", models.DateTimeField(auto_now=True)),
                (
                    "slug",
                    models.SlugField(
                        default=django_ca.models.acme_slug,
                        help_text="Slug identifying the order.",
                        unique=True,
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[("pending", "Choices"), ("failed", "Failed"), ("issued", "Issued")],
                        default="pending",
                        help_text="Current status of the order.",
                        max_length=8,
                    ),
                ),
                (
                    "error_code",
                    models.PositiveSmallIntegerField(
                        blank=True, help_text="Machine readable error code.", null=True
                    ),
                ),
                (
                    "error",
                    models.CharField(blank=True, help_text="Human readable error message.", max_length=256),
                ),
                (
                    "certificate",
                    models.OneToOneField(
                        help_text="Certificate issued for this order.",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="order",
                        to="django_ca.certificate",
                    ),
                ),
                (
                    "certificate_authority",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="orders",
                        to="django_ca.certificateauthority",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        help_text="User used for creating the order.",
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="AcmeChallenge",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("slug", models.SlugField(default=django_ca.models.acme_slug, unique=True)),
                (
                    "type",
                    models.CharField(
                        choices=[
                            ("http-01", "HTTP Challenge"),
                            ("dns-01", "DNS Challenge"),
                            ("tls-alpn-01", "TLS ALPN Challenge"),
                        ],
                        max_length=12,
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("pending", "Pending"),
                            ("processing", "Processing"),
                            ("valid", "Valid"),
                            ("invalid", "Name"),
                        ],
                        default="pending",
                        max_length=12,
                    ),
                ),
                ("validated", models.DateTimeField(blank=True, null=True)),
                ("error", models.CharField(blank=True, max_length=64)),
                ("token", models.CharField(blank=True, default=django_ca.models.acme_token, max_length=64)),
                (
                    "auth",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="challenges",
                        to="django_ca.acmeauthorization",
                    ),
                ),
            ],
            options={
                "verbose_name": "ACME Challenge",
                "verbose_name_plural": "ACME Challenges",
                "unique_together": {("auth", "type")},
            },
        ),
        migrations.CreateModel(
            name="AcmeCertificate",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("slug", models.SlugField(default=django_ca.models.acme_slug, unique=True)),
                ("csr", models.TextField(verbose_name="CSR")),
                (
                    "cert",
                    models.OneToOneField(
                        null=True, on_delete=django.db.models.deletion.CASCADE, to="django_ca.certificate"
                    ),
                ),
                (
                    "order",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE, to="django_ca.acmeorder"
                    ),
                ),
            ],
            options={
                "verbose_name": "ACME Certificate",
                "verbose_name_plural": "ACME Certificate",
            },
        ),
        migrations.CreateModel(
            name="CertificateRevocationList",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "number",
                    models.PositiveIntegerField(
                        db_index=True,
                        help_text="Monotonically increasing number for the CRLNumber extension.",
                    ),
                ),
                ("last_update", models.DateTimeField(help_text="The CRL's activation time.")),
                ("next_update", models.DateTimeField(help_text="The CRL's next update time.")),
                ("only_contains_ca_certs", models.BooleanField(default=False)),
                ("only_contains_user_certs", models.BooleanField(default=False)),
                ("only_contains_attribute_certs", models.BooleanField(default=False)),
                (
                    "only_some_reasons",
                    models.JSONField(
                        decoder=django_ca.models.ReasonDecoder,
                        default=None,
                        encoder=django_ca.models.ReasonEncoder,
                        null=True,
                    ),
                ),
                ("data", models.BinaryField(null=True)),
                (
                    "ca",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="django_ca.certificateauthority",
                        verbose_name="Certificate Authority",
                    ),
                ),
            ],
            options={
                "indexes": [
                    models.Index(
                        fields=[
                            "ca",
                            "number",
                            "only_contains_user_certs",
                            "only_contains_ca_certs",
                            "only_contains_attribute_certs",
                        ],
                        name="django_ca_c_ca_id_c93eda_idx",
                    )
                ],
            },
        ),
    ]
