# Generated by Django 4.2.6 on 2023-10-26 16:18

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_ca.models


class Migration(migrations.Migration):
    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("django_ca", "0034_certificateauthority_acme_registration"),
    ]

    operations = [
        migrations.CreateModel(
            name="CertificateOrder",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("updated", models.DateTimeField(auto_now=True)),
                (
                    "slug",
                    models.SlugField(
                        default=django_ca.models.acme_slug,
                        help_text="Slug identifying the order.",
                        unique=True,
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        default="pending", help_text="Current status of the order.", max_length=8
                    ),
                ),
                (
                    "error_code",
                    models.PositiveSmallIntegerField(
                        blank=True, help_text="Machine readable error code.", null=True
                    ),
                ),
                (
                    "error",
                    models.CharField(blank=True, help_text="Human readable error message.", max_length=256),
                ),
                (
                    "certificate",
                    models.OneToOneField(
                        help_text="Certificate issued for this order.",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="order",
                        to="django_ca.certificate",
                    ),
                ),
                (
                    "certificate_authority",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="orders",
                        to="django_ca.certificateauthority",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        help_text="User used for creating the order.",
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
    ]
