# This file is part of django-ca (https://github.com/mathiasertl/django-ca).
#
# django-ca is free software: you can redistribute it and/or modify it under the terms of the GNU General
# Public License as published by the Free Software Foundation, either version 3 of the License, or (at your
# option) any later version.
#
# django-ca is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
# implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License along with django-ca. If not, see
# <http://www.gnu.org/licenses/>.
#
# Generated by Django 5.0.2 on 2024-02-21 20:53

from django.db import migrations


def migrate_path(apps, schema_editor):  # pragma: no cover
    """Forward migration."""
    CertificateAuthority = apps.get_model("django_ca", "CertificateAuthority")
    for ca in CertificateAuthority.objects.all():
        ca.key_backend_alias = "default"
        ca.key_backend_options = {"path": ca.private_key_path}
        ca.save()


def reverse_path(apps, schema_editor):  # pragma: no cover
    """Backward migration."""
    CertificateAuthority = apps.get_model("django_ca", "CertificateAuthority")
    for ca in CertificateAuthority.objects.all():
        if ca.key_backend_alias == "default" and "path" in ca.key_backend_options:
            ca.private_key_path = ca.key_backend_options["path"]
        else:  # pragma: no cover  # django-test-migrations does not properly roll back in this case.
            raise ValueError(f"{ca.name}: CA does not use StoragesBackend, cannot revert this migration.")
        ca.save()


class Migration(migrations.Migration):
    dependencies = [
        ("django_ca", "0042_certificateauthority_key_backend_options_and_more"),
    ]

    operations = [
        migrations.RunPython(migrate_path, reverse_path, elidable=True),
    ]
