# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.connect_token import ConnectToken
from ..types.create_token_response import CreateTokenResponse
from ..types.validate_token_response import ValidateTokenResponse
from .raw_client import AsyncRawTokensClient, RawTokensClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TokensClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTokensClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTokensClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTokensClient
        """
        return self._raw_client

    def create(
        self,
        *,
        external_user_id: str,
        allowed_origins: typing.Optional[typing.Sequence[str]] = OMIT,
        error_redirect_uri: typing.Optional[str] = OMIT,
        success_redirect_uri: typing.Optional[str] = OMIT,
        webhook_uri: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateTokenResponse:
        """
        Generate a Connect token to use for client-side authentication

        Parameters
        ----------
        external_user_id : str
            Your end user ID, for whom you're creating the token

        allowed_origins : typing.Optional[typing.Sequence[str]]
            List of allowed origins for CORS

        error_redirect_uri : typing.Optional[str]
            URI to redirect to on error

        success_redirect_uri : typing.Optional[str]
            URI to redirect to on success

        webhook_uri : typing.Optional[str]
            Webhook URI for notifications

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateTokenResponse
            connect token created

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.tokens.create(
            external_user_id="external_user_id",
        )
        """
        _response = self._raw_client.create(
            external_user_id=external_user_id,
            allowed_origins=allowed_origins,
            error_redirect_uri=error_redirect_uri,
            success_redirect_uri=success_redirect_uri,
            webhook_uri=webhook_uri,
            request_options=request_options,
        )
        return _response.data

    def validate(
        self,
        ctok: ConnectToken,
        *,
        app_id: str,
        oauth_app_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ValidateTokenResponse:
        """
        Confirm the validity of a Connect token

        Parameters
        ----------
        ctok : ConnectToken

        app_id : str
            The app ID to validate against

        oauth_app_id : typing.Optional[str]
            The OAuth app ID to validate against (if the token is for an OAuth app)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ValidateTokenResponse
            connect token validated

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.tokens.validate(
            ctok="ctok",
            app_id="app_id",
        )
        """
        _response = self._raw_client.validate(
            ctok, app_id=app_id, oauth_app_id=oauth_app_id, request_options=request_options
        )
        return _response.data


class AsyncTokensClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTokensClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTokensClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTokensClient
        """
        return self._raw_client

    async def create(
        self,
        *,
        external_user_id: str,
        allowed_origins: typing.Optional[typing.Sequence[str]] = OMIT,
        error_redirect_uri: typing.Optional[str] = OMIT,
        success_redirect_uri: typing.Optional[str] = OMIT,
        webhook_uri: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateTokenResponse:
        """
        Generate a Connect token to use for client-side authentication

        Parameters
        ----------
        external_user_id : str
            Your end user ID, for whom you're creating the token

        allowed_origins : typing.Optional[typing.Sequence[str]]
            List of allowed origins for CORS

        error_redirect_uri : typing.Optional[str]
            URI to redirect to on error

        success_redirect_uri : typing.Optional[str]
            URI to redirect to on success

        webhook_uri : typing.Optional[str]
            Webhook URI for notifications

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateTokenResponse
            connect token created

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.tokens.create(
                external_user_id="external_user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            external_user_id=external_user_id,
            allowed_origins=allowed_origins,
            error_redirect_uri=error_redirect_uri,
            success_redirect_uri=success_redirect_uri,
            webhook_uri=webhook_uri,
            request_options=request_options,
        )
        return _response.data

    async def validate(
        self,
        ctok: ConnectToken,
        *,
        app_id: str,
        oauth_app_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ValidateTokenResponse:
        """
        Confirm the validity of a Connect token

        Parameters
        ----------
        ctok : ConnectToken

        app_id : str
            The app ID to validate against

        oauth_app_id : typing.Optional[str]
            The OAuth app ID to validate against (if the token is for an OAuth app)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ValidateTokenResponse
            connect token validated

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.tokens.validate(
                ctok="ctok",
                app_id="app_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.validate(
            ctok, app_id=app_id, oauth_app_id=oauth_app_id, request_options=request_options
        )
        return _response.data
