# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .app import App


class Account(UniversalBaseModel):
    """
    End user account data, returned from the API.
    """

    id: str = pydantic.Field()
    """
    The unique ID of the account.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The custom name of the account if set.
    """

    external_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The external ID associated with the account.
    """

    healthy: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates if the account is healthy. Pipedream will periodically retry token refresh and test requests for unhealthy accounts
    """

    dead: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates if the account is no longer active
    """

    app: typing.Optional[App] = None
    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The date and time the account was created, an ISO 8601 formatted string
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The date and time the account was last updated, an ISO 8601 formatted string
    """

    credentials: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    The credentials associated with the account, if the `include_credentials` parameter was set to true in the request
    """

    expires_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The date and time the account's credentials expiration, an ISO 8601 formatted string
    """

    error: typing.Optional[str] = pydantic.Field(default=None)
    """
    The error message if the account is unhealthy or dead, null otherwise
    """

    last_refreshed_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The date and time the account was last refreshed, an ISO 8601 formatted string
    """

    next_refresh_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The date and time the account will next be refreshed, an ISO 8601 formatted string
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
