# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .component_stash import ComponentStash
from .configurable_prop import ConfigurableProp


class Component(UniversalBaseModel):
    key: str = pydantic.Field()
    """
    The key that uniquely identifies the component.
    """

    name: str = pydantic.Field()
    """
    The human-readable name of the component, e.g. 'GitLab: List Commits'
    """

    version: str = pydantic.Field()
    """
    The latest version of the component, in SemVer format.
    """

    configurable_props: typing.List[ConfigurableProp]
    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    A description of the component
    """

    component_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of component (trigger or action)
    """

    stash: typing.Optional[ComponentStash] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
