# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .app import App


class ValidateTokenResponse(UniversalBaseModel):
    """
    Response received when validating a connect token
    """

    app: typing.Optional[App] = None
    error: typing.Optional[str] = pydantic.Field(default=None)
    """
    Error message if validation failed
    """

    error_redirect_uri: typing.Optional[str] = pydantic.Field(default=None)
    """
    URI to redirect to on error
    """

    oauth_app_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    OAuth app ID if applicable
    """

    project_app_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the project app
    """

    project_environment: typing.Optional[str] = pydantic.Field(default=None)
    """
    Environment of the project
    """

    project_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the project
    """

    project_support_email: typing.Optional[str] = pydantic.Field(default=None)
    """
    Support email for the project
    """

    success: bool = pydantic.Field()
    """
    Whether the token validation was successful
    """

    success_redirect_uri: typing.Optional[str] = pydantic.Field(default=None)
    """
    URI to redirect to on success
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
