# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DynamicTableArgs', 'DynamicTable']

@pulumi.input_type
class DynamicTableArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[_builtins.str],
                 query: pulumi.Input[_builtins.str],
                 schema: pulumi.Input[_builtins.str],
                 target_lag: pulumi.Input['DynamicTableTargetLagArgs'],
                 warehouse: pulumi.Input[_builtins.str],
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 initialize: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 or_replace: Optional[pulumi.Input[_builtins.bool]] = None,
                 refresh_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DynamicTable resource.
        :param pulumi.Input[_builtins.str] database: The database in which to create the dynamic table.
        :param pulumi.Input[_builtins.str] query: Specifies the query to use to populate the dynamic table.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the dynamic table.
        :param pulumi.Input['DynamicTableTargetLagArgs'] target_lag: Specifies the target lag time for the dynamic table.
        :param pulumi.Input[_builtins.str] warehouse: The warehouse in which to create the dynamic table.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the dynamic table.
        :param pulumi.Input[_builtins.str] initialize: (Default: `ON_CREATE`) Initialize trigger for the dynamic table. Can only be set on creation. Available options are ON*CREATE and ON*SCHEDULE.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier (i.e. name) for the dynamic table; must be unique for the schema in which the dynamic table is created.
        :param pulumi.Input[_builtins.bool] or_replace: (Default: `false`) Specifies whether to replace the dynamic table if it already exists.
        :param pulumi.Input[_builtins.str] refresh_mode: (Default: `AUTO`) INCREMENTAL to use incremental refreshes, FULL to recompute the whole table on every refresh, or AUTO to let Snowflake decide.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "schema", schema)
        pulumi.set(__self__, "target_lag", target_lag)
        pulumi.set(__self__, "warehouse", warehouse)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if initialize is not None:
            pulumi.set(__self__, "initialize", initialize)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if or_replace is not None:
            pulumi.set(__self__, "or_replace", or_replace)
        if refresh_mode is not None:
            pulumi.set(__self__, "refresh_mode", refresh_mode)

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Input[_builtins.str]:
        """
        The database in which to create the dynamic table.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter
    def query(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the query to use to populate the dynamic table.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "query", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Input[_builtins.str]:
        """
        The schema in which to create the dynamic table.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="targetLag")
    def target_lag(self) -> pulumi.Input['DynamicTableTargetLagArgs']:
        """
        Specifies the target lag time for the dynamic table.
        """
        return pulumi.get(self, "target_lag")

    @target_lag.setter
    def target_lag(self, value: pulumi.Input['DynamicTableTargetLagArgs']):
        pulumi.set(self, "target_lag", value)

    @_builtins.property
    @pulumi.getter
    def warehouse(self) -> pulumi.Input[_builtins.str]:
        """
        The warehouse in which to create the dynamic table.
        """
        return pulumi.get(self, "warehouse")

    @warehouse.setter
    def warehouse(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "warehouse", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the dynamic table.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def initialize(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: `ON_CREATE`) Initialize trigger for the dynamic table. Can only be set on creation. Available options are ON*CREATE and ON*SCHEDULE.
        """
        return pulumi.get(self, "initialize")

    @initialize.setter
    def initialize(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "initialize", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier (i.e. name) for the dynamic table; must be unique for the schema in which the dynamic table is created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orReplace")
    def or_replace(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Default: `false`) Specifies whether to replace the dynamic table if it already exists.
        """
        return pulumi.get(self, "or_replace")

    @or_replace.setter
    def or_replace(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "or_replace", value)

    @_builtins.property
    @pulumi.getter(name="refreshMode")
    def refresh_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: `AUTO`) INCREMENTAL to use incremental refreshes, FULL to recompute the whole table on every refresh, or AUTO to let Snowflake decide.
        """
        return pulumi.get(self, "refresh_mode")

    @refresh_mode.setter
    def refresh_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "refresh_mode", value)


@pulumi.input_type
class _DynamicTableState:
    def __init__(__self__, *,
                 automatic_clustering: Optional[pulumi.Input[_builtins.bool]] = None,
                 bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_by: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 created_on: Optional[pulumi.Input[_builtins.str]] = None,
                 data_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 initialize: Optional[pulumi.Input[_builtins.str]] = None,
                 is_clone: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_replica: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_suspended_on: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 or_replace: Optional[pulumi.Input[_builtins.bool]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_mode_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 rows: Optional[pulumi.Input[_builtins.int]] = None,
                 scheduling_state: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 target_lag: Optional[pulumi.Input['DynamicTableTargetLagArgs']] = None,
                 warehouse: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DynamicTable resources.
        :param pulumi.Input[_builtins.bool] automatic_clustering: Whether auto-clustering is enabled on the dynamic table. Not currently supported for dynamic tables.
        :param pulumi.Input[_builtins.int] bytes: Number of bytes that will be scanned if the entire dynamic table is scanned in a query.
        :param pulumi.Input[_builtins.str] cluster_by: The clustering key for the dynamic table.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the dynamic table.
        :param pulumi.Input[_builtins.str] created_on: Time when this dynamic table was created.
        :param pulumi.Input[_builtins.str] data_timestamp: Timestamp of the data in the base object(s) that is included in the dynamic table.
        :param pulumi.Input[_builtins.str] database: The database in which to create the dynamic table.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] initialize: (Default: `ON_CREATE`) Initialize trigger for the dynamic table. Can only be set on creation. Available options are ON*CREATE and ON*SCHEDULE.
        :param pulumi.Input[_builtins.bool] is_clone: TRUE if the dynamic table has been cloned, else FALSE.
        :param pulumi.Input[_builtins.bool] is_replica: TRUE if the dynamic table is a replica. else FALSE.
        :param pulumi.Input[_builtins.str] last_suspended_on: Timestamp of last suspension.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier (i.e. name) for the dynamic table; must be unique for the schema in which the dynamic table is created.
        :param pulumi.Input[_builtins.bool] or_replace: (Default: `false`) Specifies whether to replace the dynamic table if it already exists.
        :param pulumi.Input[_builtins.str] owner: Role that owns the dynamic table.
        :param pulumi.Input[_builtins.str] query: Specifies the query to use to populate the dynamic table.
        :param pulumi.Input[_builtins.str] refresh_mode: (Default: `AUTO`) INCREMENTAL to use incremental refreshes, FULL to recompute the whole table on every refresh, or AUTO to let Snowflake decide.
        :param pulumi.Input[_builtins.str] refresh_mode_reason: Explanation for why FULL refresh mode was chosen. NULL if refresh mode is not FULL.
        :param pulumi.Input[_builtins.int] rows: Number of rows in the table.
        :param pulumi.Input[_builtins.str] scheduling_state: Displays ACTIVE for dynamic tables that are actively scheduling refreshes and SUSPENDED for suspended dynamic tables.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the dynamic table.
        :param pulumi.Input['DynamicTableTargetLagArgs'] target_lag: Specifies the target lag time for the dynamic table.
        :param pulumi.Input[_builtins.str] warehouse: The warehouse in which to create the dynamic table.
        """
        if automatic_clustering is not None:
            pulumi.set(__self__, "automatic_clustering", automatic_clustering)
        if bytes is not None:
            pulumi.set(__self__, "bytes", bytes)
        if cluster_by is not None:
            pulumi.set(__self__, "cluster_by", cluster_by)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if data_timestamp is not None:
            pulumi.set(__self__, "data_timestamp", data_timestamp)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if initialize is not None:
            pulumi.set(__self__, "initialize", initialize)
        if is_clone is not None:
            pulumi.set(__self__, "is_clone", is_clone)
        if is_replica is not None:
            pulumi.set(__self__, "is_replica", is_replica)
        if last_suspended_on is not None:
            pulumi.set(__self__, "last_suspended_on", last_suspended_on)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if or_replace is not None:
            pulumi.set(__self__, "or_replace", or_replace)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if refresh_mode is not None:
            pulumi.set(__self__, "refresh_mode", refresh_mode)
        if refresh_mode_reason is not None:
            pulumi.set(__self__, "refresh_mode_reason", refresh_mode_reason)
        if rows is not None:
            pulumi.set(__self__, "rows", rows)
        if scheduling_state is not None:
            pulumi.set(__self__, "scheduling_state", scheduling_state)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if target_lag is not None:
            pulumi.set(__self__, "target_lag", target_lag)
        if warehouse is not None:
            pulumi.set(__self__, "warehouse", warehouse)

    @_builtins.property
    @pulumi.getter(name="automaticClustering")
    def automatic_clustering(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether auto-clustering is enabled on the dynamic table. Not currently supported for dynamic tables.
        """
        return pulumi.get(self, "automatic_clustering")

    @automatic_clustering.setter
    def automatic_clustering(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "automatic_clustering", value)

    @_builtins.property
    @pulumi.getter
    def bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of bytes that will be scanned if the entire dynamic table is scanned in a query.
        """
        return pulumi.get(self, "bytes")

    @bytes.setter
    def bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bytes", value)

    @_builtins.property
    @pulumi.getter(name="clusterBy")
    def cluster_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The clustering key for the dynamic table.
        """
        return pulumi.get(self, "cluster_by")

    @cluster_by.setter
    def cluster_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_by", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the dynamic table.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time when this dynamic table was created.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_on", value)

    @_builtins.property
    @pulumi.getter(name="dataTimestamp")
    def data_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp of the data in the base object(s) that is included in the dynamic table.
        """
        return pulumi.get(self, "data_timestamp")

    @data_timestamp.setter
    def data_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_timestamp", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database in which to create the dynamic table.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @_builtins.property
    @pulumi.getter
    def initialize(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: `ON_CREATE`) Initialize trigger for the dynamic table. Can only be set on creation. Available options are ON*CREATE and ON*SCHEDULE.
        """
        return pulumi.get(self, "initialize")

    @initialize.setter
    def initialize(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "initialize", value)

    @_builtins.property
    @pulumi.getter(name="isClone")
    def is_clone(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        TRUE if the dynamic table has been cloned, else FALSE.
        """
        return pulumi.get(self, "is_clone")

    @is_clone.setter
    def is_clone(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_clone", value)

    @_builtins.property
    @pulumi.getter(name="isReplica")
    def is_replica(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        TRUE if the dynamic table is a replica. else FALSE.
        """
        return pulumi.get(self, "is_replica")

    @is_replica.setter
    def is_replica(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_replica", value)

    @_builtins.property
    @pulumi.getter(name="lastSuspendedOn")
    def last_suspended_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp of last suspension.
        """
        return pulumi.get(self, "last_suspended_on")

    @last_suspended_on.setter
    def last_suspended_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_suspended_on", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier (i.e. name) for the dynamic table; must be unique for the schema in which the dynamic table is created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orReplace")
    def or_replace(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Default: `false`) Specifies whether to replace the dynamic table if it already exists.
        """
        return pulumi.get(self, "or_replace")

    @or_replace.setter
    def or_replace(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "or_replace", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Role that owns the dynamic table.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the query to use to populate the dynamic table.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query", value)

    @_builtins.property
    @pulumi.getter(name="refreshMode")
    def refresh_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: `AUTO`) INCREMENTAL to use incremental refreshes, FULL to recompute the whole table on every refresh, or AUTO to let Snowflake decide.
        """
        return pulumi.get(self, "refresh_mode")

    @refresh_mode.setter
    def refresh_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "refresh_mode", value)

    @_builtins.property
    @pulumi.getter(name="refreshModeReason")
    def refresh_mode_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Explanation for why FULL refresh mode was chosen. NULL if refresh mode is not FULL.
        """
        return pulumi.get(self, "refresh_mode_reason")

    @refresh_mode_reason.setter
    def refresh_mode_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "refresh_mode_reason", value)

    @_builtins.property
    @pulumi.getter
    def rows(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of rows in the table.
        """
        return pulumi.get(self, "rows")

    @rows.setter
    def rows(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rows", value)

    @_builtins.property
    @pulumi.getter(name="schedulingState")
    def scheduling_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Displays ACTIVE for dynamic tables that are actively scheduling refreshes and SUSPENDED for suspended dynamic tables.
        """
        return pulumi.get(self, "scheduling_state")

    @scheduling_state.setter
    def scheduling_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduling_state", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schema in which to create the dynamic table.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="targetLag")
    def target_lag(self) -> Optional[pulumi.Input['DynamicTableTargetLagArgs']]:
        """
        Specifies the target lag time for the dynamic table.
        """
        return pulumi.get(self, "target_lag")

    @target_lag.setter
    def target_lag(self, value: Optional[pulumi.Input['DynamicTableTargetLagArgs']]):
        pulumi.set(self, "target_lag", value)

    @_builtins.property
    @pulumi.getter
    def warehouse(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The warehouse in which to create the dynamic table.
        """
        return pulumi.get(self, "warehouse")

    @warehouse.setter
    def warehouse(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "warehouse", value)


@pulumi.type_token("snowflake:index/dynamicTable:DynamicTable")
class DynamicTable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 initialize: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 or_replace: Optional[pulumi.Input[_builtins.bool]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 target_lag: Optional[pulumi.Input[Union['DynamicTableTargetLagArgs', 'DynamicTableTargetLagArgsDict']]] = None,
                 warehouse: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/dynamicTable:DynamicTable dt "mydb|myschema|product"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the dynamic table.
        :param pulumi.Input[_builtins.str] database: The database in which to create the dynamic table.
        :param pulumi.Input[_builtins.str] initialize: (Default: `ON_CREATE`) Initialize trigger for the dynamic table. Can only be set on creation. Available options are ON*CREATE and ON*SCHEDULE.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier (i.e. name) for the dynamic table; must be unique for the schema in which the dynamic table is created.
        :param pulumi.Input[_builtins.bool] or_replace: (Default: `false`) Specifies whether to replace the dynamic table if it already exists.
        :param pulumi.Input[_builtins.str] query: Specifies the query to use to populate the dynamic table.
        :param pulumi.Input[_builtins.str] refresh_mode: (Default: `AUTO`) INCREMENTAL to use incremental refreshes, FULL to recompute the whole table on every refresh, or AUTO to let Snowflake decide.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the dynamic table.
        :param pulumi.Input[Union['DynamicTableTargetLagArgs', 'DynamicTableTargetLagArgsDict']] target_lag: Specifies the target lag time for the dynamic table.
        :param pulumi.Input[_builtins.str] warehouse: The warehouse in which to create the dynamic table.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DynamicTableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/dynamicTable:DynamicTable dt "mydb|myschema|product"
        ```

        :param str resource_name: The name of the resource.
        :param DynamicTableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DynamicTableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 initialize: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 or_replace: Optional[pulumi.Input[_builtins.bool]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 target_lag: Optional[pulumi.Input[Union['DynamicTableTargetLagArgs', 'DynamicTableTargetLagArgsDict']]] = None,
                 warehouse: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DynamicTableArgs.__new__(DynamicTableArgs)

            __props__.__dict__["comment"] = comment
            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["initialize"] = initialize
            __props__.__dict__["name"] = name
            __props__.__dict__["or_replace"] = or_replace
            if query is None and not opts.urn:
                raise TypeError("Missing required property 'query'")
            __props__.__dict__["query"] = query
            __props__.__dict__["refresh_mode"] = refresh_mode
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
            if target_lag is None and not opts.urn:
                raise TypeError("Missing required property 'target_lag'")
            __props__.__dict__["target_lag"] = target_lag
            if warehouse is None and not opts.urn:
                raise TypeError("Missing required property 'warehouse'")
            __props__.__dict__["warehouse"] = warehouse
            __props__.__dict__["automatic_clustering"] = None
            __props__.__dict__["bytes"] = None
            __props__.__dict__["cluster_by"] = None
            __props__.__dict__["created_on"] = None
            __props__.__dict__["data_timestamp"] = None
            __props__.__dict__["fully_qualified_name"] = None
            __props__.__dict__["is_clone"] = None
            __props__.__dict__["is_replica"] = None
            __props__.__dict__["last_suspended_on"] = None
            __props__.__dict__["owner"] = None
            __props__.__dict__["refresh_mode_reason"] = None
            __props__.__dict__["rows"] = None
            __props__.__dict__["scheduling_state"] = None
        super(DynamicTable, __self__).__init__(
            'snowflake:index/dynamicTable:DynamicTable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            automatic_clustering: Optional[pulumi.Input[_builtins.bool]] = None,
            bytes: Optional[pulumi.Input[_builtins.int]] = None,
            cluster_by: Optional[pulumi.Input[_builtins.str]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            created_on: Optional[pulumi.Input[_builtins.str]] = None,
            data_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            database: Optional[pulumi.Input[_builtins.str]] = None,
            fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            initialize: Optional[pulumi.Input[_builtins.str]] = None,
            is_clone: Optional[pulumi.Input[_builtins.bool]] = None,
            is_replica: Optional[pulumi.Input[_builtins.bool]] = None,
            last_suspended_on: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            or_replace: Optional[pulumi.Input[_builtins.bool]] = None,
            owner: Optional[pulumi.Input[_builtins.str]] = None,
            query: Optional[pulumi.Input[_builtins.str]] = None,
            refresh_mode: Optional[pulumi.Input[_builtins.str]] = None,
            refresh_mode_reason: Optional[pulumi.Input[_builtins.str]] = None,
            rows: Optional[pulumi.Input[_builtins.int]] = None,
            scheduling_state: Optional[pulumi.Input[_builtins.str]] = None,
            schema: Optional[pulumi.Input[_builtins.str]] = None,
            target_lag: Optional[pulumi.Input[Union['DynamicTableTargetLagArgs', 'DynamicTableTargetLagArgsDict']]] = None,
            warehouse: Optional[pulumi.Input[_builtins.str]] = None) -> 'DynamicTable':
        """
        Get an existing DynamicTable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] automatic_clustering: Whether auto-clustering is enabled on the dynamic table. Not currently supported for dynamic tables.
        :param pulumi.Input[_builtins.int] bytes: Number of bytes that will be scanned if the entire dynamic table is scanned in a query.
        :param pulumi.Input[_builtins.str] cluster_by: The clustering key for the dynamic table.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the dynamic table.
        :param pulumi.Input[_builtins.str] created_on: Time when this dynamic table was created.
        :param pulumi.Input[_builtins.str] data_timestamp: Timestamp of the data in the base object(s) that is included in the dynamic table.
        :param pulumi.Input[_builtins.str] database: The database in which to create the dynamic table.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] initialize: (Default: `ON_CREATE`) Initialize trigger for the dynamic table. Can only be set on creation. Available options are ON*CREATE and ON*SCHEDULE.
        :param pulumi.Input[_builtins.bool] is_clone: TRUE if the dynamic table has been cloned, else FALSE.
        :param pulumi.Input[_builtins.bool] is_replica: TRUE if the dynamic table is a replica. else FALSE.
        :param pulumi.Input[_builtins.str] last_suspended_on: Timestamp of last suspension.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier (i.e. name) for the dynamic table; must be unique for the schema in which the dynamic table is created.
        :param pulumi.Input[_builtins.bool] or_replace: (Default: `false`) Specifies whether to replace the dynamic table if it already exists.
        :param pulumi.Input[_builtins.str] owner: Role that owns the dynamic table.
        :param pulumi.Input[_builtins.str] query: Specifies the query to use to populate the dynamic table.
        :param pulumi.Input[_builtins.str] refresh_mode: (Default: `AUTO`) INCREMENTAL to use incremental refreshes, FULL to recompute the whole table on every refresh, or AUTO to let Snowflake decide.
        :param pulumi.Input[_builtins.str] refresh_mode_reason: Explanation for why FULL refresh mode was chosen. NULL if refresh mode is not FULL.
        :param pulumi.Input[_builtins.int] rows: Number of rows in the table.
        :param pulumi.Input[_builtins.str] scheduling_state: Displays ACTIVE for dynamic tables that are actively scheduling refreshes and SUSPENDED for suspended dynamic tables.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the dynamic table.
        :param pulumi.Input[Union['DynamicTableTargetLagArgs', 'DynamicTableTargetLagArgsDict']] target_lag: Specifies the target lag time for the dynamic table.
        :param pulumi.Input[_builtins.str] warehouse: The warehouse in which to create the dynamic table.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DynamicTableState.__new__(_DynamicTableState)

        __props__.__dict__["automatic_clustering"] = automatic_clustering
        __props__.__dict__["bytes"] = bytes
        __props__.__dict__["cluster_by"] = cluster_by
        __props__.__dict__["comment"] = comment
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["data_timestamp"] = data_timestamp
        __props__.__dict__["database"] = database
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["initialize"] = initialize
        __props__.__dict__["is_clone"] = is_clone
        __props__.__dict__["is_replica"] = is_replica
        __props__.__dict__["last_suspended_on"] = last_suspended_on
        __props__.__dict__["name"] = name
        __props__.__dict__["or_replace"] = or_replace
        __props__.__dict__["owner"] = owner
        __props__.__dict__["query"] = query
        __props__.__dict__["refresh_mode"] = refresh_mode
        __props__.__dict__["refresh_mode_reason"] = refresh_mode_reason
        __props__.__dict__["rows"] = rows
        __props__.__dict__["scheduling_state"] = scheduling_state
        __props__.__dict__["schema"] = schema
        __props__.__dict__["target_lag"] = target_lag
        __props__.__dict__["warehouse"] = warehouse
        return DynamicTable(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="automaticClustering")
    def automatic_clustering(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether auto-clustering is enabled on the dynamic table. Not currently supported for dynamic tables.
        """
        return pulumi.get(self, "automatic_clustering")

    @_builtins.property
    @pulumi.getter
    def bytes(self) -> pulumi.Output[_builtins.int]:
        """
        Number of bytes that will be scanned if the entire dynamic table is scanned in a query.
        """
        return pulumi.get(self, "bytes")

    @_builtins.property
    @pulumi.getter(name="clusterBy")
    def cluster_by(self) -> pulumi.Output[_builtins.str]:
        """
        The clustering key for the dynamic table.
        """
        return pulumi.get(self, "cluster_by")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a comment for the dynamic table.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[_builtins.str]:
        """
        Time when this dynamic table was created.
        """
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter(name="dataTimestamp")
    def data_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp of the data in the base object(s) that is included in the dynamic table.
        """
        return pulumi.get(self, "data_timestamp")

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Output[_builtins.str]:
        """
        The database in which to create the dynamic table.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @_builtins.property
    @pulumi.getter
    def initialize(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: `ON_CREATE`) Initialize trigger for the dynamic table. Can only be set on creation. Available options are ON*CREATE and ON*SCHEDULE.
        """
        return pulumi.get(self, "initialize")

    @_builtins.property
    @pulumi.getter(name="isClone")
    def is_clone(self) -> pulumi.Output[_builtins.bool]:
        """
        TRUE if the dynamic table has been cloned, else FALSE.
        """
        return pulumi.get(self, "is_clone")

    @_builtins.property
    @pulumi.getter(name="isReplica")
    def is_replica(self) -> pulumi.Output[_builtins.bool]:
        """
        TRUE if the dynamic table is a replica. else FALSE.
        """
        return pulumi.get(self, "is_replica")

    @_builtins.property
    @pulumi.getter(name="lastSuspendedOn")
    def last_suspended_on(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp of last suspension.
        """
        return pulumi.get(self, "last_suspended_on")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the identifier (i.e. name) for the dynamic table; must be unique for the schema in which the dynamic table is created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orReplace")
    def or_replace(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        (Default: `false`) Specifies whether to replace the dynamic table if it already exists.
        """
        return pulumi.get(self, "or_replace")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output[_builtins.str]:
        """
        Role that owns the dynamic table.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def query(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the query to use to populate the dynamic table.
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter(name="refreshMode")
    def refresh_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: `AUTO`) INCREMENTAL to use incremental refreshes, FULL to recompute the whole table on every refresh, or AUTO to let Snowflake decide.
        """
        return pulumi.get(self, "refresh_mode")

    @_builtins.property
    @pulumi.getter(name="refreshModeReason")
    def refresh_mode_reason(self) -> pulumi.Output[_builtins.str]:
        """
        Explanation for why FULL refresh mode was chosen. NULL if refresh mode is not FULL.
        """
        return pulumi.get(self, "refresh_mode_reason")

    @_builtins.property
    @pulumi.getter
    def rows(self) -> pulumi.Output[_builtins.int]:
        """
        Number of rows in the table.
        """
        return pulumi.get(self, "rows")

    @_builtins.property
    @pulumi.getter(name="schedulingState")
    def scheduling_state(self) -> pulumi.Output[_builtins.str]:
        """
        Displays ACTIVE for dynamic tables that are actively scheduling refreshes and SUSPENDED for suspended dynamic tables.
        """
        return pulumi.get(self, "scheduling_state")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Output[_builtins.str]:
        """
        The schema in which to create the dynamic table.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="targetLag")
    def target_lag(self) -> pulumi.Output['outputs.DynamicTableTargetLag']:
        """
        Specifies the target lag time for the dynamic table.
        """
        return pulumi.get(self, "target_lag")

    @_builtins.property
    @pulumi.getter
    def warehouse(self) -> pulumi.Output[_builtins.str]:
        """
        The warehouse in which to create the dynamic table.
        """
        return pulumi.get(self, "warehouse")

