# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetParametersResult',
    'AwaitableGetParametersResult',
    'get_parameters',
    'get_parameters_output',
]

@pulumi.output_type
class GetParametersResult:
    """
    A collection of values returned by getParameters.
    """
    def __init__(__self__, id=None, object_name=None, object_type=None, parameter_type=None, parameters=None, pattern=None, user=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if object_name and not isinstance(object_name, str):
            raise TypeError("Expected argument 'object_name' to be a str")
        pulumi.set(__self__, "object_name", object_name)
        if object_type and not isinstance(object_type, str):
            raise TypeError("Expected argument 'object_type' to be a str")
        pulumi.set(__self__, "object_type", object_type)
        if parameter_type and not isinstance(parameter_type, str):
            raise TypeError("Expected argument 'parameter_type' to be a str")
        pulumi.set(__self__, "parameter_type", parameter_type)
        if parameters and not isinstance(parameters, list):
            raise TypeError("Expected argument 'parameters' to be a list")
        pulumi.set(__self__, "parameters", parameters)
        if pattern and not isinstance(pattern, str):
            raise TypeError("Expected argument 'pattern' to be a str")
        pulumi.set(__self__, "pattern", pattern)
        if user and not isinstance(user, str):
            raise TypeError("Expected argument 'user' to be a str")
        pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="objectName")
    def object_name(self) -> Optional[_builtins.str]:
        """
        If parameter*type is set to "OBJECT" then object*name is the name of the object to display object parameters for.
        """
        return pulumi.get(self, "object_name")

    @_builtins.property
    @pulumi.getter(name="objectType")
    def object_type(self) -> Optional[_builtins.str]:
        """
        If parameter*type is set to "OBJECT" then object*type is the type of object to display object parameters for. Valid values are any object supported by the IN clause of the [SHOW PARAMETERS](https://docs.snowflake.com/en/sql-reference/sql/show-parameters.html#parameters) statement, including: WAREHOUSE | DATABASE | SCHEMA | TASK | TABLE
        """
        return pulumi.get(self, "object_type")

    @_builtins.property
    @pulumi.getter(name="parameterType")
    def parameter_type(self) -> Optional[_builtins.str]:
        """
        (Default: `ACCOUNT`) The type of parameter to filter by. Valid values are: "ACCOUNT", "SESSION", "OBJECT".
        """
        return pulumi.get(self, "parameter_type")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.GetParametersParameterResult']:
        """
        The pipes in the schema
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> Optional[_builtins.str]:
        """
        Allows limiting the list of parameters by name using LIKE clause. Refer to [Limiting the List of Parameters by Name](https://docs.snowflake.com/en/sql-reference/parameters.html#limiting-the-list-of-parameters-by-name)
        """
        return pulumi.get(self, "pattern")

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[_builtins.str]:
        """
        If parameter_type is set to "SESSION" then user is the name of the user to display session parameters for.
        """
        return pulumi.get(self, "user")


class AwaitableGetParametersResult(GetParametersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetParametersResult(
            id=self.id,
            object_name=self.object_name,
            object_type=self.object_type,
            parameter_type=self.parameter_type,
            parameters=self.parameters,
            pattern=self.pattern,
            user=self.user)


def get_parameters(object_name: Optional[_builtins.str] = None,
                   object_type: Optional[_builtins.str] = None,
                   parameter_type: Optional[_builtins.str] = None,
                   pattern: Optional[_builtins.str] = None,
                   user: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetParametersResult:
    """
    !> **Caution: Preview Feature** This feature is considered a preview feature in the provider, regardless of the state of the resource in Snowflake. We do not guarantee its stability. It will be reworked and marked as a stable feature in future releases. Breaking changes are expected, even without bumping the major version. To use this feature, add the relevant feature name to `preview_features_enabled` field in the provider configuration. Please always refer to the Getting Help section in our Github repo to best determine how to get help for your questions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_snowflake as snowflake

    d = snowflake.Database("d", name="TEST_DB")
    # read all object parameters in database TEST_DB
    p = snowflake.get_parameters_output(parameter_type="OBJECT",
        object_type="DATABASE",
        object_name=d.name)
    # read all account parameters with the pattern '%TIMESTAMP%'
    p2 = snowflake.get_parameters(parameter_type="ACCOUNT",
        pattern="%TIMESTAMP%")
    # read the exact session parameter ROWS_PER_RESULTSET
    p3 = snowflake.get_parameters(parameter_type="SESSION",
        pattern="ROWS_PER_RESULTSET",
        user="TEST_USER")
    ```

    > **Note** If a field has a default value, it is shown next to the type in the schema.


    :param _builtins.str object_name: If parameter*type is set to "OBJECT" then object*name is the name of the object to display object parameters for.
    :param _builtins.str object_type: If parameter*type is set to "OBJECT" then object*type is the type of object to display object parameters for. Valid values are any object supported by the IN clause of the [SHOW PARAMETERS](https://docs.snowflake.com/en/sql-reference/sql/show-parameters.html#parameters) statement, including: WAREHOUSE | DATABASE | SCHEMA | TASK | TABLE
    :param _builtins.str parameter_type: (Default: `ACCOUNT`) The type of parameter to filter by. Valid values are: "ACCOUNT", "SESSION", "OBJECT".
    :param _builtins.str pattern: Allows limiting the list of parameters by name using LIKE clause. Refer to [Limiting the List of Parameters by Name](https://docs.snowflake.com/en/sql-reference/parameters.html#limiting-the-list-of-parameters-by-name)
    :param _builtins.str user: If parameter_type is set to "SESSION" then user is the name of the user to display session parameters for.
    """
    __args__ = dict()
    __args__['objectName'] = object_name
    __args__['objectType'] = object_type
    __args__['parameterType'] = parameter_type
    __args__['pattern'] = pattern
    __args__['user'] = user
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('snowflake:index/getParameters:getParameters', __args__, opts=opts, typ=GetParametersResult).value

    return AwaitableGetParametersResult(
        id=pulumi.get(__ret__, 'id'),
        object_name=pulumi.get(__ret__, 'object_name'),
        object_type=pulumi.get(__ret__, 'object_type'),
        parameter_type=pulumi.get(__ret__, 'parameter_type'),
        parameters=pulumi.get(__ret__, 'parameters'),
        pattern=pulumi.get(__ret__, 'pattern'),
        user=pulumi.get(__ret__, 'user'))
def get_parameters_output(object_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          object_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          parameter_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          pattern: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          user: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetParametersResult]:
    """
    !> **Caution: Preview Feature** This feature is considered a preview feature in the provider, regardless of the state of the resource in Snowflake. We do not guarantee its stability. It will be reworked and marked as a stable feature in future releases. Breaking changes are expected, even without bumping the major version. To use this feature, add the relevant feature name to `preview_features_enabled` field in the provider configuration. Please always refer to the Getting Help section in our Github repo to best determine how to get help for your questions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_snowflake as snowflake

    d = snowflake.Database("d", name="TEST_DB")
    # read all object parameters in database TEST_DB
    p = snowflake.get_parameters_output(parameter_type="OBJECT",
        object_type="DATABASE",
        object_name=d.name)
    # read all account parameters with the pattern '%TIMESTAMP%'
    p2 = snowflake.get_parameters(parameter_type="ACCOUNT",
        pattern="%TIMESTAMP%")
    # read the exact session parameter ROWS_PER_RESULTSET
    p3 = snowflake.get_parameters(parameter_type="SESSION",
        pattern="ROWS_PER_RESULTSET",
        user="TEST_USER")
    ```

    > **Note** If a field has a default value, it is shown next to the type in the schema.


    :param _builtins.str object_name: If parameter*type is set to "OBJECT" then object*name is the name of the object to display object parameters for.
    :param _builtins.str object_type: If parameter*type is set to "OBJECT" then object*type is the type of object to display object parameters for. Valid values are any object supported by the IN clause of the [SHOW PARAMETERS](https://docs.snowflake.com/en/sql-reference/sql/show-parameters.html#parameters) statement, including: WAREHOUSE | DATABASE | SCHEMA | TASK | TABLE
    :param _builtins.str parameter_type: (Default: `ACCOUNT`) The type of parameter to filter by. Valid values are: "ACCOUNT", "SESSION", "OBJECT".
    :param _builtins.str pattern: Allows limiting the list of parameters by name using LIKE clause. Refer to [Limiting the List of Parameters by Name](https://docs.snowflake.com/en/sql-reference/parameters.html#limiting-the-list-of-parameters-by-name)
    :param _builtins.str user: If parameter_type is set to "SESSION" then user is the name of the user to display session parameters for.
    """
    __args__ = dict()
    __args__['objectName'] = object_name
    __args__['objectType'] = object_type
    __args__['parameterType'] = parameter_type
    __args__['pattern'] = pattern
    __args__['user'] = user
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('snowflake:index/getParameters:getParameters', __args__, opts=opts, typ=GetParametersResult)
    return __ret__.apply(lambda __response__: GetParametersResult(
        id=pulumi.get(__response__, 'id'),
        object_name=pulumi.get(__response__, 'object_name'),
        object_type=pulumi.get(__response__, 'object_type'),
        parameter_type=pulumi.get(__response__, 'parameter_type'),
        parameters=pulumi.get(__response__, 'parameters'),
        pattern=pulumi.get(__response__, 'pattern'),
        user=pulumi.get(__response__, 'user')))
