# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GrantAccountRoleArgs', 'GrantAccountRole']

@pulumi.input_type
class GrantAccountRoleArgs:
    def __init__(__self__, *,
                 role_name: pulumi.Input[_builtins.str],
                 parent_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GrantAccountRole resource.
        :param pulumi.Input[_builtins.str] role_name: The fully qualified name of the role which will be granted to the user or parent role. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] parent_role_name: The fully qualified name of the parent role which will create a parent-child relationship between the roles. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] user_name: The fully qualified name of the user on which specified role will be granted. For more information about this resource, see docs.
        """
        pulumi.set(__self__, "role_name", role_name)
        if parent_role_name is not None:
            pulumi.set(__self__, "parent_role_name", parent_role_name)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Input[_builtins.str]:
        """
        The fully qualified name of the role which will be granted to the user or parent role. For more information about this resource, see docs.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter(name="parentRoleName")
    def parent_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the parent role which will create a parent-child relationship between the roles. For more information about this resource, see docs.
        """
        return pulumi.get(self, "parent_role_name")

    @parent_role_name.setter
    def parent_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_role_name", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the user on which specified role will be granted. For more information about this resource, see docs.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class _GrantAccountRoleState:
    def __init__(__self__, *,
                 parent_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GrantAccountRole resources.
        :param pulumi.Input[_builtins.str] parent_role_name: The fully qualified name of the parent role which will create a parent-child relationship between the roles. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] role_name: The fully qualified name of the role which will be granted to the user or parent role. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] user_name: The fully qualified name of the user on which specified role will be granted. For more information about this resource, see docs.
        """
        if parent_role_name is not None:
            pulumi.set(__self__, "parent_role_name", parent_role_name)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="parentRoleName")
    def parent_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the parent role which will create a parent-child relationship between the roles. For more information about this resource, see docs.
        """
        return pulumi.get(self, "parent_role_name")

    @parent_role_name.setter
    def parent_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_role_name", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the role which will be granted to the user or parent role. For more information about this resource, see docs.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the user on which specified role will be granted. For more information about this resource, see docs.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)


@pulumi.type_token("snowflake:index/grantAccountRole:GrantAccountRole")
class GrantAccountRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 parent_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        format is role_name (string) | grantee_object_type (ROLE|USER) | grantee_name (string)

        ```sh
        $ pulumi import snowflake:index/grantAccountRole:GrantAccountRole example '"test_role"|ROLE|"test_parent_role"'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] parent_role_name: The fully qualified name of the parent role which will create a parent-child relationship between the roles. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] role_name: The fully qualified name of the role which will be granted to the user or parent role. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] user_name: The fully qualified name of the user on which specified role will be granted. For more information about this resource, see docs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GrantAccountRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        format is role_name (string) | grantee_object_type (ROLE|USER) | grantee_name (string)

        ```sh
        $ pulumi import snowflake:index/grantAccountRole:GrantAccountRole example '"test_role"|ROLE|"test_parent_role"'
        ```

        :param str resource_name: The name of the resource.
        :param GrantAccountRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GrantAccountRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 parent_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GrantAccountRoleArgs.__new__(GrantAccountRoleArgs)

            __props__.__dict__["parent_role_name"] = parent_role_name
            if role_name is None and not opts.urn:
                raise TypeError("Missing required property 'role_name'")
            __props__.__dict__["role_name"] = role_name
            __props__.__dict__["user_name"] = user_name
        super(GrantAccountRole, __self__).__init__(
            'snowflake:index/grantAccountRole:GrantAccountRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            parent_role_name: Optional[pulumi.Input[_builtins.str]] = None,
            role_name: Optional[pulumi.Input[_builtins.str]] = None,
            user_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'GrantAccountRole':
        """
        Get an existing GrantAccountRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] parent_role_name: The fully qualified name of the parent role which will create a parent-child relationship between the roles. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] role_name: The fully qualified name of the role which will be granted to the user or parent role. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] user_name: The fully qualified name of the user on which specified role will be granted. For more information about this resource, see docs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GrantAccountRoleState.__new__(_GrantAccountRoleState)

        __props__.__dict__["parent_role_name"] = parent_role_name
        __props__.__dict__["role_name"] = role_name
        __props__.__dict__["user_name"] = user_name
        return GrantAccountRole(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="parentRoleName")
    def parent_role_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The fully qualified name of the parent role which will create a parent-child relationship between the roles. For more information about this resource, see docs.
        """
        return pulumi.get(self, "parent_role_name")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified name of the role which will be granted to the user or parent role. For more information about this resource, see docs.
        """
        return pulumi.get(self, "role_name")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The fully qualified name of the user on which specified role will be granted. For more information about this resource, see docs.
        """
        return pulumi.get(self, "user_name")

