# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ViewArgs', 'View']

@pulumi.input_type
class ViewArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[_builtins.str],
                 schema: pulumi.Input[_builtins.str],
                 statement: pulumi.Input[_builtins.str],
                 aggregation_policy: Optional[pulumi.Input['ViewAggregationPolicyArgs']] = None,
                 change_tracking: Optional[pulumi.Input[_builtins.str]] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input['ViewColumnArgs']]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_grants: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_metric_functions: Optional[pulumi.Input[Sequence[pulumi.Input['ViewDataMetricFunctionArgs']]]] = None,
                 data_metric_schedule: Optional[pulumi.Input['ViewDataMetricScheduleArgs']] = None,
                 is_recursive: Optional[pulumi.Input[_builtins.str]] = None,
                 is_secure: Optional[pulumi.Input[_builtins.str]] = None,
                 is_temporary: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 row_access_policy: Optional[pulumi.Input['ViewRowAccessPolicyArgs']] = None):
        """
        The set of arguments for constructing a View resource.
        :param pulumi.Input[_builtins.str] database: The database in which to create the view. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the view. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] statement: Specifies the query used to create the view. To mitigate permadiff on this field, the provider replaces blank characters with a space. This can lead to false positives in cases where a change in case or run of whitespace is semantically significant.
        :param pulumi.Input['ViewAggregationPolicyArgs'] aggregation_policy: Specifies the aggregation policy to set on a view.
        :param pulumi.Input[_builtins.str] change_tracking: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies to enable or disable change tracking on the table. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[Sequence[pulumi.Input['ViewColumnArgs']]] columns: If you want to change the name of a column or add a comment to a column in the new view, include a column list that specifies the column names and (if needed) comments about the columns. You do not need to specify the data types of the columns. If this field is not specified, columns are inferred from the `statement` field by Snowflake.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the view.
        :param pulumi.Input[Sequence[pulumi.Input['ViewDataMetricFunctionArgs']]] data_metric_functions: Data metric functions used for the view.
        :param pulumi.Input['ViewDataMetricScheduleArgs'] data_metric_schedule: Specifies the schedule to run the data metric functions periodically.
        :param pulumi.Input[_builtins.str] is_recursive: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies that the view can refer to itself using recursive syntax without necessarily using a CTE (common table expression). Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the view; must be unique for the schema in which the view is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input['ViewRowAccessPolicyArgs'] row_access_policy: Specifies the row access policy to set on a view.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "schema", schema)
        pulumi.set(__self__, "statement", statement)
        if aggregation_policy is not None:
            pulumi.set(__self__, "aggregation_policy", aggregation_policy)
        if change_tracking is not None:
            pulumi.set(__self__, "change_tracking", change_tracking)
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if copy_grants is not None:
            pulumi.set(__self__, "copy_grants", copy_grants)
        if data_metric_functions is not None:
            pulumi.set(__self__, "data_metric_functions", data_metric_functions)
        if data_metric_schedule is not None:
            pulumi.set(__self__, "data_metric_schedule", data_metric_schedule)
        if is_recursive is not None:
            pulumi.set(__self__, "is_recursive", is_recursive)
        if is_secure is not None:
            pulumi.set(__self__, "is_secure", is_secure)
        if is_temporary is not None:
            pulumi.set(__self__, "is_temporary", is_temporary)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if row_access_policy is not None:
            pulumi.set(__self__, "row_access_policy", row_access_policy)

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Input[_builtins.str]:
        """
        The database in which to create the view. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Input[_builtins.str]:
        """
        The schema in which to create the view. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter
    def statement(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the query used to create the view. To mitigate permadiff on this field, the provider replaces blank characters with a space. This can lead to false positives in cases where a change in case or run of whitespace is semantically significant.
        """
        return pulumi.get(self, "statement")

    @statement.setter
    def statement(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "statement", value)

    @_builtins.property
    @pulumi.getter(name="aggregationPolicy")
    def aggregation_policy(self) -> Optional[pulumi.Input['ViewAggregationPolicyArgs']]:
        """
        Specifies the aggregation policy to set on a view.
        """
        return pulumi.get(self, "aggregation_policy")

    @aggregation_policy.setter
    def aggregation_policy(self, value: Optional[pulumi.Input['ViewAggregationPolicyArgs']]):
        pulumi.set(self, "aggregation_policy", value)

    @_builtins.property
    @pulumi.getter(name="changeTracking")
    def change_tracking(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies to enable or disable change tracking on the table. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "change_tracking")

    @change_tracking.setter
    def change_tracking(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "change_tracking", value)

    @_builtins.property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ViewColumnArgs']]]]:
        """
        If you want to change the name of a column or add a comment to a column in the new view, include a column list that specifies the column names and (if needed) comments about the columns. You do not need to specify the data types of the columns. If this field is not specified, columns are inferred from the `statement` field by Snowflake.
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ViewColumnArgs']]]]):
        pulumi.set(self, "columns", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the view.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="copyGrants")
    def copy_grants(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "copy_grants")

    @copy_grants.setter
    def copy_grants(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "copy_grants", value)

    @_builtins.property
    @pulumi.getter(name="dataMetricFunctions")
    def data_metric_functions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ViewDataMetricFunctionArgs']]]]:
        """
        Data metric functions used for the view.
        """
        return pulumi.get(self, "data_metric_functions")

    @data_metric_functions.setter
    def data_metric_functions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ViewDataMetricFunctionArgs']]]]):
        pulumi.set(self, "data_metric_functions", value)

    @_builtins.property
    @pulumi.getter(name="dataMetricSchedule")
    def data_metric_schedule(self) -> Optional[pulumi.Input['ViewDataMetricScheduleArgs']]:
        """
        Specifies the schedule to run the data metric functions periodically.
        """
        return pulumi.get(self, "data_metric_schedule")

    @data_metric_schedule.setter
    def data_metric_schedule(self, value: Optional[pulumi.Input['ViewDataMetricScheduleArgs']]):
        pulumi.set(self, "data_metric_schedule", value)

    @_builtins.property
    @pulumi.getter(name="isRecursive")
    def is_recursive(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies that the view can refer to itself using recursive syntax without necessarily using a CTE (common table expression). Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "is_recursive")

    @is_recursive.setter
    def is_recursive(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "is_recursive", value)

    @_builtins.property
    @pulumi.getter(name="isSecure")
    def is_secure(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "is_secure")

    @is_secure.setter
    def is_secure(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "is_secure", value)

    @_builtins.property
    @pulumi.getter(name="isTemporary")
    def is_temporary(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "is_temporary")

    @is_temporary.setter
    def is_temporary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "is_temporary", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the view; must be unique for the schema in which the view is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="rowAccessPolicy")
    def row_access_policy(self) -> Optional[pulumi.Input['ViewRowAccessPolicyArgs']]:
        """
        Specifies the row access policy to set on a view.
        """
        return pulumi.get(self, "row_access_policy")

    @row_access_policy.setter
    def row_access_policy(self, value: Optional[pulumi.Input['ViewRowAccessPolicyArgs']]):
        pulumi.set(self, "row_access_policy", value)


@pulumi.input_type
class _ViewState:
    def __init__(__self__, *,
                 aggregation_policy: Optional[pulumi.Input['ViewAggregationPolicyArgs']] = None,
                 change_tracking: Optional[pulumi.Input[_builtins.str]] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input['ViewColumnArgs']]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_grants: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_metric_functions: Optional[pulumi.Input[Sequence[pulumi.Input['ViewDataMetricFunctionArgs']]]] = None,
                 data_metric_schedule: Optional[pulumi.Input['ViewDataMetricScheduleArgs']] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 describe_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['ViewDescribeOutputArgs']]]] = None,
                 fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 is_recursive: Optional[pulumi.Input[_builtins.str]] = None,
                 is_secure: Optional[pulumi.Input[_builtins.str]] = None,
                 is_temporary: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 row_access_policy: Optional[pulumi.Input['ViewRowAccessPolicyArgs']] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['ViewShowOutputArgs']]]] = None,
                 statement: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering View resources.
        :param pulumi.Input['ViewAggregationPolicyArgs'] aggregation_policy: Specifies the aggregation policy to set on a view.
        :param pulumi.Input[_builtins.str] change_tracking: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies to enable or disable change tracking on the table. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[Sequence[pulumi.Input['ViewColumnArgs']]] columns: If you want to change the name of a column or add a comment to a column in the new view, include a column list that specifies the column names and (if needed) comments about the columns. You do not need to specify the data types of the columns. If this field is not specified, columns are inferred from the `statement` field by Snowflake.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the view.
        :param pulumi.Input[Sequence[pulumi.Input['ViewDataMetricFunctionArgs']]] data_metric_functions: Data metric functions used for the view.
        :param pulumi.Input['ViewDataMetricScheduleArgs'] data_metric_schedule: Specifies the schedule to run the data metric functions periodically.
        :param pulumi.Input[_builtins.str] database: The database in which to create the view. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input['ViewDescribeOutputArgs']]] describe_outputs: Outputs the result of `DESCRIBE VIEW` for the given view.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] is_recursive: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies that the view can refer to itself using recursive syntax without necessarily using a CTE (common table expression). Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the view; must be unique for the schema in which the view is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input['ViewRowAccessPolicyArgs'] row_access_policy: Specifies the row access policy to set on a view.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the view. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input['ViewShowOutputArgs']]] show_outputs: Outputs the result of `SHOW VIEW` for the given view.
        :param pulumi.Input[_builtins.str] statement: Specifies the query used to create the view. To mitigate permadiff on this field, the provider replaces blank characters with a space. This can lead to false positives in cases where a change in case or run of whitespace is semantically significant.
        """
        if aggregation_policy is not None:
            pulumi.set(__self__, "aggregation_policy", aggregation_policy)
        if change_tracking is not None:
            pulumi.set(__self__, "change_tracking", change_tracking)
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if copy_grants is not None:
            pulumi.set(__self__, "copy_grants", copy_grants)
        if data_metric_functions is not None:
            pulumi.set(__self__, "data_metric_functions", data_metric_functions)
        if data_metric_schedule is not None:
            pulumi.set(__self__, "data_metric_schedule", data_metric_schedule)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if describe_outputs is not None:
            pulumi.set(__self__, "describe_outputs", describe_outputs)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if is_recursive is not None:
            pulumi.set(__self__, "is_recursive", is_recursive)
        if is_secure is not None:
            pulumi.set(__self__, "is_secure", is_secure)
        if is_temporary is not None:
            pulumi.set(__self__, "is_temporary", is_temporary)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if row_access_policy is not None:
            pulumi.set(__self__, "row_access_policy", row_access_policy)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if show_outputs is not None:
            pulumi.set(__self__, "show_outputs", show_outputs)
        if statement is not None:
            pulumi.set(__self__, "statement", statement)

    @_builtins.property
    @pulumi.getter(name="aggregationPolicy")
    def aggregation_policy(self) -> Optional[pulumi.Input['ViewAggregationPolicyArgs']]:
        """
        Specifies the aggregation policy to set on a view.
        """
        return pulumi.get(self, "aggregation_policy")

    @aggregation_policy.setter
    def aggregation_policy(self, value: Optional[pulumi.Input['ViewAggregationPolicyArgs']]):
        pulumi.set(self, "aggregation_policy", value)

    @_builtins.property
    @pulumi.getter(name="changeTracking")
    def change_tracking(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies to enable or disable change tracking on the table. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "change_tracking")

    @change_tracking.setter
    def change_tracking(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "change_tracking", value)

    @_builtins.property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ViewColumnArgs']]]]:
        """
        If you want to change the name of a column or add a comment to a column in the new view, include a column list that specifies the column names and (if needed) comments about the columns. You do not need to specify the data types of the columns. If this field is not specified, columns are inferred from the `statement` field by Snowflake.
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ViewColumnArgs']]]]):
        pulumi.set(self, "columns", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the view.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="copyGrants")
    def copy_grants(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "copy_grants")

    @copy_grants.setter
    def copy_grants(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "copy_grants", value)

    @_builtins.property
    @pulumi.getter(name="dataMetricFunctions")
    def data_metric_functions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ViewDataMetricFunctionArgs']]]]:
        """
        Data metric functions used for the view.
        """
        return pulumi.get(self, "data_metric_functions")

    @data_metric_functions.setter
    def data_metric_functions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ViewDataMetricFunctionArgs']]]]):
        pulumi.set(self, "data_metric_functions", value)

    @_builtins.property
    @pulumi.getter(name="dataMetricSchedule")
    def data_metric_schedule(self) -> Optional[pulumi.Input['ViewDataMetricScheduleArgs']]:
        """
        Specifies the schedule to run the data metric functions periodically.
        """
        return pulumi.get(self, "data_metric_schedule")

    @data_metric_schedule.setter
    def data_metric_schedule(self, value: Optional[pulumi.Input['ViewDataMetricScheduleArgs']]):
        pulumi.set(self, "data_metric_schedule", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database in which to create the view. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter(name="describeOutputs")
    def describe_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ViewDescribeOutputArgs']]]]:
        """
        Outputs the result of `DESCRIBE VIEW` for the given view.
        """
        return pulumi.get(self, "describe_outputs")

    @describe_outputs.setter
    def describe_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ViewDescribeOutputArgs']]]]):
        pulumi.set(self, "describe_outputs", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @_builtins.property
    @pulumi.getter(name="isRecursive")
    def is_recursive(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies that the view can refer to itself using recursive syntax without necessarily using a CTE (common table expression). Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "is_recursive")

    @is_recursive.setter
    def is_recursive(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "is_recursive", value)

    @_builtins.property
    @pulumi.getter(name="isSecure")
    def is_secure(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "is_secure")

    @is_secure.setter
    def is_secure(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "is_secure", value)

    @_builtins.property
    @pulumi.getter(name="isTemporary")
    def is_temporary(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "is_temporary")

    @is_temporary.setter
    def is_temporary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "is_temporary", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the view; must be unique for the schema in which the view is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="rowAccessPolicy")
    def row_access_policy(self) -> Optional[pulumi.Input['ViewRowAccessPolicyArgs']]:
        """
        Specifies the row access policy to set on a view.
        """
        return pulumi.get(self, "row_access_policy")

    @row_access_policy.setter
    def row_access_policy(self, value: Optional[pulumi.Input['ViewRowAccessPolicyArgs']]):
        pulumi.set(self, "row_access_policy", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schema in which to create the view. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ViewShowOutputArgs']]]]:
        """
        Outputs the result of `SHOW VIEW` for the given view.
        """
        return pulumi.get(self, "show_outputs")

    @show_outputs.setter
    def show_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ViewShowOutputArgs']]]]):
        pulumi.set(self, "show_outputs", value)

    @_builtins.property
    @pulumi.getter
    def statement(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the query used to create the view. To mitigate permadiff on this field, the provider replaces blank characters with a space. This can lead to false positives in cases where a change in case or run of whitespace is semantically significant.
        """
        return pulumi.get(self, "statement")

    @statement.setter
    def statement(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "statement", value)


@pulumi.type_token("snowflake:index/view:View")
class View(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregation_policy: Optional[pulumi.Input[Union['ViewAggregationPolicyArgs', 'ViewAggregationPolicyArgsDict']]] = None,
                 change_tracking: Optional[pulumi.Input[_builtins.str]] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ViewColumnArgs', 'ViewColumnArgsDict']]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_grants: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_metric_functions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ViewDataMetricFunctionArgs', 'ViewDataMetricFunctionArgsDict']]]]] = None,
                 data_metric_schedule: Optional[pulumi.Input[Union['ViewDataMetricScheduleArgs', 'ViewDataMetricScheduleArgsDict']]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 is_recursive: Optional[pulumi.Input[_builtins.str]] = None,
                 is_secure: Optional[pulumi.Input[_builtins.str]] = None,
                 is_temporary: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 row_access_policy: Optional[pulumi.Input[Union['ViewRowAccessPolicyArgs', 'ViewRowAccessPolicyArgsDict']]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 statement: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/view:View example '"<database_name>"."<schema_name>"."<view_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ViewAggregationPolicyArgs', 'ViewAggregationPolicyArgsDict']] aggregation_policy: Specifies the aggregation policy to set on a view.
        :param pulumi.Input[_builtins.str] change_tracking: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies to enable or disable change tracking on the table. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ViewColumnArgs', 'ViewColumnArgsDict']]]] columns: If you want to change the name of a column or add a comment to a column in the new view, include a column list that specifies the column names and (if needed) comments about the columns. You do not need to specify the data types of the columns. If this field is not specified, columns are inferred from the `statement` field by Snowflake.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the view.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ViewDataMetricFunctionArgs', 'ViewDataMetricFunctionArgsDict']]]] data_metric_functions: Data metric functions used for the view.
        :param pulumi.Input[Union['ViewDataMetricScheduleArgs', 'ViewDataMetricScheduleArgsDict']] data_metric_schedule: Specifies the schedule to run the data metric functions periodically.
        :param pulumi.Input[_builtins.str] database: The database in which to create the view. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] is_recursive: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies that the view can refer to itself using recursive syntax without necessarily using a CTE (common table expression). Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the view; must be unique for the schema in which the view is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Union['ViewRowAccessPolicyArgs', 'ViewRowAccessPolicyArgsDict']] row_access_policy: Specifies the row access policy to set on a view.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the view. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] statement: Specifies the query used to create the view. To mitigate permadiff on this field, the provider replaces blank characters with a space. This can lead to false positives in cases where a change in case or run of whitespace is semantically significant.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ViewArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/view:View example '"<database_name>"."<schema_name>"."<view_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param ViewArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ViewArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregation_policy: Optional[pulumi.Input[Union['ViewAggregationPolicyArgs', 'ViewAggregationPolicyArgsDict']]] = None,
                 change_tracking: Optional[pulumi.Input[_builtins.str]] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ViewColumnArgs', 'ViewColumnArgsDict']]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_grants: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_metric_functions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ViewDataMetricFunctionArgs', 'ViewDataMetricFunctionArgsDict']]]]] = None,
                 data_metric_schedule: Optional[pulumi.Input[Union['ViewDataMetricScheduleArgs', 'ViewDataMetricScheduleArgsDict']]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 is_recursive: Optional[pulumi.Input[_builtins.str]] = None,
                 is_secure: Optional[pulumi.Input[_builtins.str]] = None,
                 is_temporary: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 row_access_policy: Optional[pulumi.Input[Union['ViewRowAccessPolicyArgs', 'ViewRowAccessPolicyArgsDict']]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 statement: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ViewArgs.__new__(ViewArgs)

            __props__.__dict__["aggregation_policy"] = aggregation_policy
            __props__.__dict__["change_tracking"] = change_tracking
            __props__.__dict__["columns"] = columns
            __props__.__dict__["comment"] = comment
            __props__.__dict__["copy_grants"] = copy_grants
            __props__.__dict__["data_metric_functions"] = data_metric_functions
            __props__.__dict__["data_metric_schedule"] = data_metric_schedule
            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["is_recursive"] = is_recursive
            __props__.__dict__["is_secure"] = is_secure
            __props__.__dict__["is_temporary"] = is_temporary
            __props__.__dict__["name"] = name
            __props__.__dict__["row_access_policy"] = row_access_policy
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
            if statement is None and not opts.urn:
                raise TypeError("Missing required property 'statement'")
            __props__.__dict__["statement"] = statement
            __props__.__dict__["describe_outputs"] = None
            __props__.__dict__["fully_qualified_name"] = None
            __props__.__dict__["show_outputs"] = None
        super(View, __self__).__init__(
            'snowflake:index/view:View',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aggregation_policy: Optional[pulumi.Input[Union['ViewAggregationPolicyArgs', 'ViewAggregationPolicyArgsDict']]] = None,
            change_tracking: Optional[pulumi.Input[_builtins.str]] = None,
            columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ViewColumnArgs', 'ViewColumnArgsDict']]]]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            copy_grants: Optional[pulumi.Input[_builtins.bool]] = None,
            data_metric_functions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ViewDataMetricFunctionArgs', 'ViewDataMetricFunctionArgsDict']]]]] = None,
            data_metric_schedule: Optional[pulumi.Input[Union['ViewDataMetricScheduleArgs', 'ViewDataMetricScheduleArgsDict']]] = None,
            database: Optional[pulumi.Input[_builtins.str]] = None,
            describe_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ViewDescribeOutputArgs', 'ViewDescribeOutputArgsDict']]]]] = None,
            fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            is_recursive: Optional[pulumi.Input[_builtins.str]] = None,
            is_secure: Optional[pulumi.Input[_builtins.str]] = None,
            is_temporary: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            row_access_policy: Optional[pulumi.Input[Union['ViewRowAccessPolicyArgs', 'ViewRowAccessPolicyArgsDict']]] = None,
            schema: Optional[pulumi.Input[_builtins.str]] = None,
            show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ViewShowOutputArgs', 'ViewShowOutputArgsDict']]]]] = None,
            statement: Optional[pulumi.Input[_builtins.str]] = None) -> 'View':
        """
        Get an existing View resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ViewAggregationPolicyArgs', 'ViewAggregationPolicyArgsDict']] aggregation_policy: Specifies the aggregation policy to set on a view.
        :param pulumi.Input[_builtins.str] change_tracking: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies to enable or disable change tracking on the table. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ViewColumnArgs', 'ViewColumnArgsDict']]]] columns: If you want to change the name of a column or add a comment to a column in the new view, include a column list that specifies the column names and (if needed) comments about the columns. You do not need to specify the data types of the columns. If this field is not specified, columns are inferred from the `statement` field by Snowflake.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the view.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ViewDataMetricFunctionArgs', 'ViewDataMetricFunctionArgsDict']]]] data_metric_functions: Data metric functions used for the view.
        :param pulumi.Input[Union['ViewDataMetricScheduleArgs', 'ViewDataMetricScheduleArgsDict']] data_metric_schedule: Specifies the schedule to run the data metric functions periodically.
        :param pulumi.Input[_builtins.str] database: The database in which to create the view. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ViewDescribeOutputArgs', 'ViewDescribeOutputArgsDict']]]] describe_outputs: Outputs the result of `DESCRIBE VIEW` for the given view.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] is_recursive: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies that the view can refer to itself using recursive syntax without necessarily using a CTE (common table expression). Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the view; must be unique for the schema in which the view is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Union['ViewRowAccessPolicyArgs', 'ViewRowAccessPolicyArgsDict']] row_access_policy: Specifies the row access policy to set on a view.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the view. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ViewShowOutputArgs', 'ViewShowOutputArgsDict']]]] show_outputs: Outputs the result of `SHOW VIEW` for the given view.
        :param pulumi.Input[_builtins.str] statement: Specifies the query used to create the view. To mitigate permadiff on this field, the provider replaces blank characters with a space. This can lead to false positives in cases where a change in case or run of whitespace is semantically significant.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ViewState.__new__(_ViewState)

        __props__.__dict__["aggregation_policy"] = aggregation_policy
        __props__.__dict__["change_tracking"] = change_tracking
        __props__.__dict__["columns"] = columns
        __props__.__dict__["comment"] = comment
        __props__.__dict__["copy_grants"] = copy_grants
        __props__.__dict__["data_metric_functions"] = data_metric_functions
        __props__.__dict__["data_metric_schedule"] = data_metric_schedule
        __props__.__dict__["database"] = database
        __props__.__dict__["describe_outputs"] = describe_outputs
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["is_recursive"] = is_recursive
        __props__.__dict__["is_secure"] = is_secure
        __props__.__dict__["is_temporary"] = is_temporary
        __props__.__dict__["name"] = name
        __props__.__dict__["row_access_policy"] = row_access_policy
        __props__.__dict__["schema"] = schema
        __props__.__dict__["show_outputs"] = show_outputs
        __props__.__dict__["statement"] = statement
        return View(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aggregationPolicy")
    def aggregation_policy(self) -> pulumi.Output[Optional['outputs.ViewAggregationPolicy']]:
        """
        Specifies the aggregation policy to set on a view.
        """
        return pulumi.get(self, "aggregation_policy")

    @_builtins.property
    @pulumi.getter(name="changeTracking")
    def change_tracking(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies to enable or disable change tracking on the table. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "change_tracking")

    @_builtins.property
    @pulumi.getter
    def columns(self) -> pulumi.Output[Optional[Sequence['outputs.ViewColumn']]]:
        """
        If you want to change the name of a column or add a comment to a column in the new view, include a column list that specifies the column names and (if needed) comments about the columns. You do not need to specify the data types of the columns. If this field is not specified, columns are inferred from the `statement` field by Snowflake.
        """
        return pulumi.get(self, "columns")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a comment for the view.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="copyGrants")
    def copy_grants(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "copy_grants")

    @_builtins.property
    @pulumi.getter(name="dataMetricFunctions")
    def data_metric_functions(self) -> pulumi.Output[Optional[Sequence['outputs.ViewDataMetricFunction']]]:
        """
        Data metric functions used for the view.
        """
        return pulumi.get(self, "data_metric_functions")

    @_builtins.property
    @pulumi.getter(name="dataMetricSchedule")
    def data_metric_schedule(self) -> pulumi.Output[Optional['outputs.ViewDataMetricSchedule']]:
        """
        Specifies the schedule to run the data metric functions periodically.
        """
        return pulumi.get(self, "data_metric_schedule")

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Output[_builtins.str]:
        """
        The database in which to create the view. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter(name="describeOutputs")
    def describe_outputs(self) -> pulumi.Output[Sequence['outputs.ViewDescribeOutput']]:
        """
        Outputs the result of `DESCRIBE VIEW` for the given view.
        """
        return pulumi.get(self, "describe_outputs")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @_builtins.property
    @pulumi.getter(name="isRecursive")
    def is_recursive(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies that the view can refer to itself using recursive syntax without necessarily using a CTE (common table expression). Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "is_recursive")

    @_builtins.property
    @pulumi.getter(name="isSecure")
    def is_secure(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "is_secure")

    @_builtins.property
    @pulumi.getter(name="isTemporary")
    def is_temporary(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "is_temporary")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the identifier for the view; must be unique for the schema in which the view is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="rowAccessPolicy")
    def row_access_policy(self) -> pulumi.Output[Optional['outputs.ViewRowAccessPolicy']]:
        """
        Specifies the row access policy to set on a view.
        """
        return pulumi.get(self, "row_access_policy")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Output[_builtins.str]:
        """
        The schema in which to create the view. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> pulumi.Output[Sequence['outputs.ViewShowOutput']]:
        """
        Outputs the result of `SHOW VIEW` for the given view.
        """
        return pulumi.get(self, "show_outputs")

    @_builtins.property
    @pulumi.getter
    def statement(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the query used to create the view. To mitigate permadiff on this field, the provider replaces blank characters with a space. This can lead to false positives in cases where a change in case or run of whitespace is semantically significant.
        """
        return pulumi.get(self, "statement")

