## STIX conversion

The inputs and outputs are all coded into STIX 2.1 objects as follows...

### txt2detection marking definition

The following marking defintion ID is added to all `object_marking_refs` of STIX objects created by txt2detection.

https://raw.githubusercontent.com/muchdogesec/stix4doge/refs/heads/main/objects/marking-definition/txt2detection.json

### AI creation mode

#### Report SDO (`report`)

All files uploaded are represented as a unique [STIX Report SDO](https://docs.oasis-open.org/cti/stix/v2.1/os/stix-v2.1-os.html#_n8bjzg1ysgdq) that take the following structure;

If AI mode;

```json
{
    "type": "report",
    "spec_version": "2.1",
    "id": "report--<UUID V4 GENERATED BY STIX2 LIBRARY OR USER ENTERED AT INPUT>",
    "created_by_ref": "identity--<IDENTITY OBJECT USED AT UPLOAD OR TXT2DETECTION IDENTIFY IF NON SET>",
    "created": "<ITEM INGEST DATE OR DATE SET AT UPLOAD>",
    "modified": "<ITEM INGEST DATE OR DATE SET AT UPLOAD>",
    "name": "<NAME ENTERED ON UPLOAD>",
    "description": "<FULL BODY OF TEXT FILE>",
    "published": "<ITEM INGEST DATE OR DATE SET AT UPLOAD>",
    "object_marking_refs": [
        "marking-definition--<TLP LEVEL SET IN CLI>",
        "marking-definition--a4d70b75-6f4a-5d19-9137-da863edd33d7"
    ],
    "labels": [
        "<LABELS ADDED BY USER AT CLI, EXCEPT SPECIAL LABELS ATTACK / CVE>"
    ],
    "external_references": [
        {
            "description": "description_md5_hash",
            "external_id": "<MD5 HASH OF DESCRIPTION FIELD>"
        },
        {
            "ANY EXTERNAL REFS SET AT CLI / REFERENCE URLS"
        }
    ],
    "object_refs": [
        "<LIST OF ALL INDICATOR OBJECTS CREATED>"
    ]
}
```

#### Indicator SDO (`indicator`)

For each detection rule produced by the AI (there could be more than one) an Indicator object is created as follows;

```json
{
    "type": "indicator",
    "spec_version": "2.1",
    "id": "indicator--<UUIDV4>",
    "created_by_ref": "<SAME AS REPORT OBJECT IDENTITY VALUE>",
    "created": "<SAME AS REPORT OBJECT CREATED VALUE>",
    "modified": "<SAME AS REPORT OBJECT MODIFIED VALUE>",
    "indicator_types": [
        "<AI TYPES>"
    ],
    "name": "<AI NAME>",
    "description": "<AI DESCRIPTION>",
    "pattern_type": "sigma",
    "pattern": "<DETECTION_RULE>",
    "labels": [
        "<LABELS ADDED BY USER VIA CLI, EXCEPT SPECIAL LABELS ATTACK / CVE>"
    ],
    "external_references": [
        {
            "ANY EXTERNAL REFS SET AT CLI / ANY REFERENCE URLS"
        },
        {
            "description": "rule_md5_hash",
            "external_id": "<MD5 HASH OF PATTERN FIELD>"
        },
        {
            "source_name": "sigma-level",
            "description": "<LEVEL>"
        },
        {
            "source_name": "sigma-status",
            "description": "<STATUS>"
        },
        {
            "source_name": "sigma-license",
            "description": "<LICENSE, IF DOES NOT EXIST IS OMITTED>"
        },
        {
            "source_name": "mitre-attack",
            "url": "https://attack.mitre.org/techniques/<ID, IF DOES NOT EXIST IS OMITTED>",
            "external_id": "<ID, IF DOES NOT EXIST IS OMITTED>"
        },
        {
            "source_name": "mitre-attack",
            "url": "https://attack.mitre.org/tactics/<ID, IF DOES NOT EXIST IS OMITTED>",
            "external_id": "<ID, IF DOES NOT EXIST IS OMITTED>"
        },
        {
            "source_name": "cve",
            "url": "https://nvd.nist.gov/vuln/detail/<ID, IF DOES NOT EXIST IS OMITTED>",
            "external_id": "<ID, IF DOES NOT EXIST IS OMITTED>"
        }
    ],
    "valid_from": "<REPORT CREATED PROPERTY VALUE>",
    "object_marking_refs": [
        "marking-definition--<TLP LEVEL SET AT CLI>",
        "marking-definition--a4d70b75-6f4a-5d19-9137-da863edd33d7"
    ]
}
```

The actual rule generated and placed inside the `pattern` property is structured as follows;

```yml
id: <GENERATED BY TXT2DETECTION -- USED IN INDICATOR>
title: <GENERATED BY AI>
description: <GENERATED BY AI>
date: <SAME AS REPORT OBJECT CREATED VALUE>
modified: <SAME AS REPORT OBJECT MODIFIED VALUE>
author: <SAME AS REPORT IDENTITY ID>
falsepositives: 
    - <GENERATED BY AI>
status: <GENERATED BY AI>
level: <GENERATED BY AI>
license: <ADDED BY USER AT CLI, OR BLNAK>
tags:
- tlp.<HUMAN READABLE TLP, SAME AS STIX OBJECTS>
- attack.<TECHNIQUE ID GENERATED BY AI>
- attack.<TACTIC ID GENERATED BY AI>
- cve.<CVE ID GENERATED BY AI>
- <LABELS ADDED BY USER AT CLI>
references:
    - <reference_urls ENTERED BY USER AT CLI>
detection: <GENERATED BY AI>
logsource: <GENERATED BY AI>
```

#### MITRE ATT&CK lookup 

Where MITRE ATT&CK Enterprise tactics/techniques detected, they are added to the bundle and joined to the Indicator object containing the detection.

For techniques;

```json
{
    "type": "relationship",
    "spec_version": "2.1",
    "id": "relationship--<UUIDv5>",
    "created_by_ref": "<SAME AS REPORT OBJECT IDENTITY VALUE>",
    "created": "<SAME AS REPORT OBJECT CREATED VALUE>",
    "modified": "<SAME AS REPORT MODIFIED CREATED VALUE>",
    "relationship_type": "detects",
    "description": "<INDICATOR NAME> detects <ATT&CK NAME>",
    "source_ref": "indicator--<ID>",
    "target_ref": "attack-pattern--<MITRE ATT&CK OBJECT ID>",
    "object_marking_refs": [
        "marking-definition--<TLP LEVEL SET IN CLI>"
        "marking-definition--a4d70b75-6f4a-5d19-9137-da863edd33d7"
    ],
    "external_references": [
        {
            "source_name": "mitre-attack",
            "url": "https://attack.mitre.org/techniques/<ID>",
            "external_id": "<ID>"
        }
    ]
}
```

For tactics;

```json
{
    "type": "relationship",
    "spec_version": "2.1",
    "id": "relationship--<UUIDv5>",
    "created_by_ref": "<SAME AS REPORT OBJECT IDENTITY VALUE>",
    "created": "<SAME AS REPORT OBJECT CREATED VALUE>",
    "modified": "<SAME AS REPORT MODIFIED CREATED VALUE>",
    "relationship_type": "detects",
    "description": "<INDICATOR NAME> detects <ATT&CK NAME>",
    "source_ref": "indicator--<ID>",
    "target_ref": "x-mitre-tactic--<MITRE ATT&CK OBJECT ID>",
    "object_marking_refs": [
        "marking-definition--<TLP LEVEL SET IN CLI>"
        "marking-definition--a4d70b75-6f4a-5d19-9137-da863edd33d7"
    ],
    "external_references": [
        {
            "source_name": "mitre-attack",
            "url": "https://attack.mitre.org/tactics/<ID>",
            "external_id": "<ID>"
        }
    ]
}
```

`UUIDv5` is generated using namespace `a4d70b75-6f4a-5d19-9137-da863edd33d7` and `source_ref+target_ref`

The objects themselves are imported from CTI Butler defined in the `.env` file.

#### CVE lookup 

Where CVE IDs are detected, they are added to the bundle and joined to the Indicator object containing the detection;

```json
{
    "type": "relationship",
    "spec_version": "2.1",
    "id": "relationship--<UUIDv5>",
    "created_by_ref": "<SAME AS REPORT OBJECT IDENTITY VALUE>",
    "created": "<SAME AS REPORT OBJECT CREATED VALUE>",
    "modified": "<SAME AS REPORT MODIFIED CREATED VALUE>",
    "relationship_type": "detects",
    "description": "<INDICATOR NAME> detects <CVE ID>",
    "source_ref": "indicator--<ID>",
    "target_ref": "vulnerability--<ID>",
    "object_marking_refs": [
        "marking-definition--<TLP LEVEL SET IN CLI>"
        "marking-definition--a4d70b75-6f4a-5d19-9137-da863edd33d7"
    ],
    "external_references": [
        {
            "source_name": "cve",
            "url": "https://nvd.nist.gov/vuln/detail/<ID>",
            "external_id": "<ID>"
        }
    ]
}
```

`UUIDv5` is generated using namespace `a4d70b75-6f4a-5d19-9137-da863edd33d7` and `source_ref+target_ref`

The objects themselves are imported from Vulmatch defined in the `.env` file.

#### Observable creation

If an observable is detected in the `detection` part of the rule, then it should be turned into a STIX SCO and joined to the Indicator object of the rule the SCO is found in.

The logic for detection an observable type should be powered by regex. The following types are supported.

* `ipv4-addr` (support CIDR and port)
* `ipv6-addr` (support CIDR and port)
* `email-addr` (no need to check TLD, just )
* `url`
* `directory`
* `domain-name` (needs TLD validation)
* `hostname` (needs TLD invalidation)
* `file.name` (needs file extension validation)
* `file.hashes.MD5`
* `file.hashes.SHA-1`
* `file.hashes.SHA-256`
* `file.hashes.SHA-512`
* `file.hashes.SSDEEP`

In the following text, report them in a structured json output as follows;

```json
{
    "type": "TYPE",
    "value": "VALUE"
}
```

The value should then be turned to an SCO object. The logic will be similar to txt2stix, HOWEVER, no Indicator will be created. Instead SCO object(s) created are linked to the rule indicator as follows;

```json
{
    "type": "relationship",
    "spec_version": "2.1",
    "id": "relationship--<UUIDv5>",
    "created_by_ref": "<SAME AS REPORT OBJECT IDENTITY VALUE>",
    "created": "<SAME AS REPORT OBJECT CREATED VALUE>",
    "modified": "<SAME AS REPORT MODIFIED CREATED VALUE>",
    "relationship_type": "detects",
    "description": "<INDICATOR NAME> detects <SCO VALUE>",
    "source_ref": "indicator--<ID>",
    "target_ref": "<SCO ID>",
    "object_marking_refs": [
        "marking-definition--<TLP LEVEL SET IN CLI>"
        "marking-definition--a4d70b75-6f4a-5d19-9137-da863edd33d7"
    ]
}
```

`UUIDv5` is generated using namespace `a4d70b75-6f4a-5d19-9137-da863edd33d7` and `source_ref+target_ref`

#### Bundle (script output)

The output of txt2stix is a STIX bundle file.

This bundle takes the format;

```json
{
    "type": "bundle",
    "id": "bundle--<SAME AS REPORT UUID>",
    "objects": [
        "<ALL STIX JSON DEFAULT AND EXTRACTED OBJECTS>"
    ]
}
```

The objects include all SROs generated for the input.

The output filename of the bundle takes the format: `bundle--<ID>.json`

### Sigma upload mode

This does the reverse of AI mode and maps a rule to STIX objects

```yml
id: <SEE LOGIC BELOW>
related: <FROM RULE>
title: <FROM RULE, OVERWRITTEN BY CLI INPUT>
description: <FROM RULE, ELSE NOT INCLUDED>
date: <FROM RULE, IF BLANK OVERWRITTEN BY CURRENT TIME OR CLI INPUT>
modified: <FROM RULE, IF BLANK OVERWRITTEN BY CURRENT TIME OR CLI INPUT>
author: <SEE LOGIC BELOW>
falsepositives: 
    - <FROM RULE, ELSE NOT INCLUDED>
status: <FROM RULE, ELSE NOT INCLUDED>
level: <FROM RULE, ELSE NOT INCLUDED>
license: <FROM RULE, OVERWRITTEN BY CLI INPUT>
tags:
    - <FROM RULE, APPENDED BY CLI INPUT, SEE LOGIC BELOW>
references:
    - <FROM RULE, APPENDED BY CLI INPUT>
taxonomy: <FROM RULE>
scope: <FROM RULE>
detection: <FROM RULE>
logsource: <FROM RULE>
```

`<FROM RULE, OVERWRITTEN BY CLI INPUT>` means if this value is passed via the CLI, any values in the rule for this field are completely overwritten. Generally it is better to not better pass any CLI arguements when uploading Sigma rule files, and editing the rule directly before processing.

`<FROM RULE, APPENDED BY CLI INPUT>` means any old items will remain, but new values added by user via command line will also be appended to the list.

The Sigma specification does support arbitrary custom fields. These will be included like-for-like in the output.

#### id logic

Note, input rules don't always have an `id` it is not required by the Sigma spec

As such;

1. if no ID in rule, one will be autogenerated using a random UUIDv4 and added to the rule
2. if ID passed in rule or via CLI, the following logic will apply...

To reduce the risk of future collisions, the rule is renamed with a new ID, and the following is written into the rule;

```
id: <REPORT ID IN CLI, ELSE NEW RANDOMLY GENERATED UUID V4>
related:
  - id: <OLD ID>
    type: renamed
```

This ensures the original ID of the rule can retrieved if needed.

**Important**

Some rules will already have a `related` property.

The values created here will be appended to the existing `related` list.

#### author logic

`author` values in Sigma rules are free-text.

`author: dogesec @dogesec`

txt2detection supports `author` values as STIX Identity objects.

As such, one of three things things will happen with the following precedence;

1. if `use_identity` passed at CLI, the author value will be replaced with this ID and the STIX identity object will be included in the bundle, else,
2. if `author` value exists an `identity` object will be generated (see template below), else
3. if no `author` property present, the default txt2detection identity will be used and Identity object included in bundle

```json
{
    "type": "identity",
    "spec_version": "2.1",
    "id": "identity--<UUID V5>",
    "created_by_ref": "identity--a4d70b75-6f4a-5d19-9137-da863edd33d7",
    "created": "2020-01-01T00:00:00.000Z",
    "modified": "2020-01-01T00:00:00.000Z",
    "name": "<AUTHOR VALUE IN SIGMA RULE>",
    "object_marking_refs": [
        "marking-definition--94868c89-83c2-464b-929b-a1a8aa3c8487"
        "marking-definition--a4d70b75-6f4a-5d19-9137-da863edd33d7"
    ]
}
```

UUIDv5 uses namespace `a4d70b75-6f4a-5d19-9137-da863edd33d7` and value `name` to generate the UUIDv5. This ensure consistency of IDs between authors.

#### tags logic

In AI mode any `tags` relating to TLP (`tlp.`), ATT&CK (`attack.`), or CVE (`cve.`) are handled in a specical way. This also is reflected in manual mode. If the rule input contains one of these tags, it is handled as follows;

* `tlp.`: only one value should exist in rule, else error. The TLP is translated to STIX TLP, and then assigned to all created objects
* `attack.`: any technique or tactic tags are looked up using CTI Butler and ATT&CK relationships created as described
* `cve.`: any CVE tags are looked up using Vulmatch and CVE relationships created as described

#### Report SDO (`report`)

All files uploaded are represented as a unique [STIX Report SDO](https://docs.oasis-open.org/cti/stix/v2.1/os/stix-v2.1-os.html#_n8bjzg1ysgdq) that take the following structure;

If Sigma upload mode;

```json
{
    "type": "report",
    "spec_version": "2.1",
    "id": "report--<UUID OF RULE>",
    "created_by_ref": "identity--<IDENTITY OBJECT USED AT UPLOAD OR TXT2DETECTION IDENTIFY IF NON SET>",
    "created": "<DATE IN RULE OR ITEM INGEST DATE OR DATE SET AT UPLOAD>",
    "modified": "<MODIFIED IN RULE OR ITEM INGEST DATE OR DATE SET AT UPLOAD>",
    "name": "<TITLE OF SIGMA RULE>",
    "description": "<DESCRIPTION OF RULE, IF DOES NOT EXIST IS OMITTED>",
    "published": "<SAME AS CREATED>",
    "object_marking_refs": [
        "marking-definition--<TLP LEVEL IN RULE OR SET IN CLI>",
        "marking-definition--a4d70b75-6f4a-5d19-9137-da863edd33d7"
    ],
    "labels": [
        "<LABELS ADDED BY USER AT CLI, EXCEPT SPECIAL LABELS ATTACK / CVE>",
        "<TAGS FROM RULE EXCLUDING CVE,ATTACK,TLP>"
    ],
    "external_references": [
        {
            "description": "description_md5_hash",
            "external_id": "<MD5 HASH OF DESCRIPTION FIELD, ID EXIST>"
        },
        {
            "ANY EXTERNAL REFS SET AT CLI / REFERENCE URLS"
        }
    ],
    "object_refs": [
        "<INDICATOR OBJECT CREATED>"
    ]
}
```

#### Indicator SDO (`indicator`)

For the detection rule produced an Indicator object is created as follows;

```json
{
    "type": "indicator",
    "spec_version": "2.1",
    "id": "indicator--<SAME AS RULE>",
    "created_by_ref": "<SAME AS REPORT OBJECT>",
    "created": "<SAME AS REPORT OBJECT>",
    "modified": "<SAME AS REPORT OBJECT>",
    "name": "<TITLE OF RULE>",
    "description": "<DESCRIPTION OF RULE, IF DOES NOT EXIST IS OMITTED>",
    "pattern_type": "sigma",
    "pattern": "<DETECTION_RULE>",
    "labels": [
        "<LABELS ADDED BY USER AT CLI, EXCEPT SPECIAL LABELS ATTACK / CVE>"
        "<TAGS FROM RULE EXCLUDING CVE,ATTACK,TLP>"
    ],
    "external_references": [
        {
            "ANY EXTERNAL REFS SET AT CLI / REFERENCE URLS"
        },
        {
            "description": "rule_md5_hash",
            "external_id": "<MD5 HASH OF PATTERN FIELD>"
        },
        {
            "source_name": "sigma-old-id",
            "description": "<SIGMA ID REPLACED, ELSE BLANK>"
        },
        {
            "source_name": "sigma-level",
            "description": "<LEVEL, IF DOES NOT EXIST IS OMITTED>"
        },
        {
            "source_name": "sigma-status",
            "description": "<STATUS, IF DOES NOT EXIST IS OMITTED>"
        },
        {
            "source_name": "sigma-license",
            "description": "<LICENSE, IF DOES NOT EXIST IS OMITTED>"
        },
        {
            "source_name": "mitre-attack",
            "url": "https://attack.mitre.org/techniques/<ID, IF DOES NOT EXIST IS OMITTED>",
            "external_id": "<ID, IF DOES NOT EXIST IS OMITTED>"
        },
        {
            "source_name": "mitre-attack",
            "url": "https://attack.mitre.org/tactics/<ID, IF DOES NOT EXIST IS OMITTED>",
            "external_id": "<ID, IF DOES NOT EXIST IS OMITTED>"
        },
        {
            "source_name": "cve",
            "url": "https://nvd.nist.gov/vuln/detail/<ID, IF DOES NOT EXIST IS OMITTED>",
            "external_id": "<ID, IF DOES NOT EXIST IS OMITTED>"
        }
    ],
    "valid_from": "<REPORT CREATED PROPERTY VALUE>",
    "object_marking_refs": [
        "marking-definition--<TLP LEVEL IN RULE OR SET IN CLI>",
        "marking-definition--a4d70b75-6f4a-5d19-9137-da863edd33d7"
    ]
}
```

#### ATT&CK, CVE, Bundle

Same logic as AI mode.

#### Observable creation

Same logic as AI mode.