"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Accelerator = exports.AcceleratorProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ga_generated_1 = require("./ga.generated");
Object.defineProperty(exports, "AcceleratorProperty", { enumerable: true, get: function () { return ga_generated_1.RosAccelerator; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::GA::Accelerator`, which is used to create a Global Accelerator (GA) instance.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosAccelerator`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ga-accelerator
 */
class Accelerator extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosAccelerator = new ga_generated_1.RosAccelerator(this, id, {
            bandwidthBillingType: props.bandwidthBillingType,
            acceleratorName: props.acceleratorName,
            resourceGroupId: props.resourceGroupId,
            autoUseCoupon: props.autoUseCoupon,
            instanceChargeType: props.instanceChargeType,
            pricingCycle: props.pricingCycle,
            enableCrossBorder: props.enableCrossBorder === undefined || props.enableCrossBorder === null ? false : props.enableCrossBorder,
            duration: props.duration,
            autoPay: props.autoPay === undefined || props.autoPay === null ? true : props.autoPay,
            ipSetConfig: props.ipSetConfig,
            spec: props.spec,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosAccelerator;
        this.attrAcceleratorId = rosAccelerator.attrAcceleratorId;
        this.attrAcceleratorName = rosAccelerator.attrAcceleratorName;
        this.attrAutoPay = rosAccelerator.attrAutoPay;
        this.attrAutoUseCoupon = rosAccelerator.attrAutoUseCoupon;
        this.attrDnsName = rosAccelerator.attrDnsName;
        this.attrDuration = rosAccelerator.attrDuration;
        this.attrOrderId = rosAccelerator.attrOrderId;
        this.attrPaymentType = rosAccelerator.attrPaymentType;
        this.attrPricingCycle = rosAccelerator.attrPricingCycle;
        this.attrSpec = rosAccelerator.attrSpec;
    }
}
exports.Accelerator = Accelerator;
//# sourceMappingURL=data:application/json;base64,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