"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AclsListenerAssociation = exports.AclsListenerAssociationProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ga_generated_1 = require("./ga.generated");
Object.defineProperty(exports, "AclsListenerAssociationProperty", { enumerable: true, get: function () { return ga_generated_1.RosAclsListenerAssociation; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::GA::AclsListenerAssociation`, which is used to associate an access control list (ACL) with a listener.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosAclsListenerAssociation`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ga-aclslistenerassociation
 */
class AclsListenerAssociation extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosAclsListenerAssociation = new ga_generated_1.RosAclsListenerAssociation(this, id, {
            aclType: props.aclType,
            aclIds: props.aclIds,
            listenerId: props.listenerId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosAclsListenerAssociation;
        this.attrAclIds = rosAclsListenerAssociation.attrAclIds;
        this.attrListenerId = rosAclsListenerAssociation.attrListenerId;
    }
}
exports.AclsListenerAssociation = AclsListenerAssociation;
//# sourceMappingURL=data:application/json;base64,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