"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationMonitor = exports.ApplicationMonitorProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ga_generated_1 = require("./ga.generated");
Object.defineProperty(exports, "ApplicationMonitorProperty", { enumerable: true, get: function () { return ga_generated_1.RosApplicationMonitor; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::GA::ApplicationMonitor`, which is used to create an origin probing task.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosApplicationMonitor`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ga-applicationmonitor
 */
class ApplicationMonitor extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosApplicationMonitor = new ga_generated_1.RosApplicationMonitor(this, id, {
            silenceTime: props.silenceTime,
            detectThreshold: props.detectThreshold,
            detectEnable: props.detectEnable,
            address: props.address,
            optionsJson: props.optionsJson,
            taskName: props.taskName,
            acceleratorId: props.acceleratorId,
            detectTimes: props.detectTimes,
            listenerId: props.listenerId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosApplicationMonitor;
        this.attrTaskId = rosApplicationMonitor.attrTaskId;
    }
}
exports.ApplicationMonitor = ApplicationMonitor;
//# sourceMappingURL=data:application/json;base64,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