"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BandwidthPackageAcceleratorAddition = exports.BandwidthPackageAcceleratorAdditionProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ga_generated_1 = require("./ga.generated");
Object.defineProperty(exports, "BandwidthPackageAcceleratorAdditionProperty", { enumerable: true, get: function () { return ga_generated_1.RosBandwidthPackageAcceleratorAddition; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::GA::BandwidthPackageAcceleratorAddition`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosBandwidthPackageAcceleratorAddition`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ga-bandwidthpackageacceleratoraddition
 */
class BandwidthPackageAcceleratorAddition extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosBandwidthPackageAcceleratorAddition = new ga_generated_1.RosBandwidthPackageAcceleratorAddition(this, id, {
            bandwidthPackageId: props.bandwidthPackageId,
            acceleratorId: props.acceleratorId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosBandwidthPackageAcceleratorAddition;
        this.attrAcceleratorId = rosBandwidthPackageAcceleratorAddition.attrAcceleratorId;
        this.attrBandwidthPackageId = rosBandwidthPackageAcceleratorAddition.attrBandwidthPackageId;
    }
}
exports.BandwidthPackageAcceleratorAddition = BandwidthPackageAcceleratorAddition;
//# sourceMappingURL=data:application/json;base64,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