"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BasicAccelerator = exports.BasicAcceleratorProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ga_generated_1 = require("./ga.generated");
Object.defineProperty(exports, "BasicAcceleratorProperty", { enumerable: true, get: function () { return ga_generated_1.RosBasicAccelerator; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::GA::BasicAccelerator`, which is used to create a basic Global Accelerator (GA) instance.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosBasicAccelerator`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ga-basicaccelerator
 */
class BasicAccelerator extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosBasicAccelerator = new ga_generated_1.RosBasicAccelerator(this, id, {
            bandwidthBillingType: props.bandwidthBillingType,
            resourceGroupId: props.resourceGroupId,
            autoUseCoupon: props.autoUseCoupon,
            promotionOptionNo: props.promotionOptionNo,
            pricingCycle: props.pricingCycle,
            chargeType: props.chargeType,
            autoRenew: props.autoRenew,
            duration: props.duration,
            autoPay: props.autoPay,
            tags: props.tags,
            autoRenewDuration: props.autoRenewDuration,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosBasicAccelerator;
        this.attrAcceleratorId = rosBasicAccelerator.attrAcceleratorId;
    }
}
exports.BasicAccelerator = BasicAccelerator;
//# sourceMappingURL=data:application/json;base64,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