"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BasicAcceleratorIpEndpointRelation = exports.BasicAcceleratorIpEndpointRelationProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ga_generated_1 = require("./ga.generated");
Object.defineProperty(exports, "BasicAcceleratorIpEndpointRelationProperty", { enumerable: true, get: function () { return ga_generated_1.RosBasicAcceleratorIpEndpointRelation; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::GA::BasicAcceleratorIpEndpointRelation`, which is used to create a mapping between an accelerated IP address and an endpoint for a basic Global Accelerator (GA) instance.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosBasicAcceleratorIpEndpointRelation`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ga-basicacceleratoripendpointrelation
 */
class BasicAcceleratorIpEndpointRelation extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosBasicAcceleratorIpEndpointRelation = new ga_generated_1.RosBasicAcceleratorIpEndpointRelation(this, id, {
            accelerateIpId: props.accelerateIpId,
            endpointId: props.endpointId,
            acceleratorId: props.acceleratorId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosBasicAcceleratorIpEndpointRelation;
        this.attrAccelerateIpId = rosBasicAcceleratorIpEndpointRelation.attrAccelerateIpId;
        this.attrAcceleratorId = rosBasicAcceleratorIpEndpointRelation.attrAcceleratorId;
        this.attrEndpointId = rosBasicAcceleratorIpEndpointRelation.attrEndpointId;
    }
}
exports.BasicAcceleratorIpEndpointRelation = BasicAcceleratorIpEndpointRelation;
//# sourceMappingURL=data:application/json;base64,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