"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BasicEndpoint = exports.BasicEndpointProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ga_generated_1 = require("./ga.generated");
Object.defineProperty(exports, "BasicEndpointProperty", { enumerable: true, get: function () { return ga_generated_1.RosBasicEndpoint; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::GA::BasicEndpoint`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosBasicEndpoint`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ga-basicendpoint
 */
class BasicEndpoint extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosBasicEndpoint = new ga_generated_1.RosBasicEndpoint(this, id, {
            endpointGroupId: props.endpointGroupId,
            endpointZoneId: props.endpointZoneId,
            endpointType: props.endpointType,
            endpointSubAddressType: props.endpointSubAddressType,
            endpointSubAddress: props.endpointSubAddress,
            acceleratorId: props.acceleratorId,
            name: props.name,
            endpointAddress: props.endpointAddress,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosBasicEndpoint;
        this.attrEndpointId = rosBasicEndpoint.attrEndpointId;
    }
}
exports.BasicEndpoint = BasicEndpoint;
//# sourceMappingURL=data:application/json;base64,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