"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BasicEndpointGroup = exports.BasicEndpointGroupProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ga_generated_1 = require("./ga.generated");
Object.defineProperty(exports, "BasicEndpointGroupProperty", { enumerable: true, get: function () { return ga_generated_1.RosBasicEndpointGroup; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::GA::BasicEndpointGroup`, which is used to create an endpoint group for a basic Global Accelerator (GA) instance.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosBasicEndpointGroup`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ga-basicendpointgroup
 */
class BasicEndpointGroup extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosBasicEndpointGroup = new ga_generated_1.RosBasicEndpointGroup(this, id, {
            endpointGroupRegion: props.endpointGroupRegion,
            description: props.description,
            endpointType: props.endpointType,
            endpointSubAddress: props.endpointSubAddress,
            acceleratorId: props.acceleratorId,
            endpointAddress: props.endpointAddress,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosBasicEndpointGroup;
        this.attrEndpointGroupId = rosBasicEndpointGroup.attrEndpointGroupId;
    }
}
exports.BasicEndpointGroup = BasicEndpointGroup;
//# sourceMappingURL=data:application/json;base64,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