"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BasicIpSet = exports.BasicIpSetProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ga_generated_1 = require("./ga.generated");
Object.defineProperty(exports, "BasicIpSetProperty", { enumerable: true, get: function () { return ga_generated_1.RosBasicIpSet; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::GA::BasicIpSet`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosBasicIpSet`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ga-basicipset
 */
class BasicIpSet extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosBasicIpSet = new ga_generated_1.RosBasicIpSet(this, id, {
            ispType: props.ispType,
            bandwidth: props.bandwidth,
            accelerateRegionId: props.accelerateRegionId,
            acceleratorId: props.acceleratorId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosBasicIpSet;
        this.attrIpSetId = rosBasicIpSet.attrIpSetId;
    }
}
exports.BasicIpSet = BasicIpSet;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmFzaWNpcHNldC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImJhc2ljaXBzZXQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsOENBQThDO0FBQzlDLGlEQUErQztBQUVyQixtR0FGakIsNEJBQWEsT0FFc0I7QUFpRDVDOzs7O0dBSUc7QUFDSCxNQUFhLFVBQVcsU0FBUSxHQUFHLENBQUMsUUFBUTtJQVd4Qzs7OztPQUlHO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUFzQixFQUFFLG1DQUEyQyxJQUFJO1FBQ2pILEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDakIsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7UUFDbkIsSUFBSSxDQUFDLEVBQUUsR0FBRyxFQUFFLENBQUM7UUFDYixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztRQUNuQixJQUFJLENBQUMsZ0NBQWdDLEdBQUcsZ0NBQWdDLENBQUM7UUFFekUsTUFBTSxhQUFhLEdBQUcsSUFBSSw0QkFBYSxDQUFDLElBQUksRUFBRSxFQUFFLEVBQUc7WUFDL0MsT0FBTyxFQUFFLEtBQUssQ0FBQyxPQUFPO1lBQ3RCLFNBQVMsRUFBRSxLQUFLLENBQUMsU0FBUztZQUMxQixrQkFBa0IsRUFBRSxLQUFLLENBQUMsa0JBQWtCO1lBQzVDLGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtTQUNyQyxFQUFFLGdDQUFnQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUNwRixJQUFJLENBQUMsUUFBUSxHQUFHLGFBQWEsQ0FBQztRQUM5QixJQUFJLENBQUMsV0FBVyxHQUFHLGFBQWEsQ0FBQyxXQUFXLENBQUM7SUFDakQsQ0FBQztDQUNKO0FBaENELGdDQWdDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHJvcyBmcm9tICdAYWxpY2xvdWQvcm9zLWNkay1jb3JlJztcbmltcG9ydCB7IFJvc0Jhc2ljSXBTZXQgfSBmcm9tICcuL2dhLmdlbmVyYXRlZCc7XG4vLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIFNwZWNpZmljYXRpb25cbmV4cG9ydCB7IFJvc0Jhc2ljSXBTZXQgYXMgQmFzaWNJcFNldFByb3BlcnR5IH07XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgQmFzaWNJcFNldGAuXG4gKiBTZWUgaHR0cHM6Ly93d3cuYWxpYmFiYWNsb3VkLmNvbS9oZWxwL3Jvcy9kZXZlbG9wZXItcmVmZXJlbmNlL2FsaXl1bi1nYS1iYXNpY2lwc2V0XG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQmFzaWNJcFNldFByb3BzIHtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGFjY2VsZXJhdG9ySWQ6IFRoZSBJRCBvZiB0aGUgYmFzaWMgR0EgaW5zdGFuY2UuXG4gICAgICovXG4gICAgcmVhZG9ubHkgYWNjZWxlcmF0b3JJZDogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgYWNjZWxlcmF0ZVJlZ2lvbklkOiBUaGUgSUQgb2YgdGhlIGFjY2VsZXJhdGlvbiByZWdpb24uXG4gICAgICovXG4gICAgcmVhZG9ubHkgYWNjZWxlcmF0ZVJlZ2lvbklkPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgYmFuZHdpZHRoOiBUaGUgYmFuZHdpZHRoIHRoYXQgeW91IHdhbnQgdG8gYWxsb2NhdGUgdG8gdGhlIGFjY2VsZXJhdGlvbiByZWdpb24uIFVuaXQ6IE1iaXRcXC9zLllvdSBtdXN0IGFsbG9jYXRlIGF0IGxlYXN0IDIgTWJpdFxcL3Mgb2YgYmFuZHdpZHRoIHRvIHRoZSBhY2NlbGVyYXRpb24gcmVnaW9uLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGJhbmR3aWR0aD86IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGlzcFR5cGU6IFRoZSBsaW5lIHR5cGUgb2YgdGhlIGVsYXN0aWMgSVAgYWRkcmVzcyAoRUlQKSBpbiB0aGUgYWNjZWxlcmF0aW9uIHJlZ2lvbi4gVmFsaWQgdmFsdWVzOlxuICAgICAqIEJHUCAoZGVmYXVsdCk6IEJHUCAoTXVsdGktSVNQKSBsaW5lcy5cbiAgICAgKiBCR1BfUFJPOiBCR1AgKE11bHRpLUlTUCkgUHJvIGxpbmVzLlxuICAgICAqIFZhbGlkIHZhbHVlcyBpZiB5b3UgYXJlIGFsbG93ZWQgdG8gdXNlIHNpbmdsZS1JU1AgYmFuZHdpZHRoOlxuICAgICAqIENoaW5hVGVsZWNvbVxuICAgICAqIENoaW5hVW5pY29tXG4gICAgICogQ2hpbmFNb2JpbGVcbiAgICAgKiBDaGluYVRlbGVjb21fTDJcbiAgICAgKiBDaGluYVVuaWNvbV9MMlxuICAgICAqIENoaW5hTW9iaWxlX0wyXG4gICAgICovXG4gICAgcmVhZG9ubHkgaXNwVHlwZT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcbn1cblxuLyoqXG4gKiBSZXByZXNlbnRzIGEgYEJhc2ljSXBTZXRgLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIElCYXNpY0lwU2V0IGV4dGVuZHMgcm9zLklSZXNvdXJjZSB7XG4gICAgcmVhZG9ubHkgcHJvcHM6IEJhc2ljSXBTZXRQcm9wcztcblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBJcFNldElkOiBUaGUgSUQgb2YgdGhlIGFjY2VsZXJhdGlvbiByZWdpb24uXG4gICAgICovXG4gICAgcmVhZG9ubHkgYXR0cklwU2V0SWQ6IHJvcy5JUmVzb2x2YWJsZSB8IHN0cmluZztcbn1cbi8qKlxuICogVGhpcyBjbGFzcyBlbmNhcHN1bGF0ZXMgYW5kIGV4dGVuZHMgdGhlIFJPUyByZXNvdXJjZSB0eXBlIGBBTElZVU46OkdBOjpCYXNpY0lwU2V0YC5cbiAqIEBOb3RlIFRoaXMgY2xhc3MgbWF5IGhhdmUgc29tZSBuZXcgZnVuY3Rpb25zIHRvIGZhY2lsaXRhdGUgZGV2ZWxvcG1lbnQsIHNvIGl0IGlzIHJlY29tbWVuZGVkIHRvIHVzZSB0aGlzIGNsYXNzIGluc3RlYWQgb2YgYFJvc0Jhc2ljSXBTZXRgZm9yIGEgbW9yZSBjb252ZW5pZW50IGRldmVsb3BtZW50IGV4cGVyaWVuY2UuXG4gKiBTZWUgaHR0cHM6Ly93d3cuYWxpYmFiYWNsb3VkLmNvbS9oZWxwL3Jvcy9kZXZlbG9wZXItcmVmZXJlbmNlL2FsaXl1bi1nYS1iYXNpY2lwc2V0XG4gKi9cbmV4cG9ydCBjbGFzcyBCYXNpY0lwU2V0IGV4dGVuZHMgcm9zLlJlc291cmNlIGltcGxlbWVudHMgSUJhc2ljSXBTZXQge1xuICAgIHByb3RlY3RlZCBzY29wZTogcm9zLkNvbnN0cnVjdDtcbiAgICBwcm90ZWN0ZWQgaWQ6IHN0cmluZztcbiAgICBwdWJsaWMgcmVhZG9ubHkgcHJvcHM6IEJhc2ljSXBTZXRQcm9wcztcbiAgICBwcm90ZWN0ZWQgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6IGJvb2xlYW47XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgSXBTZXRJZDogVGhlIElEIG9mIHRoZSBhY2NlbGVyYXRpb24gcmVnaW9uLlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRySXBTZXRJZDogcm9zLklSZXNvbHZhYmxlIHwgc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogUGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBQYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBQYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3RvcihzY29wZTogcm9zLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEJhc2ljSXBTZXRQcm9wcywgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6Ym9vbGVhbiA9IHRydWUpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICAgICAgdGhpcy5zY29wZSA9IHNjb3BlO1xuICAgICAgICB0aGlzLmlkID0gaWQ7XG4gICAgICAgIHRoaXMucHJvcHMgPSBwcm9wcztcbiAgICAgICAgdGhpcy5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCA9IGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50O1xuXG4gICAgICAgIGNvbnN0IHJvc0Jhc2ljSXBTZXQgPSBuZXcgUm9zQmFzaWNJcFNldCh0aGlzLCBpZCwgIHtcbiAgICAgICAgICAgIGlzcFR5cGU6IHByb3BzLmlzcFR5cGUsXG4gICAgICAgICAgICBiYW5kd2lkdGg6IHByb3BzLmJhbmR3aWR0aCxcbiAgICAgICAgICAgIGFjY2VsZXJhdGVSZWdpb25JZDogcHJvcHMuYWNjZWxlcmF0ZVJlZ2lvbklkLFxuICAgICAgICAgICAgYWNjZWxlcmF0b3JJZDogcHJvcHMuYWNjZWxlcmF0b3JJZCxcbiAgICAgICAgfSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQgJiYgdGhpcy5zdGFjay5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCk7XG4gICAgICAgIHRoaXMucmVzb3VyY2UgPSByb3NCYXNpY0lwU2V0O1xuICAgICAgICB0aGlzLmF0dHJJcFNldElkID0gcm9zQmFzaWNJcFNldC5hdHRySXBTZXRJZDtcbiAgICB9XG59XG4iXX0=