"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BandwidthPackage = exports.BandwidthPackageProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ga_generated_1 = require("./ga.generated");
Object.defineProperty(exports, "BandwidthPackageProperty", { enumerable: true, get: function () { return ga_generated_1.RosBandwidthPackage; } });
/**
 * This class encapsulates and extends the ROS resource type `DATASOURCE::GA::BandwidthPackage`, which is used to query the information about a bandwidth plan.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosBandwidthPackage`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/datasource-ga-bandwidthpackage
 */
class BandwidthPackage extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosBandwidthPackage = new ga_generated_1.RosBandwidthPackage(this, id, {
            bandwidthPackageId: props.bandwidthPackageId,
            refreshOptions: props.refreshOptions === undefined || props.refreshOptions === null ? 'Never' : props.refreshOptions,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosBandwidthPackage;
        this.attrAutoRenew = rosBandwidthPackage.attrAutoRenew;
        this.attrAutoRenewDuration = rosBandwidthPackage.attrAutoRenewDuration;
        this.attrBandwidth = rosBandwidthPackage.attrBandwidth;
        this.attrBandwidthPackageId = rosBandwidthPackage.attrBandwidthPackageId;
        this.attrBandwidthPackageName = rosBandwidthPackage.attrBandwidthPackageName;
        this.attrBandwidthType = rosBandwidthPackage.attrBandwidthType;
        this.attrBillingType = rosBandwidthPackage.attrBillingType;
        this.attrCbnGeographicRegionIdA = rosBandwidthPackage.attrCbnGeographicRegionIdA;
        this.attrCbnGeographicRegionIdB = rosBandwidthPackage.attrCbnGeographicRegionIdB;
        this.attrCreateTime = rosBandwidthPackage.attrCreateTime;
        this.attrDescription = rosBandwidthPackage.attrDescription;
        this.attrExpiredTime = rosBandwidthPackage.attrExpiredTime;
        this.attrPaymentType = rosBandwidthPackage.attrPaymentType;
        this.attrRatio = rosBandwidthPackage.attrRatio;
        this.attrRenewalStatus = rosBandwidthPackage.attrRenewalStatus;
        this.attrResourceGroupId = rosBandwidthPackage.attrResourceGroupId;
        this.attrType = rosBandwidthPackage.attrType;
    }
}
exports.BandwidthPackage = BandwidthPackage;
//# sourceMappingURL=data:application/json;base64,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