"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EndpointGroup = exports.EndpointGroupProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ga_generated_1 = require("./ga.generated");
Object.defineProperty(exports, "EndpointGroupProperty", { enumerable: true, get: function () { return ga_generated_1.RosEndpointGroup; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::GA::EndpointGroup`, which is used to create an endpoint group.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosEndpointGroup`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ga-endpointgroup
 */
class EndpointGroup extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosEndpointGroup = new ga_generated_1.RosEndpointGroup(this, id, {
            healthCheckIntervalSeconds: props.healthCheckIntervalSeconds,
            trafficPercentage: props.trafficPercentage,
            description: props.description,
            healthCheckPath: props.healthCheckPath,
            thresholdCount: props.thresholdCount,
            healthCheckEnabled: props.healthCheckEnabled,
            endpointRequestProtocol: props.endpointRequestProtocol,
            name: props.name,
            endpointGroupRegion: props.endpointGroupRegion,
            healthCheckProtocol: props.healthCheckProtocol,
            healthCheckPort: props.healthCheckPort,
            acceleratorId: props.acceleratorId,
            endpointConfigurations: props.endpointConfigurations,
            endpointGroupType: props.endpointGroupType,
            listenerId: props.listenerId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosEndpointGroup;
        this.attrEndpointGroupId = rosEndpointGroup.attrEndpointGroupId;
    }
}
exports.EndpointGroup = EndpointGroup;
//# sourceMappingURL=data:application/json;base64,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