"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EndpointGroups = exports.EndpointGroupsProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ga_generated_1 = require("./ga.generated");
Object.defineProperty(exports, "EndpointGroupsProperty", { enumerable: true, get: function () { return ga_generated_1.RosEndpointGroups; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::GA::EndpointGroups`, which is used to create multiple endpoint groups at a time.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosEndpointGroups`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ga-endpointgroups
 */
class EndpointGroups extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosEndpointGroups = new ga_generated_1.RosEndpointGroups(this, id, {
            endpointGroupConfigurations: props.endpointGroupConfigurations,
            acceleratorId: props.acceleratorId,
            listenerId: props.listenerId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosEndpointGroups;
        this.attrEndpointGroupIds = rosEndpointGroups.attrEndpointGroupIds;
    }
}
exports.EndpointGroups = EndpointGroups;
//# sourceMappingURL=data:application/json;base64,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