"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IpSets = exports.IpSetsProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ga_generated_1 = require("./ga.generated");
Object.defineProperty(exports, "IpSetsProperty", { enumerable: true, get: function () { return ga_generated_1.RosIpSets; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::GA::IpSets`, which is used to create acceleration regions.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosIpSets`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ga-ipsets
 */
class IpSets extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosIpSets = new ga_generated_1.RosIpSets(this, id, {
            accelerateRegion: props.accelerateRegion,
            acceleratorId: props.acceleratorId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosIpSets;
        this.attrAccelerateRegionIds = rosIpSets.attrAccelerateRegionIds;
        this.attrIpSetIds = rosIpSets.attrIpSetIds;
        this.attrIpVersions = rosIpSets.attrIpVersions;
    }
}
exports.IpSets = IpSets;
//# sourceMappingURL=data:application/json;base64,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