"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Listener = exports.ListenerProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ga_generated_1 = require("./ga.generated");
Object.defineProperty(exports, "ListenerProperty", { enumerable: true, get: function () { return ga_generated_1.RosListener; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::GA::Listener`, which is used to create a listener for a Global Accelerator (GA) instance.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosListener`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ga-listener
 */
class Listener extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosListener = new ga_generated_1.RosListener(this, id, {
            securityPolicyId: props.securityPolicyId,
            description: props.description,
            proxyProtocol: props.proxyProtocol,
            portRanges: props.portRanges,
            certificates: props.certificates,
            xForwardedForConfig: props.xForwardedForConfig,
            protocol: props.protocol,
            acceleratorId: props.acceleratorId,
            name: props.name,
            clientAffinity: props.clientAffinity,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosListener;
        this.attrListenerId = rosListener.attrListenerId;
    }
}
exports.Listener = Listener;
//# sourceMappingURL=data:application/json;base64,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