"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogStoreToEndpointGroupAttachment = exports.LogStoreToEndpointGroupAttachmentProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ga_generated_1 = require("./ga.generated");
Object.defineProperty(exports, "LogStoreToEndpointGroupAttachmentProperty", { enumerable: true, get: function () { return ga_generated_1.RosLogStoreToEndpointGroupAttachment; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::GA::LogStoreToEndpointGroupAttachment`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosLogStoreToEndpointGroupAttachment`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ga-logstoretoendpointgroupattachment
 */
class LogStoreToEndpointGroupAttachment extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosLogStoreToEndpointGroupAttachment = new ga_generated_1.RosLogStoreToEndpointGroupAttachment(this, id, {
            slsProjectName: props.slsProjectName,
            endpointGroupIds: props.endpointGroupIds,
            slsRegionId: props.slsRegionId,
            acceleratorId: props.acceleratorId,
            slsLogStoreName: props.slsLogStoreName,
            listenerId: props.listenerId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosLogStoreToEndpointGroupAttachment;
    }
}
exports.LogStoreToEndpointGroupAttachment = LogStoreToEndpointGroupAttachment;
//# sourceMappingURL=data:application/json;base64,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