"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import insightproto.proto.common.v1.common_pb2
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class LogEntry(google.protobuf.message.Message):
    """LogEntry represents a standardized log entry"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    TIMESTAMP_FIELD_NUMBER: builtins.int
    LEVEL_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    level: builtins.str
    """the log entry level (info, debug, etc)"""
    message: builtins.str
    """the main log entry message"""
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """the timestamp of the log entry"""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """any labels attached to the log"""

    def __init__(
        self,
        *,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        level: builtins.str = ...,
        message: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["timestamp", b"timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["labels", b"labels", "level", b"level", "message", b"message", "timestamp", b"timestamp"]) -> None: ...

global___LogEntry = LogEntry

@typing.final
class Metadata(google.protobuf.message.Message):
    """Metadata contains information about the log response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOG_COUNT_FIELD_NUMBER: builtins.int
    SOURCE_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    log_count: builtins.int
    """the number of logs returned"""
    @property
    def source(self) -> insightproto.proto.common.v1.common_pb2.Source:
        """the data source info"""

    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """the start of the time frame"""

    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """the end of the time frame"""

    def __init__(
        self,
        *,
        log_count: builtins.int = ...,
        source: insightproto.proto.common.v1.common_pb2.Source | None = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["end_time", b"end_time", "source", b"source", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["end_time", b"end_time", "log_count", b"log_count", "source", b"source", "start_time", b"start_time"]) -> None: ...

global___Metadata = Metadata

@typing.final
class LogResponse(google.protobuf.message.Message):
    """LogResponse contains standardized log response data"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTRIES_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    @property
    def entries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LogEntry]:
        """the log entries"""

    @property
    def metadata(self) -> global___Metadata:
        """meta data about the logs"""

    def __init__(
        self,
        *,
        entries: collections.abc.Iterable[global___LogEntry] | None = ...,
        metadata: global___Metadata | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["metadata", b"metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["entries", b"entries", "metadata", b"metadata"]) -> None: ...

global___LogResponse = LogResponse

@typing.final
class LogRequest(google.protobuf.message.Message):
    """Log request message for querying logs"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    QUERY_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ORG_FIELD_NUMBER: builtins.int
    query: builtins.str
    """the query to use"""
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """the start of the time frame"""

    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """the end of the time frame"""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """the labels for the query"""

    @property
    def org(self) -> insightproto.proto.common.v1.common_pb2.Organisation:
        """the org info for the request"""

    def __init__(
        self,
        *,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        query: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        org: insightproto.proto.common.v1.common_pb2.Organisation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["end_time", b"end_time", "org", b"org", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["end_time", b"end_time", "labels", b"labels", "org", b"org", "query", b"query", "start_time", b"start_time"]) -> None: ...

global___LogRequest = LogRequest

@typing.final
class MultipleResponse(google.protobuf.message.Message):
    """MultipleResponse is a wrapper for returning multiple responses"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORG_FIELD_NUMBER: builtins.int
    RESPONSES_FIELD_NUMBER: builtins.int
    @property
    def org(self) -> insightproto.proto.common.v1.common_pb2.Organisation:
        """the org info for the request"""

    @property
    def responses(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LogResponse]:
        """Each configured data source would return a response"""

    def __init__(
        self,
        *,
        org: insightproto.proto.common.v1.common_pb2.Organisation | None = ...,
        responses: collections.abc.Iterable[global___LogResponse] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["org", b"org"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["org", b"org", "responses", b"responses"]) -> None: ...

global___MultipleResponse = MultipleResponse
