"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import insightproto.proto.common.v1.common_pb2
import insightproto.proto.jobs.v1.jobs_pb2
import insightproto.proto.results.v1.timeline_details_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _ImportanceLevel:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ImportanceLevelEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ImportanceLevel.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    IMPORTANCE_LEVEL_UNSPECIFIED: _ImportanceLevel.ValueType  # 0
    IMPORTANCE_LEVEL_LOW: _ImportanceLevel.ValueType  # 1
    IMPORTANCE_LEVEL_MEDIUM: _ImportanceLevel.ValueType  # 2
    IMPORTANCE_LEVEL_HIGH: _ImportanceLevel.ValueType  # 3
    IMPORTANCE_LEVEL_CRITICAL: _ImportanceLevel.ValueType  # 4

class ImportanceLevel(_ImportanceLevel, metaclass=_ImportanceLevelEnumTypeWrapper):
    """ImportanceLevel defines the importance level of a timeline event"""

IMPORTANCE_LEVEL_UNSPECIFIED: ImportanceLevel.ValueType  # 0
IMPORTANCE_LEVEL_LOW: ImportanceLevel.ValueType  # 1
IMPORTANCE_LEVEL_MEDIUM: ImportanceLevel.ValueType  # 2
IMPORTANCE_LEVEL_HIGH: ImportanceLevel.ValueType  # 3
IMPORTANCE_LEVEL_CRITICAL: ImportanceLevel.ValueType  # 4
global___ImportanceLevel = ImportanceLevel

@typing.final
class InvestigationResult(google.protobuf.message.Message):
    """the result of the investigation"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    ORG_FIELD_NUMBER: builtins.int
    ALERT_EXTRACTION_FIELD_NUMBER: builtins.int
    TIMELINE_FIELD_NUMBER: builtins.int
    HYPOTHESES_FIELD_NUMBER: builtins.int
    TRIGGER_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    CREATEDAT_FIELD_NUMBER: builtins.int
    UPDATEDAT_FIELD_NUMBER: builtins.int
    CLOSEDAT_FIELD_NUMBER: builtins.int
    AGENTTIMESTAMP_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    PRIORITY_FIELD_NUMBER: builtins.int
    INVESTIGATIONPLAN_FIELD_NUMBER: builtins.int
    id: builtins.str
    """the investigation id"""
    title: builtins.str
    """the title to use"""
    description: builtins.str
    """the description"""
    status: builtins.str
    """the investigation status (open/closed/inprogress)"""
    priority: builtins.str
    """the investigation priority (low/medium/high/critical/pending)"""
    @property
    def org(self) -> insightproto.proto.common.v1.common_pb2.Organisation:
        """the organisation that this belongs to"""

    @property
    def alert_extraction(self) -> global___AlertExtraction:
        """the summary of the trigger"""

    @property
    def timeline(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TimelineEvent]:
        """the list of collected timeline events"""

    @property
    def hypotheses(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Hypothesis]:
        """the produced hypotheses"""

    @property
    def trigger(self) -> insightproto.proto.jobs.v1.jobs_pb2.Trigger:
        """the raw trigger information"""

    @property
    def metadata(self) -> global___MetaData:
        """metadata about the agent run"""

    @property
    def createdAt(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """the time this investigation was created"""

    @property
    def updatedAt(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """the time this was updated last"""

    @property
    def closedAt(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """the time this was closed"""

    @property
    def agentTimestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """the time the agent started processing"""

    @property
    def investigationPlan(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___InvestigationPlan]:
        """the planned investigations"""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        org: insightproto.proto.common.v1.common_pb2.Organisation | None = ...,
        alert_extraction: global___AlertExtraction | None = ...,
        timeline: collections.abc.Iterable[global___TimelineEvent] | None = ...,
        hypotheses: collections.abc.Iterable[global___Hypothesis] | None = ...,
        trigger: insightproto.proto.jobs.v1.jobs_pb2.Trigger | None = ...,
        metadata: global___MetaData | None = ...,
        createdAt: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updatedAt: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        closedAt: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        agentTimestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        title: builtins.str = ...,
        description: builtins.str = ...,
        status: builtins.str = ...,
        priority: builtins.str = ...,
        investigationPlan: collections.abc.Iterable[global___InvestigationPlan] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["agentTimestamp", b"agentTimestamp", "alert_extraction", b"alert_extraction", "closedAt", b"closedAt", "createdAt", b"createdAt", "metadata", b"metadata", "org", b"org", "trigger", b"trigger", "updatedAt", b"updatedAt"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["agentTimestamp", b"agentTimestamp", "alert_extraction", b"alert_extraction", "closedAt", b"closedAt", "createdAt", b"createdAt", "description", b"description", "hypotheses", b"hypotheses", "id", b"id", "investigationPlan", b"investigationPlan", "metadata", b"metadata", "org", b"org", "priority", b"priority", "status", b"status", "timeline", b"timeline", "title", b"title", "trigger", b"trigger", "updatedAt", b"updatedAt"]) -> None: ...

global___InvestigationResult = InvestigationResult

@typing.final
class InvestigationPlan(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    STEPS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """the name of the plan"""
    description: builtins.str
    """the plan description"""
    @property
    def steps(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """the steps taken by the plan"""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        steps: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "name", b"name", "steps", b"steps"]) -> None: ...

global___InvestigationPlan = InvestigationPlan

@typing.final
class MetaData(google.protobuf.message.Message):
    """MetaData about the agent run"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AGENT_FIELD_NUMBER: builtins.int
    STARTTIME_FIELD_NUMBER: builtins.int
    ENDTIME_FIELD_NUMBER: builtins.int
    TOOLCALLS_FIELD_NUMBER: builtins.int
    PHASE2ITERATIONS_FIELD_NUMBER: builtins.int
    MCPS_FIELD_NUMBER: builtins.int
    TOKENS_FIELD_NUMBER: builtins.int
    toolCalls: builtins.int
    """the number of tool calls"""
    phase2Iterations: builtins.int
    """the number of phase2 iterations"""
    @property
    def agent(self) -> global___Agent:
        """the info about the agent used"""

    @property
    def startTime(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """the time the agent started"""

    @property
    def endTime(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """the time we finished"""

    @property
    def mcps(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MCPCategory]:
        """the mcp configs"""

    @property
    def tokens(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TokenUsage]:
        """tokens usage data"""

    def __init__(
        self,
        *,
        agent: global___Agent | None = ...,
        startTime: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        endTime: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        toolCalls: builtins.int = ...,
        phase2Iterations: builtins.int = ...,
        mcps: collections.abc.Iterable[global___MCPCategory] | None = ...,
        tokens: collections.abc.Iterable[global___TokenUsage] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["agent", b"agent", "endTime", b"endTime", "startTime", b"startTime"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["agent", b"agent", "endTime", b"endTime", "mcps", b"mcps", "phase2Iterations", b"phase2Iterations", "startTime", b"startTime", "tokens", b"tokens", "toolCalls", b"toolCalls"]) -> None: ...

global___MetaData = MetaData

@typing.final
class TokenUsage(google.protobuf.message.Message):
    """TokenUsage stats per model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    OUTPUT_FIELD_NUMBER: builtins.int
    COST_FIELD_NUMBER: builtins.int
    model: builtins.str
    """the model used"""
    input: builtins.int
    """the input tokens used"""
    output: builtins.int
    """the output tokens used"""
    cost: builtins.float
    """the cost estimate in USD"""
    def __init__(
        self,
        *,
        model: builtins.str = ...,
        input: builtins.int = ...,
        output: builtins.int = ...,
        cost: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cost", b"cost", "input", b"input", "model", b"model", "output", b"output"]) -> None: ...

global___TokenUsage = TokenUsage

@typing.final
class MCPCategory(google.protobuf.message.Message):
    """MCPCategory config"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CATEGORY_FIELD_NUMBER: builtins.int
    SERVERS_FIELD_NUMBER: builtins.int
    category: builtins.str
    """the category name (e.g. logs)"""
    @property
    def servers(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """the list of servers available for this category"""

    def __init__(
        self,
        *,
        category: builtins.str = ...,
        servers: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["category", b"category", "servers", b"servers"]) -> None: ...

global___MCPCategory = MCPCategory

@typing.final
class Agent(google.protobuf.message.Message):
    """Agent meta data"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """the name of the agent used"""
    version: builtins.str
    """the version string for the agent"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        version: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["name", b"name", "version", b"version"]) -> None: ...

global___Agent = Agent

@typing.final
class AlertExtraction(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    SUMMARY_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    title: builtins.str
    summary: builtins.str
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        title: builtins.str = ...,
        summary: builtins.str = ...,
        tags: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["timestamp", b"timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["summary", b"summary", "tags", b"tags", "timestamp", b"timestamp", "title", b"title"]) -> None: ...

global___AlertExtraction = AlertExtraction

@typing.final
class TimelineEvent(google.protobuf.message.Message):
    """TimelineEvent represents a single event in the investigation timeline"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ImportanceMappingEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: global___ImportanceLevel.ValueType
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___ImportanceLevel.ValueType = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    TIMESTAMP_FIELD_NUMBER: builtins.int
    SUMMARY_FIELD_NUMBER: builtins.int
    SOURCE_FIELD_NUMBER: builtins.int
    IMPORTANCE_FIELD_NUMBER: builtins.int
    AGENT_TIMESTAMP_FIELD_NUMBER: builtins.int
    LOG_DETAIL_FIELD_NUMBER: builtins.int
    CODE_DETAIL_FIELD_NUMBER: builtins.int
    MERGE_REQUEST_DETAIL_FIELD_NUMBER: builtins.int
    CI_DETAIL_FIELD_NUMBER: builtins.int
    KNOWLEDGE_DETAIL_FIELD_NUMBER: builtins.int
    TICKET_DETAIL_FIELD_NUMBER: builtins.int
    TRIGGER_DETAIL_FIELD_NUMBER: builtins.int
    GENERIC_DETAIL_FIELD_NUMBER: builtins.int
    METRIC_DETAIL_FIELD_NUMBER: builtins.int
    QUERY_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    HYPOTHESIS_FIELD_NUMBER: builtins.int
    IMPORTANCEMAPPING_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    summary: builtins.str
    """the summary description of the data collected"""
    importance: global___ImportanceLevel.ValueType
    """how important this data is to the hypothesis
    Deprecated: see importanceMapping
    """
    query: builtins.str
    """the query used to collect the data - this should be the logical query e.g. Get the logs for service..."""
    id: builtins.str
    """the id of the event used for updates"""
    hypothesis: builtins.str
    """the id of the hypothesis that was active when we collected this data"""
    title: builtins.str
    """the display title to use for this event"""
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """the timestamp of the data (e.g. the earliest log line captured)"""

    @property
    def source(self) -> insightproto.proto.common.v1.common_pb2.Source:
        """the source of the data (e.g. Grafana)"""

    @property
    def agent_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """the time stamp the agent collected this data"""

    @property
    def log_detail(self) -> insightproto.proto.results.v1.timeline_details_pb2.LogDetail:
        """we dont use one_of as this makes the serialisation much more complex"""

    @property
    def code_detail(self) -> insightproto.proto.results.v1.timeline_details_pb2.CodeDetail: ...
    @property
    def merge_request_detail(self) -> insightproto.proto.results.v1.timeline_details_pb2.MergeRequestDetail: ...
    @property
    def ci_detail(self) -> insightproto.proto.results.v1.timeline_details_pb2.CIDetail: ...
    @property
    def knowledge_detail(self) -> insightproto.proto.results.v1.timeline_details_pb2.KnowledgeDetail: ...
    @property
    def ticket_detail(self) -> insightproto.proto.results.v1.timeline_details_pb2.TicketDetail: ...
    @property
    def trigger_detail(self) -> insightproto.proto.results.v1.timeline_details_pb2.TriggerDetail: ...
    @property
    def generic_detail(self) -> insightproto.proto.results.v1.timeline_details_pb2.GenericDetail: ...
    @property
    def metric_detail(self) -> insightproto.proto.results.v1.timeline_details_pb2.MetricDetail: ...
    @property
    def importanceMapping(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, global___ImportanceLevel.ValueType]:
        """the importance level of this data for each hypothesis id"""

    def __init__(
        self,
        *,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        summary: builtins.str = ...,
        source: insightproto.proto.common.v1.common_pb2.Source | None = ...,
        importance: global___ImportanceLevel.ValueType = ...,
        agent_timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        log_detail: insightproto.proto.results.v1.timeline_details_pb2.LogDetail | None = ...,
        code_detail: insightproto.proto.results.v1.timeline_details_pb2.CodeDetail | None = ...,
        merge_request_detail: insightproto.proto.results.v1.timeline_details_pb2.MergeRequestDetail | None = ...,
        ci_detail: insightproto.proto.results.v1.timeline_details_pb2.CIDetail | None = ...,
        knowledge_detail: insightproto.proto.results.v1.timeline_details_pb2.KnowledgeDetail | None = ...,
        ticket_detail: insightproto.proto.results.v1.timeline_details_pb2.TicketDetail | None = ...,
        trigger_detail: insightproto.proto.results.v1.timeline_details_pb2.TriggerDetail | None = ...,
        generic_detail: insightproto.proto.results.v1.timeline_details_pb2.GenericDetail | None = ...,
        metric_detail: insightproto.proto.results.v1.timeline_details_pb2.MetricDetail | None = ...,
        query: builtins.str = ...,
        id: builtins.str = ...,
        hypothesis: builtins.str = ...,
        importanceMapping: collections.abc.Mapping[builtins.str, global___ImportanceLevel.ValueType] | None = ...,
        title: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_ci_detail", b"_ci_detail", "_code_detail", b"_code_detail", "_generic_detail", b"_generic_detail", "_knowledge_detail", b"_knowledge_detail", "_log_detail", b"_log_detail", "_merge_request_detail", b"_merge_request_detail", "_metric_detail", b"_metric_detail", "_ticket_detail", b"_ticket_detail", "_trigger_detail", b"_trigger_detail", "agent_timestamp", b"agent_timestamp", "ci_detail", b"ci_detail", "code_detail", b"code_detail", "generic_detail", b"generic_detail", "knowledge_detail", b"knowledge_detail", "log_detail", b"log_detail", "merge_request_detail", b"merge_request_detail", "metric_detail", b"metric_detail", "source", b"source", "ticket_detail", b"ticket_detail", "timestamp", b"timestamp", "trigger_detail", b"trigger_detail"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_ci_detail", b"_ci_detail", "_code_detail", b"_code_detail", "_generic_detail", b"_generic_detail", "_knowledge_detail", b"_knowledge_detail", "_log_detail", b"_log_detail", "_merge_request_detail", b"_merge_request_detail", "_metric_detail", b"_metric_detail", "_ticket_detail", b"_ticket_detail", "_trigger_detail", b"_trigger_detail", "agent_timestamp", b"agent_timestamp", "ci_detail", b"ci_detail", "code_detail", b"code_detail", "generic_detail", b"generic_detail", "hypothesis", b"hypothesis", "id", b"id", "importance", b"importance", "importanceMapping", b"importanceMapping", "knowledge_detail", b"knowledge_detail", "log_detail", b"log_detail", "merge_request_detail", b"merge_request_detail", "metric_detail", b"metric_detail", "query", b"query", "source", b"source", "summary", b"summary", "ticket_detail", b"ticket_detail", "timestamp", b"timestamp", "title", b"title", "trigger_detail", b"trigger_detail"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_ci_detail", b"_ci_detail"]) -> typing.Literal["ci_detail"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_code_detail", b"_code_detail"]) -> typing.Literal["code_detail"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_generic_detail", b"_generic_detail"]) -> typing.Literal["generic_detail"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_knowledge_detail", b"_knowledge_detail"]) -> typing.Literal["knowledge_detail"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_log_detail", b"_log_detail"]) -> typing.Literal["log_detail"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_merge_request_detail", b"_merge_request_detail"]) -> typing.Literal["merge_request_detail"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_metric_detail", b"_metric_detail"]) -> typing.Literal["metric_detail"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_ticket_detail", b"_ticket_detail"]) -> typing.Literal["ticket_detail"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_trigger_detail", b"_trigger_detail"]) -> typing.Literal["trigger_detail"] | None: ...

global___TimelineEvent = TimelineEvent

@typing.final
class Hypothesis(google.protobuf.message.Message):
    """Hypothesis is an estimated cause of the issue we are investigating"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DESCRIPTION_FIELD_NUMBER: builtins.int
    CONFIDENCE_FIELD_NUMBER: builtins.int
    SUPPORTING_EVIDENCE_FIELD_NUMBER: builtins.int
    TIMELINE_CORRELATION_FIELD_NUMBER: builtins.int
    RECOMMENDATIONS_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    CORRELATIONS_FIELD_NUMBER: builtins.int
    REMEDIATIONS_FIELD_NUMBER: builtins.int
    description: builtins.str
    """the description of the hypothesis"""
    confidence: builtins.int
    """the level (0-100) of how confident we are this is the cause"""
    title: builtins.str
    """the hypothesis title"""
    id: builtins.str
    """the id of the hypothesis"""
    @property
    def supporting_evidence(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """this is the summary of the supporting evidence
        Deprecated: see correlations
        """

    @property
    def timeline_correlation(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Deprecated: see correlations"""

    @property
    def recommendations(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """the recommended actions to take
        Deprecated: see remediations
        """

    @property
    def correlations(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """a list of timeline events"""

    @property
    def remediations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Remediation]:
        """a list of possible remediation tasks"""

    def __init__(
        self,
        *,
        description: builtins.str = ...,
        confidence: builtins.int = ...,
        supporting_evidence: collections.abc.Iterable[builtins.str] | None = ...,
        timeline_correlation: collections.abc.Iterable[builtins.str] | None = ...,
        recommendations: collections.abc.Iterable[builtins.str] | None = ...,
        title: builtins.str = ...,
        id: builtins.str = ...,
        correlations: collections.abc.Iterable[builtins.str] | None = ...,
        remediations: collections.abc.Iterable[global___Remediation] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["confidence", b"confidence", "correlations", b"correlations", "description", b"description", "id", b"id", "recommendations", b"recommendations", "remediations", b"remediations", "supporting_evidence", b"supporting_evidence", "timeline_correlation", b"timeline_correlation", "title", b"title"]) -> None: ...

global___Hypothesis = Hypothesis

@typing.final
class Remediation(google.protobuf.message.Message):
    """Remediation describes a task to help prevent or improve the situation that causes this investigation"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TITLE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    TASKS_FIELD_NUMBER: builtins.int
    ESTIMATE_FIELD_NUMBER: builtins.int
    title: builtins.str
    """the title of this remediation (e.g. OP-123 Add additional logging when deleting a team member)"""
    description: builtins.str
    """the description of this remediation (e.g. We need to gather more information about what happened...)"""
    estimate: builtins.str
    """an estimate of the clock time required (e.g. 1 day)"""
    @property
    def tasks(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """a list of tasks that describe in more detail the actions required
        e.g. add a log line that details the user that is being removed, and who is deleting the user
        """

    def __init__(
        self,
        *,
        title: builtins.str = ...,
        description: builtins.str = ...,
        tasks: collections.abc.Iterable[builtins.str] | None = ...,
        estimate: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "estimate", b"estimate", "tasks", b"tasks", "title", b"title"]) -> None: ...

global___Remediation = Remediation
