import { CustomResource, RemovalPolicy } from "aws-cdk-lib";
import { Construct } from "constructs";
import { GithubActionsSecret } from "./github-actions-secret";
import { GithubCustomResourceBase, GithubCustomResourceOptions } from "./github-custom-resource";
export interface GithubActionsSecretEnvironmentProps extends GithubCustomResourceOptions {
    /**
     * The unique identifier of the repository.
     */
    readonly repositoryId: string;
    /**
     * The GitHub Environment name. The name is not case-sensitive.
     */
    readonly environmentName: string;
    /**
     * The GitHub secret name.
     */
    readonly secretName: string;
    /**
     * The SSM Secret.
     */
    readonly source: GithubActionsSecret;
    /**
     * Whether to DESTROY or RETAIN the secret on resource removal.
     * @default RETAIN
     */
    readonly removalPolicy?: RemovalPolicy;
}
/**
 * Manage an GitHib Actions environment secret.
 *
 * ```typescript
 * // The GitHub API authentication secret
 * const auth = secrets_manager.Secret.fromSecretNameV2(scope, "Auth", "cdk-github/github-token");
 *
 * // The AWS SecretsManager Secret to configure as GitHub Action secret.
 * const secret = secrets_manager.Secret.fromSecretNameV2(scope, "Secret", "any-secret/example");
 *
 * new GithubActionsSecretEnvironment(scope, "GithubRepo", {
 *   repositoryId: "558989134",
 *   environmentName: "production",
 *   secretName: "example",
 *   source: GithubActionsSecret.fromSecretsManager(secret, "some-json-field"),
 *   authOptions: AuthOptions.appAuth(auth),
 *   removalPolicy: RemovalPolicy.DESTROY,
 * });
 * ```
 */
export declare class GithubActionsSecretEnvironment extends GithubCustomResourceBase {
    /**
     * @internal
     */
    readonly _resource: CustomResource;
    constructor(scope: Construct, id: string, props: GithubActionsSecretEnvironmentProps);
}
