"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubActionsSecret = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
class GithubActionsSecret {
    constructor(secret, field) {
        this.creationStack = aws_cdk_lib_1.captureStackTrace();
        this.secret = secret;
        this.field = field;
    }
    static fromSecretsManager(secret, field) {
        return new GithubActionsSecret(secret, field);
    }
    resolve(_) {
        return { arn: this.secret.secretArn, field: this.field };
    }
    /**
     * @internal
     */
    _grantRead(grantee) {
        this.secret.grantRead(grantee);
    }
}
exports.GithubActionsSecret = GithubActionsSecret;
//# sourceMappingURL=data:application/json;base64,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