# coding: utf-8

# flake8: noqa

"""
    BitBadges API

    # Introduction The BitBadges API is a RESTful API that enables developers to interact with the BitBadges blockchain and indexer. This API provides comprehensive access to the BitBadges ecosystem, allowing you to query and interact with digital badges, collections, accounts, blockchain data, and more. For complete documentation, see the [BitBadges Documentation](https://docs.bitbadges.io/for-developers/bitbadges-api/api) and use along with this reference.  Note: The API + documentation is new and may contain bugs. If you find any issues, please let us know via Discord or another contact method (https://bitbadges.io/contact).  # Getting Started  ## Authentication All API requests require an API key for authentication. You can obtain your API key from the [BitBadges Developer Portal](https://bitbadges.io/developer).  ### API Key Authentication Include your API key in the `x-api-key` header: ``` x-api-key: your-api-key-here ```  <br />  ## User Authentication Most read-only applications can function with just an API key. However, if you need to access private user data or perform actions on behalf of users, you have two options:  ### OAuth 2.0 (Sign In with BitBadges) For performing actions on behalf of other users, use the standard OAuth 2.0 flow via Sign In with BitBadges. See the [Sign In with BitBadges documentation](https://docs.bitbadges.io/for-developers/authenticating-with-bitbadges) for details.  You will pass the access token in the Authorization header: ``` Authorization: Bearer your-access-token-here ```  ### Password Self-Approve Method For automating actions for your own account: 1. Set up an approved password sign in in your account settings tab on https://bitbadges.io with desired scopes (e.g. `completeClaims`) 2. Sign in using: ```typescript const { message } = await BitBadgesApi.getSignInChallenge(...); const verificationRes = await BitBadgesApi.verifySignIn({     message,     signature: '', //Empty string     password: '...' }) ```  Note: This method uses HTTP session cookies. Ensure your requests support credentials (e.g. axios: { withCredentials: true }).  ### Scopes Note that for proper authentication, you must have the proper scopes set.  See [https://bitbadges.io/auth/linkgen](https://bitbadges.io/auth/linkgen) for a helper URL generation tool. The scopes will be included in the `scope` parameter of the SIWBB URL or set in your approved sign in settings.  Note that stuff marked as Full Access is typically reserved for the official site. If you think you may need this, contact us.  ### Available Scopes  - **Report** (`report`)   Report users or collections.  - **Read Profile** (`readProfile`)   Read your private profile information. This includes your email, approved sign-in methods, connections, and other private information.  - **Read Address Lists** (`readAddressLists`)   Read private address lists on behalf of the user.  - **Manage Address Lists** (`manageAddressLists`)   Create, update, and delete address lists on behalf of the user (private or public).  - **Manage Applications** (`manageApplications`)   Create, update, and delete applications on behalf of the user.  - **Manage Claims** (`manageClaims`)   Create, update, and delete claims on behalf of the user.  - **Manage Developer Apps** (`manageDeveloperApps`)   Create, update, and delete developer apps on behalf of the user.  - **Manage Dynamic Stores** (`manageDynamicStores`)   Create, update, and delete dynamic stores on behalf of the user.  - **Manage Utility Listings** (`manageUtilityListings`)   Create, update, and delete utility listings on behalf of the user.  - **Approve Sign In With BitBadges Requests** (`approveSignInWithBitBadgesRequests`)   Sign In with BitBadges on behalf of the user.  - **Read Authentication Codes** (`readAuthenticationCodes`)   Read Authentication Codes on behalf of the user.  - **Delete Authentication Codes** (`deleteAuthenticationCodes`)   Delete Authentication Codes on behalf of the user.  - **Send Claim Alerts** (`sendClaimAlerts`)   Send claim alerts on behalf of the user.  - **Read Claim Alerts** (`readClaimAlerts`)   Read claim alerts on behalf of the user. Note that claim alerts may contain sensitive information like claim codes, attestation IDs, etc.  - **Manage Attestations** (`manageAttestations`)   Manage attestations on behalf of the user. This includes creating, updating, and deleting attestations.  - **Read Attestations** (`readAttestations`)   Read attestations on behalf of the user.  - **Read Private Claim Data** (`readPrivateClaimData`)   Read private claim data on behalf of the user (e.g. codes, passwords, private user lists, etc.).  - **Complete Claims** (`completeClaims`)   Complete claims on behalf of the user.  - **Manage Off-Chain Balances** (`manageOffChainBalances`)   Manage off-chain balances on behalf of the user.  - **Embedded Wallet** (`embeddedWallet`)   Sign transactions on behalf of the user with their embedded wallet.  <br />  ## SDK Integration The recommended way to interact with the API is through our TypeScript/JavaScript SDK:  ```typescript import { BigIntify, BitBadgesAPI } from \"bitbadgesjs-sdk\";  // Initialize the API client const api = new BitBadgesAPI({   convertFunction: BigIntify,   apiKey: 'your-api-key-here' });  // Example: Fetch collections const collections = await api.getCollections({   collectionsToFetch: [{     collectionId: 1n,     metadataToFetch: {       badgeIds: [{ start: 1n, end: 10n }]     }   }] }); ```  <br />  # Tiers There are 3 tiers of API keys, each with different rate limits and permissions. See the pricing page for more details: https://bitbadges.io/pricing - Free tier - Premium tier - Enterprise tier  Rate limit headers included in responses: - `X-RateLimit-Limit`: Total requests allowed per window - `X-RateLimit-Remaining`: Remaining requests in current window - `X-RateLimit-Reset`: Time until rate limit resets (UTC timestamp)  # Response Formats  ## Error Response  All API errors follow a consistent format:  ```typescript {   // Serialized error object for debugging purposes   // Advanced users can use this to debug issues   error?: any;    // UX-friendly error message that can be displayed to the user   // Always present if error occurs   errorMessage: string;    // Authentication error flag   // Present if the user is not authenticated   unauthorized?: boolean; } ```  <br />  ## Pagination Cursor-based pagination is used for list endpoints: ```typescript {   items: T[],   bookmark: string, // Use this for the next page   hasMore: boolean } ```  <br />  # Best Practices 1. **Rate Limiting**: Implement proper rate limit handling 2. **Caching**: Cache responses when appropriate 3. **Error Handling**: Handle API errors gracefully 4. **Batch Operations**: Use batch endpoints when possible  # Additional Resources - [Official Documentation](https://docs.bitbadges.io/for-developers/bitbadges-api/api) - [SDK Documentation](https://docs.bitbadges.io/for-developers/bitbadges-sdk/overview) - [Developer Portal](https://bitbadges.io/developer) - [GitHub SDK Repository](https://github.com/bitbadges/bitbadgesjs) - [Quickstarter Repository](https://github.com/bitbadges/bitbadges-quickstart)  # Support - [Contact Page](https://bitbadges.io/contact)

    The version of the OpenAPI document: 0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


__version__ = "0.1.42"

# import apis into sdk package
from bitbadgespy_sdk.api.accounts_api import AccountsApi
from bitbadgespy_sdk.api.address_lists_api import AddressListsApi
from bitbadgespy_sdk.api.applications_api import ApplicationsApi
from bitbadgespy_sdk.api.attestations_api import AttestationsApi
from bitbadgespy_sdk.api.badges_api import BadgesApi
from bitbadgespy_sdk.api.claim_alerts_api import ClaimAlertsApi
from bitbadgespy_sdk.api.claims_api import ClaimsApi
from bitbadgespy_sdk.api.dynamic_stores_api import DynamicStoresApi
from bitbadgespy_sdk.api.maps_and_protocols_api import MapsAndProtocolsApi
from bitbadgespy_sdk.api.miscellanous_api import MiscellanousApi
from bitbadgespy_sdk.api.plugins_api import PluginsApi
from bitbadgespy_sdk.api.sign_in_with_bit_badges_api import SignInWithBitBadgesApi
from bitbadgespy_sdk.api.transactions_api import TransactionsApi
from bitbadgespy_sdk.api.utility_listings_api import UtilityListingsApi

# import ApiClient
from bitbadgespy_sdk.api_response import ApiResponse
from bitbadgespy_sdk.api_client import ApiClient
from bitbadgespy_sdk.configuration import Configuration
from bitbadgespy_sdk.exceptions import OpenApiException
from bitbadgespy_sdk.exceptions import ApiTypeError
from bitbadgespy_sdk.exceptions import ApiValueError
from bitbadgespy_sdk.exceptions import ApiKeyError
from bitbadgespy_sdk.exceptions import ApiAttributeError
from bitbadgespy_sdk.exceptions import ApiException

# import models into sdk package
from bitbadgespy_sdk.models.account_fetch_details import AccountFetchDetails
from bitbadgespy_sdk.models.account_fetch_details_views_to_fetch_inner import AccountFetchDetailsViewsToFetchInner
from bitbadgespy_sdk.models.account_response import AccountResponse
from bitbadgespy_sdk.models.account_response_account import AccountResponseAccount
from bitbadgespy_sdk.models.account_response_account_base_account import AccountResponseAccountBaseAccount
from bitbadgespy_sdk.models.account_response_account_base_account_pub_key import AccountResponseAccountBaseAccountPubKey
from bitbadgespy_sdk.models.account_view_key import AccountViewKey
from bitbadgespy_sdk.models.additional_query_params import AdditionalQueryParams
from bitbadgespy_sdk.models.address_list_view_key import AddressListViewKey
from bitbadgespy_sdk.models.amino_converter import AminoConverter
from bitbadgespy_sdk.models.amino_msg import AminoMsg
from bitbadgespy_sdk.models.and_group import AndGroup
from bitbadgespy_sdk.models.asset_condition_group import AssetConditionGroup
from bitbadgespy_sdk.models.asset_details import AssetDetails
from bitbadgespy_sdk.models.asset_details_asset_ids_inner import AssetDetailsAssetIdsInner
from bitbadgespy_sdk.models.attribute import Attribute
from bitbadgespy_sdk.models.broadcast_post_body import BroadcastPostBody
from bitbadgespy_sdk.models.broadcast_tx_request import BroadcastTxRequest
from bitbadgespy_sdk.models.chain import Chain
from bitbadgespy_sdk.models.challenge_params import ChallengeParams
from bitbadgespy_sdk.models.channel import Channel
from bitbadgespy_sdk.models.channels_response import ChannelsResponse
from bitbadgespy_sdk.models.channels_response_height import ChannelsResponseHeight
from bitbadgespy_sdk.models.channels_response_pagination import ChannelsResponsePagination
from bitbadgespy_sdk.models.code_gen_query_params import CodeGenQueryParams
from bitbadgespy_sdk.models.collection_view_key import CollectionViewKey
from bitbadgespy_sdk.models.convert_options import ConvertOptions
from bitbadgespy_sdk.models.cosmos_account_response import CosmosAccountResponse
from bitbadgespy_sdk.models.cosmos_account_response_pub_key import CosmosAccountResponsePubKey
from bitbadgespy_sdk.models.cosmos_event import CosmosEvent
from bitbadgespy_sdk.models.counter_party import CounterParty
from bitbadgespy_sdk.models.create_claim_request import CreateClaimRequest
from bitbadgespy_sdk.models.create_claim_request_metadata import CreateClaimRequestMetadata
from bitbadgespy_sdk.models.deliver_tx_response import DeliverTxResponse
from bitbadgespy_sdk.models.deliver_tx_response_msg_responses_inner import DeliverTxResponseMsgResponsesInner
from bitbadgespy_sdk.models.doc import Doc
from bitbadgespy_sdk.models.dynamic_data_handler_action_request import DynamicDataHandlerActionRequest
from bitbadgespy_sdk.models.dynamic_data_handler_type import DynamicDataHandlerType
from bitbadgespy_sdk.models.eip712_to_sign import EIP712ToSign
from bitbadgespy_sdk.models.eip712_to_sign_domain import EIP712ToSignDomain
from bitbadgespy_sdk.models.encode_object import EncodeObject
from bitbadgespy_sdk.models.error_doc import ErrorDoc
from bitbadgespy_sdk.models.error_response import ErrorResponse
from bitbadgespy_sdk.models.fee import Fee
from bitbadgespy_sdk.models.generate_code200_response import GenerateCode200Response
from bitbadgespy_sdk.models.get_additional_collection_details_payload import GetAdditionalCollectionDetailsPayload
from bitbadgespy_sdk.models.get_additional_collection_details_payload_views_to_fetch_inner import GetAdditionalCollectionDetailsPayloadViewsToFetchInner
from bitbadgespy_sdk.models.get_collection_request_body import GetCollectionRequestBody
from bitbadgespy_sdk.models.get_collection_request_body_views_to_fetch_inner import GetCollectionRequestBodyViewsToFetchInner
from bitbadgespy_sdk.models.get_metadata_for_collection_payload import GetMetadataForCollectionPayload
from bitbadgespy_sdk.models.get_metadata_for_collection_payload_badge_floor_prices_to_fetch import GetMetadataForCollectionPayloadBadgeFloorPricesToFetch
from bitbadgespy_sdk.models.get_undelegations_response import GetUndelegationsResponse
from bitbadgespy_sdk.models.get_undelegations_response_pagination import GetUndelegationsResponsePagination
from bitbadgespy_sdk.models.get_validators_response import GetValidatorsResponse
from bitbadgespy_sdk.models.get_validators_response_pagination import GetValidatorsResponsePagination
from bitbadgespy_sdk.models.i_access_token_doc import IAccessTokenDoc
from bitbadgespy_sdk.models.i_account_doc import IAccountDoc
from bitbadgespy_sdk.models.i_action_permission import IActionPermission
from bitbadgespy_sdk.models.i_activity_doc import IActivityDoc
from bitbadgespy_sdk.models.i_add_approval_details_to_off_chain_storage_payload import IAddApprovalDetailsToOffChainStoragePayload
from bitbadgespy_sdk.models.i_add_approval_details_to_off_chain_storage_payload_approval_details_inner import IAddApprovalDetailsToOffChainStoragePayloadApprovalDetailsInner
from bitbadgespy_sdk.models.i_add_approval_details_to_off_chain_storage_success_response import IAddApprovalDetailsToOffChainStorageSuccessResponse
from bitbadgespy_sdk.models.i_add_approval_details_to_off_chain_storage_success_response_approval_results_inner import IAddApprovalDetailsToOffChainStorageSuccessResponseApprovalResultsInner
from bitbadgespy_sdk.models.i_add_approval_details_to_off_chain_storage_success_response_approval_results_inner_challenge_results_inner import IAddApprovalDetailsToOffChainStorageSuccessResponseApprovalResultsInnerChallengeResultsInner
from bitbadgespy_sdk.models.i_add_approval_details_to_off_chain_storage_success_response_approval_results_inner_metadata_result import IAddApprovalDetailsToOffChainStorageSuccessResponseApprovalResultsInnerMetadataResult
from bitbadgespy_sdk.models.i_add_balances_to_off_chain_storage_payload import IAddBalancesToOffChainStoragePayload
from bitbadgespy_sdk.models.i_add_balances_to_off_chain_storage_payload_claims_inner import IAddBalancesToOffChainStoragePayloadClaimsInner
from bitbadgespy_sdk.models.i_add_balances_to_off_chain_storage_success_response import IAddBalancesToOffChainStorageSuccessResponse
from bitbadgespy_sdk.models.i_add_to_ipfs_payload import IAddToIpfsPayload
from bitbadgespy_sdk.models.i_add_to_ipfs_payload_contents_inner import IAddToIpfsPayloadContentsInner
from bitbadgespy_sdk.models.i_add_to_ipfs_success_response import IAddToIpfsSuccessResponse
from bitbadgespy_sdk.models.i_add_to_ipfs_success_response_results_inner import IAddToIpfsSuccessResponseResultsInner
from bitbadgespy_sdk.models.i_address_list import IAddressList
from bitbadgespy_sdk.models.i_address_list_create_object import IAddressListCreateObject
from bitbadgespy_sdk.models.i_address_list_doc import IAddressListDoc
from bitbadgespy_sdk.models.i_address_list_doc_nsfw import IAddressListDocNsfw
from bitbadgespy_sdk.models.i_address_list_doc_reported import IAddressListDocReported
from bitbadgespy_sdk.models.i_address_list_edit_key import IAddressListEditKey
from bitbadgespy_sdk.models.i_airdrop_doc import IAirdropDoc
from bitbadgespy_sdk.models.i_amount_tracker_id_details import IAmountTrackerIdDetails
from bitbadgespy_sdk.models.i_api_key_doc import IApiKeyDoc
from bitbadgespy_sdk.models.i_application_doc import IApplicationDoc
from bitbadgespy_sdk.models.i_application_page import IApplicationPage
from bitbadgespy_sdk.models.i_approval_amounts import IApprovalAmounts
from bitbadgespy_sdk.models.i_approval_criteria import IApprovalCriteria
from bitbadgespy_sdk.models.i_approval_identifier_details import IApprovalIdentifierDetails
from bitbadgespy_sdk.models.i_approval_info_details import IApprovalInfoDetails
from bitbadgespy_sdk.models.i_approval_item_doc import IApprovalItemDoc
from bitbadgespy_sdk.models.i_approval_tracker_doc import IApprovalTrackerDoc
from bitbadgespy_sdk.models.i_attestation import IAttestation
from bitbadgespy_sdk.models.i_attestation_anchors_inner import IAttestationAnchorsInner
from bitbadgespy_sdk.models.i_attestation_data_integrity_proof import IAttestationDataIntegrityProof
from bitbadgespy_sdk.models.i_attestation_doc import IAttestationDoc
from bitbadgespy_sdk.models.i_attestation_doc_anchors_inner import IAttestationDocAnchorsInner
from bitbadgespy_sdk.models.i_attestation_doc_data_integrity_proof import IAttestationDocDataIntegrityProof
from bitbadgespy_sdk.models.i_attestation_doc_proof_of_issuance import IAttestationDocProofOfIssuance
from bitbadgespy_sdk.models.i_attestation_proof_of_issuance import IAttestationProofOfIssuance
from bitbadgespy_sdk.models.i_attestations_proof import IAttestationsProof
from bitbadgespy_sdk.models.i_attestations_proof_anchors_inner import IAttestationsProofAnchorsInner
from bitbadgespy_sdk.models.i_attestations_proof_data_integrity_proof import IAttestationsProofDataIntegrityProof
from bitbadgespy_sdk.models.i_attestations_proof_proof_of_issuance import IAttestationsProofProofOfIssuance
from bitbadgespy_sdk.models.i_auto_deletion_options import IAutoDeletionOptions
from bitbadgespy_sdk.models.i_badge_floor_price_doc import IBadgeFloorPriceDoc
from bitbadgespy_sdk.models.i_badge_ids_action_permission import IBadgeIdsActionPermission
from bitbadgespy_sdk.models.i_badge_metadata import IBadgeMetadata
from bitbadgespy_sdk.models.i_badge_metadata_details import IBadgeMetadataDetails
from bitbadgespy_sdk.models.i_badge_metadata_timeline import IBadgeMetadataTimeline
from bitbadgespy_sdk.models.i_balance import IBalance
from bitbadgespy_sdk.models.i_balance_doc import IBalanceDoc
from bitbadgespy_sdk.models.i_base_query_params import IBaseQueryParams
from bitbadgespy_sdk.models.i_base_stats import IBaseStats
from bitbadgespy_sdk.models.i_base_success_response import IBaseSuccessResponse
from bitbadgespy_sdk.models.i_batch_badge_details import IBatchBadgeDetails
from bitbadgespy_sdk.models.i_bit_badges_collection import IBitBadgesCollection
from bitbadgespy_sdk.models.i_bit_badges_collection_views_value import IBitBadgesCollectionViewsValue
from bitbadgespy_sdk.models.i_bit_badges_user_info import IBitBadgesUserInfo
from bitbadgespy_sdk.models.i_bit_badges_user_info_alias import IBitBadgesUserInfoAlias
from bitbadgespy_sdk.models.i_bit_badges_user_info_approved_sign_in_methods import IBitBadgesUserInfoApprovedSignInMethods
from bitbadgespy_sdk.models.i_bit_badges_user_info_approved_sign_in_methods_addresses_inner import IBitBadgesUserInfoApprovedSignInMethodsAddressesInner
from bitbadgespy_sdk.models.i_bit_badges_user_info_approved_sign_in_methods_discord import IBitBadgesUserInfoApprovedSignInMethodsDiscord
from bitbadgespy_sdk.models.i_bit_badges_user_info_approved_sign_in_methods_github import IBitBadgesUserInfoApprovedSignInMethodsGithub
from bitbadgespy_sdk.models.i_bit_badges_user_info_approved_sign_in_methods_google import IBitBadgesUserInfoApprovedSignInMethodsGoogle
from bitbadgespy_sdk.models.i_bit_badges_user_info_approved_sign_in_methods_passwords_inner import IBitBadgesUserInfoApprovedSignInMethodsPasswordsInner
from bitbadgespy_sdk.models.i_bit_badges_user_info_custom_pages import IBitBadgesUserInfoCustomPages
from bitbadgespy_sdk.models.i_bit_badges_user_info_nsfw import IBitBadgesUserInfoNsfw
from bitbadgespy_sdk.models.i_bit_badges_user_info_reported import IBitBadgesUserInfoReported
from bitbadgespy_sdk.models.i_bit_badges_user_info_views_value import IBitBadgesUserInfoViewsValue
from bitbadgespy_sdk.models.i_bit_badges_user_info_watchlists import IBitBadgesUserInfoWatchlists
from bitbadgespy_sdk.models.i_broadcast_tx_success_response import IBroadcastTxSuccessResponse
from bitbadgespy_sdk.models.i_broadcast_tx_success_response_tx_response import IBroadcastTxSuccessResponseTxResponse
from bitbadgespy_sdk.models.i_broadcast_tx_success_response_tx_response_events_inner import IBroadcastTxSuccessResponseTxResponseEventsInner
from bitbadgespy_sdk.models.i_broadcast_tx_success_response_tx_response_events_inner_attributes_inner import IBroadcastTxSuccessResponseTxResponseEventsInnerAttributesInner
from bitbadgespy_sdk.models.i_broadcast_tx_success_response_tx_response_logs_inner import IBroadcastTxSuccessResponseTxResponseLogsInner
from bitbadgespy_sdk.models.i_broadcast_tx_success_response_tx_response_logs_inner_events_inner import IBroadcastTxSuccessResponseTxResponseLogsInnerEventsInner
from bitbadgespy_sdk.models.i_broadcast_tx_success_response_tx_response_logs_inner_events_inner_attributes_inner import IBroadcastTxSuccessResponseTxResponseLogsInnerEventsInnerAttributesInner
from bitbadgespy_sdk.models.i_calculate_points_payload import ICalculatePointsPayload
from bitbadgespy_sdk.models.i_calculate_points_success_response import ICalculatePointsSuccessResponse
from bitbadgespy_sdk.models.i_challenge_details import IChallengeDetails
from bitbadgespy_sdk.models.i_challenge_info_details import IChallengeInfoDetails
from bitbadgespy_sdk.models.i_challenge_info_details_update import IChallengeInfoDetailsUpdate
from bitbadgespy_sdk.models.i_challenge_tracker_id_details import IChallengeTrackerIdDetails
from bitbadgespy_sdk.models.i_check_claim_success_success_response import ICheckClaimSuccessSuccessResponse
from bitbadgespy_sdk.models.i_check_sign_in_status_success_response import ICheckSignInStatusSuccessResponse
from bitbadgespy_sdk.models.i_check_sign_in_status_success_response_bluesky import ICheckSignInStatusSuccessResponseBluesky
from bitbadgespy_sdk.models.i_check_sign_in_status_success_response_discord import ICheckSignInStatusSuccessResponseDiscord
from bitbadgespy_sdk.models.i_check_sign_in_status_success_response_facebook import ICheckSignInStatusSuccessResponseFacebook
from bitbadgespy_sdk.models.i_check_sign_in_status_success_response_farcaster import ICheckSignInStatusSuccessResponseFarcaster
from bitbadgespy_sdk.models.i_check_sign_in_status_success_response_github import ICheckSignInStatusSuccessResponseGithub
from bitbadgespy_sdk.models.i_check_sign_in_status_success_response_google import ICheckSignInStatusSuccessResponseGoogle
from bitbadgespy_sdk.models.i_check_sign_in_status_success_response_google_calendar import ICheckSignInStatusSuccessResponseGoogleCalendar
from bitbadgespy_sdk.models.i_check_sign_in_status_success_response_linked_in import ICheckSignInStatusSuccessResponseLinkedIn
from bitbadgespy_sdk.models.i_check_sign_in_status_success_response_mailchimp import ICheckSignInStatusSuccessResponseMailchimp
from bitbadgespy_sdk.models.i_check_sign_in_status_success_response_meetup import ICheckSignInStatusSuccessResponseMeetup
from bitbadgespy_sdk.models.i_check_sign_in_status_success_response_reddit import ICheckSignInStatusSuccessResponseReddit
from bitbadgespy_sdk.models.i_check_sign_in_status_success_response_shopify import ICheckSignInStatusSuccessResponseShopify
from bitbadgespy_sdk.models.i_check_sign_in_status_success_response_slack import ICheckSignInStatusSuccessResponseSlack
from bitbadgespy_sdk.models.i_check_sign_in_status_success_response_strava import ICheckSignInStatusSuccessResponseStrava
from bitbadgespy_sdk.models.i_check_sign_in_status_success_response_telegram import ICheckSignInStatusSuccessResponseTelegram
from bitbadgespy_sdk.models.i_check_sign_in_status_success_response_twitch import ICheckSignInStatusSuccessResponseTwitch
from bitbadgespy_sdk.models.i_check_sign_in_status_success_response_twitter import ICheckSignInStatusSuccessResponseTwitter
from bitbadgespy_sdk.models.i_check_sign_in_status_success_response_youtube import ICheckSignInStatusSuccessResponseYoutube
from bitbadgespy_sdk.models.i_claim_activity_doc import IClaimActivityDoc
from bitbadgespy_sdk.models.i_claim_alert_doc import IClaimAlertDoc
from bitbadgespy_sdk.models.i_claim_attempt import IClaimAttempt
from bitbadgespy_sdk.models.i_claim_builder_doc import IClaimBuilderDoc
from bitbadgespy_sdk.models.i_claim_builder_doc_action import IClaimBuilderDocAction
from bitbadgespy_sdk.models.i_claim_cache_policy import IClaimCachePolicy
from bitbadgespy_sdk.models.i_claim_details import IClaimDetails
from bitbadgespy_sdk.models.i_claim_details_template_info import IClaimDetailsTemplateInfo
from bitbadgespy_sdk.models.i_claim_gated_content import IClaimGatedContent
from bitbadgespy_sdk.models.i_claim_reward import IClaimReward
from bitbadgespy_sdk.models.i_claim_reward_calculation_method import IClaimRewardCalculationMethod
from bitbadgespy_sdk.models.i_claim_reward_metadata import IClaimRewardMetadata
from bitbadgespy_sdk.models.i_coin_transfer import ICoinTransfer
from bitbadgespy_sdk.models.i_coin_transfer_item import ICoinTransferItem
from bitbadgespy_sdk.models.i_collection_approval import ICollectionApproval
from bitbadgespy_sdk.models.i_collection_approval_permission import ICollectionApprovalPermission
from bitbadgespy_sdk.models.i_collection_doc import ICollectionDoc
from bitbadgespy_sdk.models.i_collection_metadata import ICollectionMetadata
from bitbadgespy_sdk.models.i_collection_metadata_details import ICollectionMetadataDetails
from bitbadgespy_sdk.models.i_collection_metadata_timeline import ICollectionMetadataTimeline
from bitbadgespy_sdk.models.i_collection_nsfw import ICollectionNSFW
from bitbadgespy_sdk.models.i_collection_permissions import ICollectionPermissions
from bitbadgespy_sdk.models.i_collection_stats_doc import ICollectionStatsDoc
from bitbadgespy_sdk.models.i_complete_claim_payload import ICompleteClaimPayload
from bitbadgespy_sdk.models.i_complete_claim_success_response import ICompleteClaimSuccessResponse
from bitbadgespy_sdk.models.i_compliance_doc import IComplianceDoc
from bitbadgespy_sdk.models.i_compliance_doc_accounts import IComplianceDocAccounts
from bitbadgespy_sdk.models.i_compliance_doc_accounts_nsfw_inner import IComplianceDocAccountsNsfwInner
from bitbadgespy_sdk.models.i_compliance_doc_address_lists import IComplianceDocAddressLists
from bitbadgespy_sdk.models.i_compliance_doc_address_lists_nsfw_inner import IComplianceDocAddressListsNsfwInner
from bitbadgespy_sdk.models.i_compliance_doc_applications import IComplianceDocApplications
from bitbadgespy_sdk.models.i_compliance_doc_applications_nsfw_inner import IComplianceDocApplicationsNsfwInner
from bitbadgespy_sdk.models.i_compliance_doc_badges import IComplianceDocBadges
from bitbadgespy_sdk.models.i_compliance_doc_claims import IComplianceDocClaims
from bitbadgespy_sdk.models.i_compliance_doc_claims_nsfw_inner import IComplianceDocClaimsNsfwInner
from bitbadgespy_sdk.models.i_compliance_doc_maps import IComplianceDocMaps
from bitbadgespy_sdk.models.i_compliance_doc_maps_nsfw_inner import IComplianceDocMapsNsfwInner
from bitbadgespy_sdk.models.i_cosmos_coin import ICosmosCoin
from bitbadgespy_sdk.models.i_cosmos_coin_wrapper_path import ICosmosCoinWrapperPath
from bitbadgespy_sdk.models.i_cosmos_coin_wrapper_path_add_object import ICosmosCoinWrapperPathAddObject
from bitbadgespy_sdk.models.i_create_address_lists_payload import ICreateAddressListsPayload
from bitbadgespy_sdk.models.i_create_api_key_payload import ICreateApiKeyPayload
from bitbadgespy_sdk.models.i_create_api_key_success_response import ICreateApiKeySuccessResponse
from bitbadgespy_sdk.models.i_create_application_payload import ICreateApplicationPayload
from bitbadgespy_sdk.models.i_create_application_success_response import ICreateApplicationSuccessResponse
from bitbadgespy_sdk.models.i_create_attestation_payload import ICreateAttestationPayload
from bitbadgespy_sdk.models.i_create_attestation_payload_anchors_inner import ICreateAttestationPayloadAnchorsInner
from bitbadgespy_sdk.models.i_create_attestation_payload_proof_of_issuance import ICreateAttestationPayloadProofOfIssuance
from bitbadgespy_sdk.models.i_create_attestation_success_response import ICreateAttestationSuccessResponse
from bitbadgespy_sdk.models.i_create_claim_payload import ICreateClaimPayload
from bitbadgespy_sdk.models.i_create_developer_app_payload import ICreateDeveloperAppPayload
from bitbadgespy_sdk.models.i_create_developer_app_success_response import ICreateDeveloperAppSuccessResponse
from bitbadgespy_sdk.models.i_create_dynamic_data_store_payload import ICreateDynamicDataStorePayload
from bitbadgespy_sdk.models.i_create_dynamic_data_store_success_response import ICreateDynamicDataStoreSuccessResponse
from bitbadgespy_sdk.models.i_create_payment_intent_payload import ICreatePaymentIntentPayload
from bitbadgespy_sdk.models.i_create_payment_intent_success_response import ICreatePaymentIntentSuccessResponse
from bitbadgespy_sdk.models.i_create_plugin_payload import ICreatePluginPayload
from bitbadgespy_sdk.models.i_create_plugin_payload_metadata import ICreatePluginPayloadMetadata
from bitbadgespy_sdk.models.i_create_siwbb_request_payload import ICreateSIWBBRequestPayload
from bitbadgespy_sdk.models.i_create_siwbb_request_success_response import ICreateSIWBBRequestSuccessResponse
from bitbadgespy_sdk.models.i_create_utility_listing_payload import ICreateUtilityListingPayload
from bitbadgespy_sdk.models.i_create_utility_listing_success_response import ICreateUtilityListingSuccessResponse
from bitbadgespy_sdk.models.i_creator_credits_doc import ICreatorCreditsDoc
from bitbadgespy_sdk.models.i_custom_data_timeline import ICustomDataTimeline
from bitbadgespy_sdk.models.i_custom_link import ICustomLink
from bitbadgespy_sdk.models.i_custom_list_page import ICustomListPage
from bitbadgespy_sdk.models.i_custom_page import ICustomPage
from bitbadgespy_sdk.models.i_delete_address_lists_payload import IDeleteAddressListsPayload
from bitbadgespy_sdk.models.i_delete_api_key_payload import IDeleteApiKeyPayload
from bitbadgespy_sdk.models.i_delete_application_payload import IDeleteApplicationPayload
from bitbadgespy_sdk.models.i_delete_attestation_payload import IDeleteAttestationPayload
from bitbadgespy_sdk.models.i_delete_claim_payload import IDeleteClaimPayload
from bitbadgespy_sdk.models.i_delete_connected_account_success_response import IDeleteConnectedAccountSuccessResponse
from bitbadgespy_sdk.models.i_delete_developer_app_payload import IDeleteDeveloperAppPayload
from bitbadgespy_sdk.models.i_delete_dynamic_data_store_payload import IDeleteDynamicDataStorePayload
from bitbadgespy_sdk.models.i_delete_dynamic_data_store_success_response import IDeleteDynamicDataStoreSuccessResponse
from bitbadgespy_sdk.models.i_delete_plugin_payload import IDeletePluginPayload
from bitbadgespy_sdk.models.i_delete_siwbb_request_payload import IDeleteSIWBBRequestPayload
from bitbadgespy_sdk.models.i_delete_utility_listing_payload import IDeleteUtilityListingPayload
from bitbadgespy_sdk.models.i_denom_unit import IDenomUnit
from bitbadgespy_sdk.models.i_deposit_balance_doc import IDepositBalanceDoc
from bitbadgespy_sdk.models.i_developer_app_doc import IDeveloperAppDoc
from bitbadgespy_sdk.models.i_dynamic_data_doc import IDynamicDataDoc
from bitbadgespy_sdk.models.i_email_verification_status import IEmailVerificationStatus
from bitbadgespy_sdk.models.i_estimated_cost import IEstimatedCost
from bitbadgespy_sdk.models.i_event import IEvent
from bitbadgespy_sdk.models.i_exchange_siwbb_authorization_code_payload import IExchangeSIWBBAuthorizationCodePayload
from bitbadgespy_sdk.models.i_exchange_siwbb_authorization_code_success_response import IExchangeSIWBBAuthorizationCodeSuccessResponse
from bitbadgespy_sdk.models.i_exchange_siwbb_authorization_code_success_response_verification_response import IExchangeSIWBBAuthorizationCodeSuccessResponseVerificationResponse
from bitbadgespy_sdk.models.i_fetch_doc import IFetchDoc
from bitbadgespy_sdk.models.i_fetch_doc_content import IFetchDocContent
from bitbadgespy_sdk.models.i_fetch_metadata_directly_payload import IFetchMetadataDirectlyPayload
from bitbadgespy_sdk.models.i_fetch_metadata_directly_success_response import IFetchMetadataDirectlySuccessResponse
from bitbadgespy_sdk.models.i_filter_badges_in_collection_payload import IFilterBadgesInCollectionPayload
from bitbadgespy_sdk.models.i_filter_badges_in_collection_payload_attributes_inner import IFilterBadgesInCollectionPayloadAttributesInner
from bitbadgespy_sdk.models.i_filter_badges_in_collection_success_response import IFilterBadgesInCollectionSuccessResponse
from bitbadgespy_sdk.models.i_filter_suggestions_success_response import IFilterSuggestionsSuccessResponse
from bitbadgespy_sdk.models.i_filter_suggestions_success_response_attributes_inner import IFilterSuggestionsSuccessResponseAttributesInner
from bitbadgespy_sdk.models.i_floor_price_history import IFloorPriceHistory
from bitbadgespy_sdk.models.i_generate_apple_wallet_pass_payload import IGenerateAppleWalletPassPayload
from bitbadgespy_sdk.models.i_generate_apple_wallet_pass_success_response import IGenerateAppleWalletPassSuccessResponse
from bitbadgespy_sdk.models.i_generate_google_wallet_payload import IGenerateGoogleWalletPayload
from bitbadgespy_sdk.models.i_generate_google_wallet_success_response import IGenerateGoogleWalletSuccessResponse
from bitbadgespy_sdk.models.i_generic_blockin_verify_payload import IGenericBlockinVerifyPayload
from bitbadgespy_sdk.models.i_generic_verify_assets_payload import IGenericVerifyAssetsPayload
from bitbadgespy_sdk.models.i_generic_verify_assets_success_response import IGenericVerifyAssetsSuccessResponse
from bitbadgespy_sdk.models.i_get_account_payload import IGetAccountPayload
from bitbadgespy_sdk.models.i_get_account_success_response import IGetAccountSuccessResponse
from bitbadgespy_sdk.models.i_get_accounts_payload import IGetAccountsPayload
from bitbadgespy_sdk.models.i_get_accounts_success_response import IGetAccountsSuccessResponse
from bitbadgespy_sdk.models.i_get_active_authorizations_success_response import IGetActiveAuthorizationsSuccessResponse
from bitbadgespy_sdk.models.i_get_address_list_activity_payload import IGetAddressListActivityPayload
from bitbadgespy_sdk.models.i_get_address_list_activity_success_response import IGetAddressListActivitySuccessResponse
from bitbadgespy_sdk.models.i_get_address_list_claims_success_response import IGetAddressListClaimsSuccessResponse
from bitbadgespy_sdk.models.i_get_address_list_listings_payload import IGetAddressListListingsPayload
from bitbadgespy_sdk.models.i_get_address_list_listings_success_response import IGetAddressListListingsSuccessResponse
from bitbadgespy_sdk.models.i_get_address_list_success_response import IGetAddressListSuccessResponse
from bitbadgespy_sdk.models.i_get_address_lists_for_user_payload import IGetAddressListsForUserPayload
from bitbadgespy_sdk.models.i_get_address_lists_for_user_success_response import IGetAddressListsForUserSuccessResponse
from bitbadgespy_sdk.models.i_get_address_lists_payload import IGetAddressListsPayload
from bitbadgespy_sdk.models.i_get_address_lists_payload_lists_to_fetch_inner import IGetAddressListsPayloadListsToFetchInner
from bitbadgespy_sdk.models.i_get_address_lists_payload_lists_to_fetch_inner_views_to_fetch_inner import IGetAddressListsPayloadListsToFetchInnerViewsToFetchInner
from bitbadgespy_sdk.models.i_get_address_lists_success_response import IGetAddressListsSuccessResponse
from bitbadgespy_sdk.models.i_get_api_keys_payload import IGetApiKeysPayload
from bitbadgespy_sdk.models.i_get_api_keys_success_response import IGetApiKeysSuccessResponse
from bitbadgespy_sdk.models.i_get_api_keys_success_response_pagination import IGetApiKeysSuccessResponsePagination
from bitbadgespy_sdk.models.i_get_application_success_response import IGetApplicationSuccessResponse
from bitbadgespy_sdk.models.i_get_applications_payload import IGetApplicationsPayload
from bitbadgespy_sdk.models.i_get_applications_success_response import IGetApplicationsSuccessResponse
from bitbadgespy_sdk.models.i_get_attempt_data_from_request_bin_payload import IGetAttemptDataFromRequestBinPayload
from bitbadgespy_sdk.models.i_get_attempt_data_from_request_bin_success_response import IGetAttemptDataFromRequestBinSuccessResponse
from bitbadgespy_sdk.models.i_get_attestation_success_response import IGetAttestationSuccessResponse
from bitbadgespy_sdk.models.i_get_attestations_for_user_payload import IGetAttestationsForUserPayload
from bitbadgespy_sdk.models.i_get_attestations_for_user_success_response import IGetAttestationsForUserSuccessResponse
from bitbadgespy_sdk.models.i_get_attestations_payload import IGetAttestationsPayload
from bitbadgespy_sdk.models.i_get_attestations_success_response import IGetAttestationsSuccessResponse
from bitbadgespy_sdk.models.i_get_badge_activity_payload import IGetBadgeActivityPayload
from bitbadgespy_sdk.models.i_get_badge_activity_success_response import IGetBadgeActivitySuccessResponse
from bitbadgespy_sdk.models.i_get_badge_balance_by_address_payload import IGetBadgeBalanceByAddressPayload
from bitbadgespy_sdk.models.i_get_badge_balance_by_address_specific_badge_success_response import IGetBadgeBalanceByAddressSpecificBadgeSuccessResponse
from bitbadgespy_sdk.models.i_get_badge_balance_by_address_success_response import IGetBadgeBalanceByAddressSuccessResponse
from bitbadgespy_sdk.models.i_get_badge_metadata_success_response import IGetBadgeMetadataSuccessResponse
from bitbadgespy_sdk.models.i_get_badges_view_for_user_payload import IGetBadgesViewForUserPayload
from bitbadgespy_sdk.models.i_get_badges_view_for_user_success_response import IGetBadgesViewForUserSuccessResponse
from bitbadgespy_sdk.models.i_get_browse_payload import IGetBrowsePayload
from bitbadgespy_sdk.models.i_get_browse_success_response import IGetBrowseSuccessResponse
from bitbadgespy_sdk.models.i_get_claim_activity_for_user_payload import IGetClaimActivityForUserPayload
from bitbadgespy_sdk.models.i_get_claim_activity_for_user_success_response import IGetClaimActivityForUserSuccessResponse
from bitbadgespy_sdk.models.i_get_claim_alerts_for_user_payload import IGetClaimAlertsForUserPayload
from bitbadgespy_sdk.models.i_get_claim_alerts_for_user_success_response import IGetClaimAlertsForUserSuccessResponse
from bitbadgespy_sdk.models.i_get_claim_attempt_status_success_response import IGetClaimAttemptStatusSuccessResponse
from bitbadgespy_sdk.models.i_get_claim_attempts_payload import IGetClaimAttemptsPayload
from bitbadgespy_sdk.models.i_get_claim_attempts_success_response import IGetClaimAttemptsSuccessResponse
from bitbadgespy_sdk.models.i_get_claim_attempts_success_response_docs_inner import IGetClaimAttemptsSuccessResponseDocsInner
from bitbadgespy_sdk.models.i_get_claim_payload import IGetClaimPayload
from bitbadgespy_sdk.models.i_get_claim_success_response import IGetClaimSuccessResponse
from bitbadgespy_sdk.models.i_get_claims_payload import IGetClaimsPayload
from bitbadgespy_sdk.models.i_get_claims_payload_private_states_to_fetch_inner import IGetClaimsPayloadPrivateStatesToFetchInner
from bitbadgespy_sdk.models.i_get_claims_payload_v1 import IGetClaimsPayloadV1
from bitbadgespy_sdk.models.i_get_claims_payload_v1_claims_to_fetch_inner import IGetClaimsPayloadV1ClaimsToFetchInner
from bitbadgespy_sdk.models.i_get_claims_success_response import IGetClaimsSuccessResponse
from bitbadgespy_sdk.models.i_get_collection_amount_tracker_by_id_success_response import IGetCollectionAmountTrackerByIdSuccessResponse
from bitbadgespy_sdk.models.i_get_collection_amount_trackers_payload import IGetCollectionAmountTrackersPayload
from bitbadgespy_sdk.models.i_get_collection_amount_trackers_success_response import IGetCollectionAmountTrackersSuccessResponse
from bitbadgespy_sdk.models.i_get_collection_challenge_tracker_by_id_success_response import IGetCollectionChallengeTrackerByIdSuccessResponse
from bitbadgespy_sdk.models.i_get_collection_challenge_trackers_payload import IGetCollectionChallengeTrackersPayload
from bitbadgespy_sdk.models.i_get_collection_challenge_trackers_success_response import IGetCollectionChallengeTrackersSuccessResponse
from bitbadgespy_sdk.models.i_get_collection_claims_success_response import IGetCollectionClaimsSuccessResponse
from bitbadgespy_sdk.models.i_get_collection_listings_payload import IGetCollectionListingsPayload
from bitbadgespy_sdk.models.i_get_collection_listings_success_response import IGetCollectionListingsSuccessResponse
from bitbadgespy_sdk.models.i_get_collection_owners_payload import IGetCollectionOwnersPayload
from bitbadgespy_sdk.models.i_get_collection_owners_success_response import IGetCollectionOwnersSuccessResponse
from bitbadgespy_sdk.models.i_get_collection_success_response import IGetCollectionSuccessResponse
from bitbadgespy_sdk.models.i_get_collection_transfer_activity_payload import IGetCollectionTransferActivityPayload
from bitbadgespy_sdk.models.i_get_collection_transfer_activity_success_response import IGetCollectionTransferActivitySuccessResponse
from bitbadgespy_sdk.models.i_get_collections_payload import IGetCollectionsPayload
from bitbadgespy_sdk.models.i_get_collections_success_response import IGetCollectionsSuccessResponse
from bitbadgespy_sdk.models.i_get_connected_accounts_success_response import IGetConnectedAccountsSuccessResponse
from bitbadgespy_sdk.models.i_get_connected_accounts_success_response_accounts_inner import IGetConnectedAccountsSuccessResponseAccountsInner
from bitbadgespy_sdk.models.i_get_developer_app_success_response import IGetDeveloperAppSuccessResponse
from bitbadgespy_sdk.models.i_get_developer_apps_payload import IGetDeveloperAppsPayload
from bitbadgespy_sdk.models.i_get_developer_apps_success_response import IGetDeveloperAppsSuccessResponse
from bitbadgespy_sdk.models.i_get_dynamic_data_activity_payload import IGetDynamicDataActivityPayload
from bitbadgespy_sdk.models.i_get_dynamic_data_activity_success_response import IGetDynamicDataActivitySuccessResponse
from bitbadgespy_sdk.models.i_get_dynamic_data_activity_success_response_history import IGetDynamicDataActivitySuccessResponseHistory
from bitbadgespy_sdk.models.i_get_dynamic_data_activity_success_response_history_docs_inner import IGetDynamicDataActivitySuccessResponseHistoryDocsInner
from bitbadgespy_sdk.models.i_get_dynamic_data_activity_success_response_history_pagination import IGetDynamicDataActivitySuccessResponseHistoryPagination
from bitbadgespy_sdk.models.i_get_dynamic_data_activity_success_response_pending_inner import IGetDynamicDataActivitySuccessResponsePendingInner
from bitbadgespy_sdk.models.i_get_dynamic_data_store_payload import IGetDynamicDataStorePayload
from bitbadgespy_sdk.models.i_get_dynamic_data_store_success_response import IGetDynamicDataStoreSuccessResponse
from bitbadgespy_sdk.models.i_get_dynamic_data_store_value_payload import IGetDynamicDataStoreValuePayload
from bitbadgespy_sdk.models.i_get_dynamic_data_store_value_success_response import IGetDynamicDataStoreValueSuccessResponse
from bitbadgespy_sdk.models.i_get_dynamic_data_store_values_paginated_payload import IGetDynamicDataStoreValuesPaginatedPayload
from bitbadgespy_sdk.models.i_get_dynamic_data_store_values_paginated_success_response import IGetDynamicDataStoreValuesPaginatedSuccessResponse
from bitbadgespy_sdk.models.i_get_dynamic_data_store_values_paginated_success_response_lookup_values_inner import IGetDynamicDataStoreValuesPaginatedSuccessResponseLookupValuesInner
from bitbadgespy_sdk.models.i_get_dynamic_data_stores_payload import IGetDynamicDataStoresPayload
from bitbadgespy_sdk.models.i_get_dynamic_data_stores_success_response import IGetDynamicDataStoresSuccessResponse
from bitbadgespy_sdk.models.i_get_dynamic_data_stores_success_response_pagination import IGetDynamicDataStoresSuccessResponsePagination
from bitbadgespy_sdk.models.i_get_gated_content_for_claim_success_response import IGetGatedContentForClaimSuccessResponse
from bitbadgespy_sdk.models.i_get_list_activity_for_user_payload import IGetListActivityForUserPayload
from bitbadgespy_sdk.models.i_get_list_activity_for_user_success_response import IGetListActivityForUserSuccessResponse
from bitbadgespy_sdk.models.i_get_map_success_response import IGetMapSuccessResponse
from bitbadgespy_sdk.models.i_get_map_value_success_response import IGetMapValueSuccessResponse
from bitbadgespy_sdk.models.i_get_map_values_payload import IGetMapValuesPayload
from bitbadgespy_sdk.models.i_get_map_values_success_response import IGetMapValuesSuccessResponse
from bitbadgespy_sdk.models.i_get_map_values_success_response_values_inner import IGetMapValuesSuccessResponseValuesInner
from bitbadgespy_sdk.models.i_get_maps_payload import IGetMapsPayload
from bitbadgespy_sdk.models.i_get_maps_success_response import IGetMapsSuccessResponse
from bitbadgespy_sdk.models.i_get_or_create_embedded_wallet_success_response import IGetOrCreateEmbeddedWalletSuccessResponse
from bitbadgespy_sdk.models.i_get_owners_for_badge_payload import IGetOwnersForBadgePayload
from bitbadgespy_sdk.models.i_get_owners_for_badge_success_response import IGetOwnersForBadgeSuccessResponse
from bitbadgespy_sdk.models.i_get_plugin_errors_payload import IGetPluginErrorsPayload
from bitbadgespy_sdk.models.i_get_plugin_errors_success_response import IGetPluginErrorsSuccessResponse
from bitbadgespy_sdk.models.i_get_plugin_success_response import IGetPluginSuccessResponse
from bitbadgespy_sdk.models.i_get_plugins_payload import IGetPluginsPayload
from bitbadgespy_sdk.models.i_get_plugins_success_response import IGetPluginsSuccessResponse
from bitbadgespy_sdk.models.i_get_points_activity_for_user_payload import IGetPointsActivityForUserPayload
from bitbadgespy_sdk.models.i_get_points_activity_for_user_success_response import IGetPointsActivityForUserSuccessResponse
from bitbadgespy_sdk.models.i_get_points_activity_payload import IGetPointsActivityPayload
from bitbadgespy_sdk.models.i_get_points_activity_success_response import IGetPointsActivitySuccessResponse
from bitbadgespy_sdk.models.i_get_post_action_statuses_success_response import IGetPostActionStatusesSuccessResponse
from bitbadgespy_sdk.models.i_get_post_action_statuses_success_response_post_action_statuses_inner import IGetPostActionStatusesSuccessResponsePostActionStatusesInner
from bitbadgespy_sdk.models.i_get_reserved_claim_codes_success_response import IGetReservedClaimCodesSuccessResponse
from bitbadgespy_sdk.models.i_get_siwbb_requests_for_developer_app_payload import IGetSIWBBRequestsForDeveloperAppPayload
from bitbadgespy_sdk.models.i_get_siwbb_requests_for_developer_app_success_response import IGetSIWBBRequestsForDeveloperAppSuccessResponse
from bitbadgespy_sdk.models.i_get_search_payload import IGetSearchPayload
from bitbadgespy_sdk.models.i_get_search_success_response import IGetSearchSuccessResponse
from bitbadgespy_sdk.models.i_get_search_success_response_badges_inner import IGetSearchSuccessResponseBadgesInner
from bitbadgespy_sdk.models.i_get_sign_in_challenge_payload import IGetSignInChallengePayload
from bitbadgespy_sdk.models.i_get_sign_in_challenge_success_response import IGetSignInChallengeSuccessResponse
from bitbadgespy_sdk.models.i_get_siwbb_requests_for_user_payload import IGetSiwbbRequestsForUserPayload
from bitbadgespy_sdk.models.i_get_siwbb_requests_for_user_success_response import IGetSiwbbRequestsForUserSuccessResponse
from bitbadgespy_sdk.models.i_get_status_payload import IGetStatusPayload
from bitbadgespy_sdk.models.i_get_status_success_response import IGetStatusSuccessResponse
from bitbadgespy_sdk.models.i_get_transfer_activity_for_user_payload import IGetTransferActivityForUserPayload
from bitbadgespy_sdk.models.i_get_transfer_activity_for_user_success_response import IGetTransferActivityForUserSuccessResponse
from bitbadgespy_sdk.models.i_get_utility_listing_success_response import IGetUtilityListingSuccessResponse
from bitbadgespy_sdk.models.i_get_utility_listings_payload import IGetUtilityListingsPayload
from bitbadgespy_sdk.models.i_get_utility_listings_success_response import IGetUtilityListingsSuccessResponse
from bitbadgespy_sdk.models.iipfs_totals_doc import IIPFSTotalsDoc
from bitbadgespy_sdk.models.i_incoming_approval_criteria import IIncomingApprovalCriteria
from bitbadgespy_sdk.models.i_incremented_balances import IIncrementedBalances
from bitbadgespy_sdk.models.i_indexer_status import IIndexerStatus
from bitbadgespy_sdk.models.i_inherit_metadata_from import IInheritMetadataFrom
from bitbadgespy_sdk.models.iis_archived_timeline import IIsArchivedTimeline
from bitbadgespy_sdk.models.i_latest_block_status import ILatestBlockStatus
from bitbadgespy_sdk.models.i_linked_to import ILinkedTo
from bitbadgespy_sdk.models.i_list_activity_doc import IListActivityDoc
from bitbadgespy_sdk.models.i_listing_views_doc import IListingViewsDoc
from bitbadgespy_sdk.models.i_listing_views_doc_views_by_period import IListingViewsDocViewsByPeriod
from bitbadgespy_sdk.models.i_manager_timeline import IManagerTimeline
from bitbadgespy_sdk.models.i_manual_balances import IManualBalances
from bitbadgespy_sdk.models.i_map import IMap
from bitbadgespy_sdk.models.i_map_doc import IMapDoc
from bitbadgespy_sdk.models.i_map_metadata_timeline import IMapMetadataTimeline
from bitbadgespy_sdk.models.i_map_permissions import IMapPermissions
from bitbadgespy_sdk.models.i_map_update_criteria import IMapUpdateCriteria
from bitbadgespy_sdk.models.i_map_with_values import IMapWithValues
from bitbadgespy_sdk.models.i_max_num_transfers import IMaxNumTransfers
from bitbadgespy_sdk.models.i_merkle_challenge import IMerkleChallenge
from bitbadgespy_sdk.models.i_merkle_challenge_tracker_doc import IMerkleChallengeTrackerDoc
from bitbadgespy_sdk.models.i_merkle_path_item import IMerklePathItem
from bitbadgespy_sdk.models.i_merkle_proof import IMerkleProof
from bitbadgespy_sdk.models.i_metadata import IMetadata
from bitbadgespy_sdk.models.i_metadata_additional_info_inner import IMetadataAdditionalInfoInner
from bitbadgespy_sdk.models.i_metadata_attributes_inner import IMetadataAttributesInner
from bitbadgespy_sdk.models.i_metadata_off_chain_transferability_info import IMetadataOffChainTransferabilityInfo
from bitbadgespy_sdk.models.i_metadata_without_internals import IMetadataWithoutInternals
from bitbadgespy_sdk.models.i_metadata_without_internals_additional_info_inner import IMetadataWithoutInternalsAdditionalInfoInner
from bitbadgespy_sdk.models.i_metadata_without_internals_attributes_inner import IMetadataWithoutInternalsAttributesInner
from bitbadgespy_sdk.models.i_metadata_without_internals_off_chain_transferability_info import IMetadataWithoutInternalsOffChainTransferabilityInfo
from bitbadgespy_sdk.models.i_msg_create_address_lists import IMsgCreateAddressLists
from bitbadgespy_sdk.models.i_msg_create_collection import IMsgCreateCollection
from bitbadgespy_sdk.models.i_msg_create_map import IMsgCreateMap
from bitbadgespy_sdk.models.i_msg_delete_collection import IMsgDeleteCollection
from bitbadgespy_sdk.models.i_msg_delete_map import IMsgDeleteMap
from bitbadgespy_sdk.models.i_msg_execute_contract_compat import IMsgExecuteContractCompat
from bitbadgespy_sdk.models.i_msg_instantiate_contract_compat import IMsgInstantiateContractCompat
from bitbadgespy_sdk.models.i_msg_set_value import IMsgSetValue
from bitbadgespy_sdk.models.i_msg_store_code_compat import IMsgStoreCodeCompat
from bitbadgespy_sdk.models.i_msg_transfer_badges import IMsgTransferBadges
from bitbadgespy_sdk.models.i_msg_universal_update_collection import IMsgUniversalUpdateCollection
from bitbadgespy_sdk.models.i_msg_update_map import IMsgUpdateMap
from bitbadgespy_sdk.models.i_msg_update_user_approvals import IMsgUpdateUserApprovals
from bitbadgespy_sdk.models.i_must_own_badge import IMustOwnBadge
from bitbadgespy_sdk.models.i_must_own_badges import IMustOwnBadges
from bitbadgespy_sdk.models.i_notification_preferences import INotificationPreferences
from bitbadgespy_sdk.models.i_notification_preferences_discord import INotificationPreferencesDiscord
from bitbadgespy_sdk.models.i_notification_preferences_preferences import INotificationPreferencesPreferences
from bitbadgespy_sdk.models.i_oauth_revoke_payload import IOauthRevokePayload
from bitbadgespy_sdk.models.i_off_chain_balances_metadata import IOffChainBalancesMetadata
from bitbadgespy_sdk.models.i_off_chain_balances_metadata_timeline import IOffChainBalancesMetadataTimeline
from bitbadgespy_sdk.models.i_outgoing_approval_criteria import IOutgoingApprovalCriteria
from bitbadgespy_sdk.models.i_perform_store_action_batch_with_body_auth_payload import IPerformStoreActionBatchWithBodyAuthPayload
from bitbadgespy_sdk.models.i_perform_store_action_batch_with_body_auth_payload_actions_inner import IPerformStoreActionBatchWithBodyAuthPayloadActionsInner
from bitbadgespy_sdk.models.i_perform_store_action_single_with_body_auth_payload import IPerformStoreActionSingleWithBodyAuthPayload
from bitbadgespy_sdk.models.i_plugin_doc import IPluginDoc
from bitbadgespy_sdk.models.i_plugin_doc_metadata import IPluginDocMetadata
from bitbadgespy_sdk.models.i_plugin_version_config import IPluginVersionConfig
from bitbadgespy_sdk.models.i_plugin_version_config_claim_creator_redirect import IPluginVersionConfigClaimCreatorRedirect
from bitbadgespy_sdk.models.i_plugin_version_config_user_input_redirect import IPluginVersionConfigUserInputRedirect
from bitbadgespy_sdk.models.i_plugin_version_config_verification_call import IPluginVersionConfigVerificationCall
from bitbadgespy_sdk.models.i_points_activity_doc import IPointsActivityDoc
from bitbadgespy_sdk.models.i_points_doc import IPointsDoc
from bitbadgespy_sdk.models.i_points_value import IPointsValue
from bitbadgespy_sdk.models.i_precalculation_options import IPrecalculationOptions
from bitbadgespy_sdk.models.i_predetermined_balances import IPredeterminedBalances
from bitbadgespy_sdk.models.i_predetermined_order_calculation_method import IPredeterminedOrderCalculationMethod
from bitbadgespy_sdk.models.i_profile_doc import IProfileDoc
from bitbadgespy_sdk.models.i_profile_doc_approved_sign_in_methods import IProfileDocApprovedSignInMethods
from bitbadgespy_sdk.models.i_profile_doc_approved_sign_in_methods_addresses_inner import IProfileDocApprovedSignInMethodsAddressesInner
from bitbadgespy_sdk.models.i_profile_doc_approved_sign_in_methods_discord import IProfileDocApprovedSignInMethodsDiscord
from bitbadgespy_sdk.models.i_profile_doc_approved_sign_in_methods_github import IProfileDocApprovedSignInMethodsGithub
from bitbadgespy_sdk.models.i_profile_doc_approved_sign_in_methods_passwords_inner import IProfileDocApprovedSignInMethodsPasswordsInner
from bitbadgespy_sdk.models.i_profile_doc_custom_pages import IProfileDocCustomPages
from bitbadgespy_sdk.models.i_profile_doc_watchlists import IProfileDocWatchlists
from bitbadgespy_sdk.models.i_queue_doc import IQueueDoc
from bitbadgespy_sdk.models.i_queue_doc_claim_info import IQueueDocClaimInfo
from bitbadgespy_sdk.models.i_queue_doc_faucet_info import IQueueDocFaucetInfo
from bitbadgespy_sdk.models.i_recurring_ownership_times import IRecurringOwnershipTimes
from bitbadgespy_sdk.models.i_refresh_doc import IRefreshDoc
from bitbadgespy_sdk.models.i_refresh_status_success_response import IRefreshStatusSuccessResponse
from bitbadgespy_sdk.models.i_reset_time_intervals import IResetTimeIntervals
from bitbadgespy_sdk.models.i_review_doc import IReviewDoc
from bitbadgespy_sdk.models.i_rotate_api_key_payload import IRotateApiKeyPayload
from bitbadgespy_sdk.models.i_rotate_api_key_success_response import IRotateApiKeySuccessResponse
from bitbadgespy_sdk.models.i_rotate_siwbb_request_payload import IRotateSIWBBRequestPayload
from bitbadgespy_sdk.models.i_rotate_siwbb_request_success_response import IRotateSIWBBRequestSuccessResponse
from bitbadgespy_sdk.models.isiwbb_request_doc import ISIWBBRequestDoc
from bitbadgespy_sdk.models.i_satisfy_method import ISatisfyMethod
from bitbadgespy_sdk.models.i_satisfy_method_conditions_inner import ISatisfyMethodConditionsInner
from bitbadgespy_sdk.models.i_satisfy_method_options import ISatisfyMethodOptions
from bitbadgespy_sdk.models.i_schedule_token_refresh_payload import IScheduleTokenRefreshPayload
from bitbadgespy_sdk.models.i_schedule_token_refresh_success_response import IScheduleTokenRefreshSuccessResponse
from bitbadgespy_sdk.models.i_search_applications_payload import ISearchApplicationsPayload
from bitbadgespy_sdk.models.i_search_applications_success_response import ISearchApplicationsSuccessResponse
from bitbadgespy_sdk.models.i_search_claims_payload import ISearchClaimsPayload
from bitbadgespy_sdk.models.i_search_claims_success_response import ISearchClaimsSuccessResponse
from bitbadgespy_sdk.models.i_search_developer_apps_payload import ISearchDeveloperAppsPayload
from bitbadgespy_sdk.models.i_search_developer_apps_success_response import ISearchDeveloperAppsSuccessResponse
from bitbadgespy_sdk.models.i_search_dynamic_data_stores_payload import ISearchDynamicDataStoresPayload
from bitbadgespy_sdk.models.i_search_dynamic_data_stores_success_response import ISearchDynamicDataStoresSuccessResponse
from bitbadgespy_sdk.models.i_search_dynamic_data_stores_success_response_pagination import ISearchDynamicDataStoresSuccessResponsePagination
from bitbadgespy_sdk.models.i_search_plugins_payload import ISearchPluginsPayload
from bitbadgespy_sdk.models.i_search_plugins_success_response import ISearchPluginsSuccessResponse
from bitbadgespy_sdk.models.i_search_utility_listings_payload import ISearchUtilityListingsPayload
from bitbadgespy_sdk.models.i_search_utility_listings_success_response import ISearchUtilityListingsSuccessResponse
from bitbadgespy_sdk.models.i_send_claim_alerts_payload import ISendClaimAlertsPayload
from bitbadgespy_sdk.models.i_send_claim_alerts_payload_claim_alerts_inner import ISendClaimAlertsPayloadClaimAlertsInner
from bitbadgespy_sdk.models.i_set_options import ISetOptions
from bitbadgespy_sdk.models.i_sign_out_payload import ISignOutPayload
from bitbadgespy_sdk.models.i_sign_with_embedded_wallet_payload import ISignWithEmbeddedWalletPayload
from bitbadgespy_sdk.models.i_sign_with_embedded_wallet_success_response import ISignWithEmbeddedWalletSuccessResponse
from bitbadgespy_sdk.models.i_simulate_claim_payload import ISimulateClaimPayload
from bitbadgespy_sdk.models.i_simulate_claim_success_response import ISimulateClaimSuccessResponse
from bitbadgespy_sdk.models.i_simulate_tx_success_response import ISimulateTxSuccessResponse
from bitbadgespy_sdk.models.i_simulate_tx_success_response_gas_info import ISimulateTxSuccessResponseGasInfo
from bitbadgespy_sdk.models.i_simulate_tx_success_response_result import ISimulateTxSuccessResponseResult
from bitbadgespy_sdk.models.i_siwbb_challenge import ISiwbbChallenge
from bitbadgespy_sdk.models.i_siwbb_challenge_verification_response import ISiwbbChallengeVerificationResponse
from bitbadgespy_sdk.models.i_social_connections import ISocialConnections
from bitbadgespy_sdk.models.i_social_connections_discord import ISocialConnectionsDiscord
from bitbadgespy_sdk.models.i_social_connections_twitter import ISocialConnectionsTwitter
from bitbadgespy_sdk.models.i_standards_timeline import IStandardsTimeline
from bitbadgespy_sdk.models.i_status_doc import IStatusDoc
from bitbadgespy_sdk.models.i_tier_with_optional_weight import ITierWithOptionalWeight
from bitbadgespy_sdk.models.i_timed_update_permission import ITimedUpdatePermission
from bitbadgespy_sdk.models.i_timed_update_with_badge_ids_permission import ITimedUpdateWithBadgeIdsPermission
from bitbadgespy_sdk.models.i_timeline_item import ITimelineItem
from bitbadgespy_sdk.models.i_transfer import ITransfer
from bitbadgespy_sdk.models.i_transfer_activity_doc import ITransferActivityDoc
from bitbadgespy_sdk.models.i_transfer_with_increments import ITransferWithIncrements
from bitbadgespy_sdk.models.i_uint_range import IUintRange
from bitbadgespy_sdk.models.i_update_account_info_payload import IUpdateAccountInfoPayload
from bitbadgespy_sdk.models.i_update_account_info_payload_approved_sign_in_methods import IUpdateAccountInfoPayloadApprovedSignInMethods
from bitbadgespy_sdk.models.i_update_account_info_payload_approved_sign_in_methods_passwords_inner import IUpdateAccountInfoPayloadApprovedSignInMethodsPasswordsInner
from bitbadgespy_sdk.models.i_update_account_info_payload_custom_pages import IUpdateAccountInfoPayloadCustomPages
from bitbadgespy_sdk.models.i_update_account_info_payload_notifications import IUpdateAccountInfoPayloadNotifications
from bitbadgespy_sdk.models.i_update_account_info_payload_notifications_discord import IUpdateAccountInfoPayloadNotificationsDiscord
from bitbadgespy_sdk.models.i_update_account_info_payload_notifications_preferences import IUpdateAccountInfoPayloadNotificationsPreferences
from bitbadgespy_sdk.models.i_update_account_info_payload_public_social_connections_to_set_inner import IUpdateAccountInfoPayloadPublicSocialConnectionsToSetInner
from bitbadgespy_sdk.models.i_update_account_info_payload_watchlists import IUpdateAccountInfoPayloadWatchlists
from bitbadgespy_sdk.models.i_update_account_info_success_response import IUpdateAccountInfoSuccessResponse
from bitbadgespy_sdk.models.i_update_address_list_addresses_payload import IUpdateAddressListAddressesPayload
from bitbadgespy_sdk.models.i_update_address_list_core_details_payload import IUpdateAddressListCoreDetailsPayload
from bitbadgespy_sdk.models.i_update_address_lists_payload import IUpdateAddressListsPayload
from bitbadgespy_sdk.models.i_update_application_payload import IUpdateApplicationPayload
from bitbadgespy_sdk.models.i_update_application_success_response import IUpdateApplicationSuccessResponse
from bitbadgespy_sdk.models.i_update_attestation_payload import IUpdateAttestationPayload
from bitbadgespy_sdk.models.i_update_attestation_payload_data_integrity_proof import IUpdateAttestationPayloadDataIntegrityProof
from bitbadgespy_sdk.models.i_update_attestation_payload_holders_to_set_inner import IUpdateAttestationPayloadHoldersToSetInner
from bitbadgespy_sdk.models.i_update_attestation_success_response import IUpdateAttestationSuccessResponse
from bitbadgespy_sdk.models.i_update_claim_payload import IUpdateClaimPayload
from bitbadgespy_sdk.models.i_update_developer_app_payload import IUpdateDeveloperAppPayload
from bitbadgespy_sdk.models.i_update_developer_app_success_response import IUpdateDeveloperAppSuccessResponse
from bitbadgespy_sdk.models.i_update_dynamic_data_store_payload import IUpdateDynamicDataStorePayload
from bitbadgespy_sdk.models.i_update_dynamic_data_store_success_response import IUpdateDynamicDataStoreSuccessResponse
from bitbadgespy_sdk.models.i_update_history import IUpdateHistory
from bitbadgespy_sdk.models.i_update_plugin_payload import IUpdatePluginPayload
from bitbadgespy_sdk.models.i_update_plugin_payload_metadata import IUpdatePluginPayloadMetadata
from bitbadgespy_sdk.models.i_update_plugin_payload_version_updates_inner import IUpdatePluginPayloadVersionUpdatesInner
from bitbadgespy_sdk.models.i_update_plugin_payload_version_updates_inner_config import IUpdatePluginPayloadVersionUpdatesInnerConfig
from bitbadgespy_sdk.models.i_update_plugin_payload_version_updates_inner_config_claim_creator_redirect import IUpdatePluginPayloadVersionUpdatesInnerConfigClaimCreatorRedirect
from bitbadgespy_sdk.models.i_update_plugin_payload_version_updates_inner_config_user_input_redirect import IUpdatePluginPayloadVersionUpdatesInnerConfigUserInputRedirect
from bitbadgespy_sdk.models.i_update_plugin_payload_version_updates_inner_config_verification_call import IUpdatePluginPayloadVersionUpdatesInnerConfigVerificationCall
from bitbadgespy_sdk.models.i_update_utility_listing_payload import IUpdateUtilityListingPayload
from bitbadgespy_sdk.models.i_update_utility_listing_success_response import IUpdateUtilityListingSuccessResponse
from bitbadgespy_sdk.models.i_upload_balances_payload import IUploadBalancesPayload
from bitbadgespy_sdk.models.i_used_leaf_status import IUsedLeafStatus
from bitbadgespy_sdk.models.i_user_balance_store import IUserBalanceStore
from bitbadgespy_sdk.models.i_user_incoming_approval import IUserIncomingApproval
from bitbadgespy_sdk.models.i_user_incoming_approval_permission import IUserIncomingApprovalPermission
from bitbadgespy_sdk.models.i_user_outgoing_approval import IUserOutgoingApproval
from bitbadgespy_sdk.models.i_user_outgoing_approval_permission import IUserOutgoingApprovalPermission
from bitbadgespy_sdk.models.i_user_permissions import IUserPermissions
from bitbadgespy_sdk.models.i_user_royalties import IUserRoyalties
from bitbadgespy_sdk.models.i_utility_listing_content import IUtilityListingContent
from bitbadgespy_sdk.models.i_utility_listing_doc import IUtilityListingDoc
from bitbadgespy_sdk.models.i_utility_listing_doc_approval_status import IUtilityListingDocApprovalStatus
from bitbadgespy_sdk.models.i_utility_listing_doc_home_page_view import IUtilityListingDocHomePageView
from bitbadgespy_sdk.models.i_utility_listing_doc_views_by_period import IUtilityListingDocViewsByPeriod
from bitbadgespy_sdk.models.i_utility_listing_link import IUtilityListingLink
from bitbadgespy_sdk.models.i_value_options import IValueOptions
from bitbadgespy_sdk.models.i_value_store import IValueStore
from bitbadgespy_sdk.models.i_verify_attestation_payload import IVerifyAttestationPayload
from bitbadgespy_sdk.models.i_verify_attestation_payload_data_integrity_proof import IVerifyAttestationPayloadDataIntegrityProof
from bitbadgespy_sdk.models.i_verify_attestation_payload_proof_of_issuance import IVerifyAttestationPayloadProofOfIssuance
from bitbadgespy_sdk.models.i_verify_attestation_success_response import IVerifyAttestationSuccessResponse
from bitbadgespy_sdk.models.i_verify_sign_in_payload import IVerifySignInPayload
from bitbadgespy_sdk.models.integration_plugin_details import IntegrationPluginDetails
from bitbadgespy_sdk.models.integration_plugin_details_metadata import IntegrationPluginDetailsMetadata
from bitbadgespy_sdk.models.integration_plugin_details_update import IntegrationPluginDetailsUpdate
from bitbadgespy_sdk.models.integration_plugin_params import IntegrationPluginParams
from bitbadgespy_sdk.models.integration_plugin_params_metadata import IntegrationPluginParamsMetadata
from bitbadgespy_sdk.models.json_body_input_schema import JsonBodyInputSchema
from bitbadgespy_sdk.models.json_body_input_schema_default_value import JsonBodyInputSchemaDefaultValue
from bitbadgespy_sdk.models.json_body_input_schema_hyperlink import JsonBodyInputSchemaHyperlink
from bitbadgespy_sdk.models.json_body_input_schema_options_inner import JsonBodyInputSchemaOptionsInner
from bitbadgespy_sdk.models.json_body_input_with_value import JsonBodyInputWithValue
from bitbadgespy_sdk.models.json_body_input_with_value_value import JsonBodyInputWithValueValue
from bitbadgespy_sdk.models.metadata_fetch_options import MetadataFetchOptions
from bitbadgespy_sdk.models.metadata_fetch_options_badge_ids import MetadataFetchOptionsBadgeIds
from bitbadgespy_sdk.models.number_type import NumberType
from bitbadgespy_sdk.models.o_auth_scope_details import OAuthScopeDetails
from bitbadgespy_sdk.models.o_auth_scope_details_with_id import OAuthScopeDetailsWithId
from bitbadgespy_sdk.models.oauth_app_name import OauthAppName
from bitbadgespy_sdk.models.or_group import OrGroup
from bitbadgespy_sdk.models.ownership_requirements import OwnershipRequirements
from bitbadgespy_sdk.models.ownership_requirements_options import OwnershipRequirementsOptions
from bitbadgespy_sdk.models.pagination_info import PaginationInfo
from bitbadgespy_sdk.models.parsed_qs_value import ParsedQsValue
from bitbadgespy_sdk.models.permission_name_string import PermissionNameString
from bitbadgespy_sdk.models.plugin_error_doc import PluginErrorDoc
from bitbadgespy_sdk.models.plugin_version_config_payload import PluginVersionConfigPayload
from bitbadgespy_sdk.models.plugin_version_config_payload_verification_call import PluginVersionConfigPayloadVerificationCall
from bitbadgespy_sdk.models.sender import Sender
from bitbadgespy_sdk.models.simulate_tx_request import SimulateTxRequest
from bitbadgespy_sdk.models.std_fee import StdFee
from bitbadgespy_sdk.models.std_sign_doc import StdSignDoc
from bitbadgespy_sdk.models.supported_chain import SupportedChain
from bitbadgespy_sdk.models.supported_chain_type import SupportedChainType
from bitbadgespy_sdk.models.tally_response import TallyResponse
from bitbadgespy_sdk.models.tally_response_tally import TallyResponseTally
from bitbadgespy_sdk.models.tx_context import TxContext
from bitbadgespy_sdk.models.tx_context_sender import TxContextSender
from bitbadgespy_sdk.models.undelegation_response import UndelegationResponse
from bitbadgespy_sdk.models.update_claim_request import UpdateClaimRequest
from bitbadgespy_sdk.models.validator import Validator
from bitbadgespy_sdk.models.validator_commission import ValidatorCommission
from bitbadgespy_sdk.models.validator_commission_commission_rates import ValidatorCommissionCommissionRates
from bitbadgespy_sdk.models.validator_consensus_pubkey import ValidatorConsensusPubkey
from bitbadgespy_sdk.models.validator_description import ValidatorDescription
from bitbadgespy_sdk.models.verify_attestation_signatures_parameters import VerifyAttestationSignaturesParameters
from bitbadgespy_sdk.models.verify_attestation_signatures_parameters_data_integrity_proof import VerifyAttestationSignaturesParametersDataIntegrityProof
from bitbadgespy_sdk.models.verify_attestation_signatures_parameters_proof_of_issuance import VerifyAttestationSignaturesParametersProofOfIssuance
from bitbadgespy_sdk.models.verify_challenge_options import VerifyChallengeOptions
from bitbadgespy_sdk.models.verify_challenge_options_expected_challenge_params import VerifyChallengeOptionsExpectedChallengeParams
from bitbadgespy_sdk.models.verify_siwbb_options import VerifySIWBBOptions
