# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AccessPolicyCondition',
    'AccessPolicyRealm',
    'AccessPolicyRealmLabelPolicy',
    'ProviderAwsCloudwatchScrapeJobCustomNamespace',
    'ProviderAwsCloudwatchScrapeJobCustomNamespaceMetric',
    'ProviderAwsCloudwatchScrapeJobService',
    'ProviderAwsCloudwatchScrapeJobServiceMetric',
    'ProviderAwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilter',
    'ProviderAzureCredentialAutoDiscoveryConfiguration',
    'ProviderAzureCredentialAutoDiscoveryConfigurationResourceTypeConfiguration',
    'ProviderAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationMetricConfiguration',
    'ProviderAzureCredentialResourceDiscoveryTagFilter',
    'GetAccessPoliciesAccessPolicyResult',
    'GetPrivateDataSourceConnectNetworksPrivateDataSourceConnectNetworkResult',
    'GetProviderAwsCloudwatchScrapeJobCustomNamespaceResult',
    'GetProviderAwsCloudwatchScrapeJobCustomNamespaceMetricResult',
    'GetProviderAwsCloudwatchScrapeJobServiceResult',
    'GetProviderAwsCloudwatchScrapeJobServiceMetricResult',
    'GetProviderAwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilterResult',
    'GetProviderAwsCloudwatchScrapeJobsScrapeJobResult',
    'GetProviderAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceResult',
    'GetProviderAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceMetricResult',
    'GetProviderAwsCloudwatchScrapeJobsScrapeJobServiceResult',
    'GetProviderAwsCloudwatchScrapeJobsScrapeJobServiceMetricResult',
    'GetProviderAwsCloudwatchScrapeJobsScrapeJobServiceResourceDiscoveryTagFilterResult',
    'GetProviderAzureCredentialAutoDiscoveryConfigurationResult',
    'GetProviderAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationResult',
    'GetProviderAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationMetricConfigurationResult',
    'GetProviderAzureCredentialResourceDiscoveryTagFilterResult',
]

@pulumi.output_type
class AccessPolicyCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedSubnets":
            suggest = "allowed_subnets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessPolicyCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessPolicyCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessPolicyCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_subnets: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] allowed_subnets: Conditions that apply to the access policy,such as IP Allow lists.
        """
        pulumi.set(__self__, "allowed_subnets", allowed_subnets)

    @property
    @pulumi.getter(name="allowedSubnets")
    def allowed_subnets(self) -> Sequence[builtins.str]:
        """
        Conditions that apply to the access policy,such as IP Allow lists.
        """
        return pulumi.get(self, "allowed_subnets")


@pulumi.output_type
class AccessPolicyRealm(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "labelPolicies":
            suggest = "label_policies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessPolicyRealm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessPolicyRealm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessPolicyRealm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identifier: builtins.str,
                 type: builtins.str,
                 label_policies: Optional[Sequence['outputs.AccessPolicyRealmLabelPolicy']] = None):
        """
        :param builtins.str identifier: The identifier of the org or stack. For orgs, this is the slug, for stacks, this is the stack ID.
        :param builtins.str type: Whether a policy applies to a Cloud org or a specific stack. Should be one of `org` or `stack`.
        """
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "type", type)
        if label_policies is not None:
            pulumi.set(__self__, "label_policies", label_policies)

    @property
    @pulumi.getter
    def identifier(self) -> builtins.str:
        """
        The identifier of the org or stack. For orgs, this is the slug, for stacks, this is the stack ID.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Whether a policy applies to a Cloud org or a specific stack. Should be one of `org` or `stack`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="labelPolicies")
    def label_policies(self) -> Optional[Sequence['outputs.AccessPolicyRealmLabelPolicy']]:
        return pulumi.get(self, "label_policies")


@pulumi.output_type
class AccessPolicyRealmLabelPolicy(dict):
    def __init__(__self__, *,
                 selector: builtins.str):
        """
        :param builtins.str selector: The label selector to match in metrics or logs query. Should be in PromQL or LogQL format.
        """
        pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter
    def selector(self) -> builtins.str:
        """
        The label selector to match in metrics or logs query. Should be in PromQL or LogQL format.
        """
        return pulumi.get(self, "selector")


@pulumi.output_type
class ProviderAwsCloudwatchScrapeJobCustomNamespace(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scrapeIntervalSeconds":
            suggest = "scrape_interval_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProviderAwsCloudwatchScrapeJobCustomNamespace. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProviderAwsCloudwatchScrapeJobCustomNamespace.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProviderAwsCloudwatchScrapeJobCustomNamespace.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 metrics: Optional[Sequence['outputs.ProviderAwsCloudwatchScrapeJobCustomNamespaceMetric']] = None,
                 scrape_interval_seconds: Optional[builtins.int] = None):
        """
        :param builtins.str name: The name of the custom namespace to scrape.
        :param Sequence['ProviderAwsCloudwatchScrapeJobCustomNamespaceMetricArgs'] metrics: One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        :param builtins.int scrape_interval_seconds: The interval in seconds to scrape the custom namespace. Defaults to `300`.
        """
        pulumi.set(__self__, "name", name)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if scrape_interval_seconds is not None:
            pulumi.set(__self__, "scrape_interval_seconds", scrape_interval_seconds)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the custom namespace to scrape.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.ProviderAwsCloudwatchScrapeJobCustomNamespaceMetric']]:
        """
        One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="scrapeIntervalSeconds")
    def scrape_interval_seconds(self) -> Optional[builtins.int]:
        """
        The interval in seconds to scrape the custom namespace. Defaults to `300`.
        """
        return pulumi.get(self, "scrape_interval_seconds")


@pulumi.output_type
class ProviderAwsCloudwatchScrapeJobCustomNamespaceMetric(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 statistics: Sequence[builtins.str]):
        """
        :param builtins.str name: The name of the metric to scrape.
        :param Sequence[builtins.str] statistics: A set of statistics to scrape.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "statistics", statistics)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the metric to scrape.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def statistics(self) -> Sequence[builtins.str]:
        """
        A set of statistics to scrape.
        """
        return pulumi.get(self, "statistics")


@pulumi.output_type
class ProviderAwsCloudwatchScrapeJobService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceDiscoveryTagFilters":
            suggest = "resource_discovery_tag_filters"
        elif key == "scrapeIntervalSeconds":
            suggest = "scrape_interval_seconds"
        elif key == "tagsToAddToMetrics":
            suggest = "tags_to_add_to_metrics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProviderAwsCloudwatchScrapeJobService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProviderAwsCloudwatchScrapeJobService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProviderAwsCloudwatchScrapeJobService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 metrics: Optional[Sequence['outputs.ProviderAwsCloudwatchScrapeJobServiceMetric']] = None,
                 resource_discovery_tag_filters: Optional[Sequence['outputs.ProviderAwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilter']] = None,
                 scrape_interval_seconds: Optional[builtins.int] = None,
                 tags_to_add_to_metrics: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str name: The name of the service to scrape. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported services.
        :param Sequence['ProviderAwsCloudwatchScrapeJobServiceMetricArgs'] metrics: One or more configuration blocks to configure metrics and their statistics to scrape. Please note that AWS metric names must be supplied, and not their PromQL counterparts. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        :param Sequence['ProviderAwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilterArgs'] resource_discovery_tag_filters: One or more configuration blocks to configure tag filters applied to discovery of resource entities in the associated AWS account. When accessing this as an attribute reference, it is a list of objects.
        :param builtins.int scrape_interval_seconds: The interval in seconds to scrape the service. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported scrape intervals. Defaults to `300`.
        :param Sequence[builtins.str] tags_to_add_to_metrics: A set of tags to add to all metrics exported by this scrape job, for use in PromQL queries.
        """
        pulumi.set(__self__, "name", name)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if resource_discovery_tag_filters is not None:
            pulumi.set(__self__, "resource_discovery_tag_filters", resource_discovery_tag_filters)
        if scrape_interval_seconds is not None:
            pulumi.set(__self__, "scrape_interval_seconds", scrape_interval_seconds)
        if tags_to_add_to_metrics is not None:
            pulumi.set(__self__, "tags_to_add_to_metrics", tags_to_add_to_metrics)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the service to scrape. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported services.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.ProviderAwsCloudwatchScrapeJobServiceMetric']]:
        """
        One or more configuration blocks to configure metrics and their statistics to scrape. Please note that AWS metric names must be supplied, and not their PromQL counterparts. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="resourceDiscoveryTagFilters")
    def resource_discovery_tag_filters(self) -> Optional[Sequence['outputs.ProviderAwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilter']]:
        """
        One or more configuration blocks to configure tag filters applied to discovery of resource entities in the associated AWS account. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "resource_discovery_tag_filters")

    @property
    @pulumi.getter(name="scrapeIntervalSeconds")
    def scrape_interval_seconds(self) -> Optional[builtins.int]:
        """
        The interval in seconds to scrape the service. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported scrape intervals. Defaults to `300`.
        """
        return pulumi.get(self, "scrape_interval_seconds")

    @property
    @pulumi.getter(name="tagsToAddToMetrics")
    def tags_to_add_to_metrics(self) -> Optional[Sequence[builtins.str]]:
        """
        A set of tags to add to all metrics exported by this scrape job, for use in PromQL queries.
        """
        return pulumi.get(self, "tags_to_add_to_metrics")


@pulumi.output_type
class ProviderAwsCloudwatchScrapeJobServiceMetric(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 statistics: Sequence[builtins.str]):
        """
        :param builtins.str name: The name of the metric to scrape.
        :param Sequence[builtins.str] statistics: A set of statistics to scrape.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "statistics", statistics)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the metric to scrape.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def statistics(self) -> Sequence[builtins.str]:
        """
        A set of statistics to scrape.
        """
        return pulumi.get(self, "statistics")


@pulumi.output_type
class ProviderAwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilter(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The key of the tag filter.
        :param builtins.str value: The value of the tag filter.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the tag filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the tag filter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ProviderAzureCredentialAutoDiscoveryConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceTypeConfigurations":
            suggest = "resource_type_configurations"
        elif key == "subscriptionId":
            suggest = "subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProviderAzureCredentialAutoDiscoveryConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProviderAzureCredentialAutoDiscoveryConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProviderAzureCredentialAutoDiscoveryConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_type_configurations: Sequence['outputs.ProviderAzureCredentialAutoDiscoveryConfigurationResourceTypeConfiguration'],
                 subscription_id: builtins.str):
        """
        :param Sequence['ProviderAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationArgs'] resource_type_configurations: The list of resource type configurations.
        :param builtins.str subscription_id: The subscription ID of the Azure account.
        """
        pulumi.set(__self__, "resource_type_configurations", resource_type_configurations)
        pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="resourceTypeConfigurations")
    def resource_type_configurations(self) -> Sequence['outputs.ProviderAzureCredentialAutoDiscoveryConfigurationResourceTypeConfiguration']:
        """
        The list of resource type configurations.
        """
        return pulumi.get(self, "resource_type_configurations")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> builtins.str:
        """
        The subscription ID of the Azure account.
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class ProviderAzureCredentialAutoDiscoveryConfigurationResourceTypeConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricConfigurations":
            suggest = "metric_configurations"
        elif key == "resourceTypeName":
            suggest = "resource_type_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProviderAzureCredentialAutoDiscoveryConfigurationResourceTypeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProviderAzureCredentialAutoDiscoveryConfigurationResourceTypeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProviderAzureCredentialAutoDiscoveryConfigurationResourceTypeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_configurations: Sequence['outputs.ProviderAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationMetricConfiguration'],
                 resource_type_name: builtins.str):
        pulumi.set(__self__, "metric_configurations", metric_configurations)
        pulumi.set(__self__, "resource_type_name", resource_type_name)

    @property
    @pulumi.getter(name="metricConfigurations")
    def metric_configurations(self) -> Sequence['outputs.ProviderAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationMetricConfiguration']:
        return pulumi.get(self, "metric_configurations")

    @property
    @pulumi.getter(name="resourceTypeName")
    def resource_type_name(self) -> builtins.str:
        return pulumi.get(self, "resource_type_name")


@pulumi.output_type
class ProviderAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationMetricConfiguration(dict):
    def __init__(__self__, *,
                 aggregations: Sequence[builtins.str],
                 dimensions: Sequence[builtins.str],
                 name: builtins.str):
        pulumi.set(__self__, "aggregations", aggregations)
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def aggregations(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "aggregations")

    @property
    @pulumi.getter
    def dimensions(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class ProviderAzureCredentialResourceDiscoveryTagFilter(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The key of the tag filter.
        :param builtins.str value: The value of the tag filter.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the tag filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the tag filter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAccessPoliciesAccessPolicyResult(dict):
    def __init__(__self__, *,
                 display_name: builtins.str,
                 id: builtins.str,
                 name: builtins.str,
                 region: builtins.str,
                 status: builtins.str):
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        return pulumi.get(self, "status")


@pulumi.output_type
class GetPrivateDataSourceConnectNetworksPrivateDataSourceConnectNetworkResult(dict):
    def __init__(__self__, *,
                 display_name: builtins.str,
                 id: builtins.str,
                 name: builtins.str,
                 region: builtins.str,
                 status: builtins.str):
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        return pulumi.get(self, "status")


@pulumi.output_type
class GetProviderAwsCloudwatchScrapeJobCustomNamespaceResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 scrape_interval_seconds: builtins.int,
                 metrics: Optional[Sequence['outputs.GetProviderAwsCloudwatchScrapeJobCustomNamespaceMetricResult']] = None):
        """
        :param builtins.str name: The name of the custom namespace to scrape.
        :param builtins.int scrape_interval_seconds: The interval in seconds to scrape the custom namespace.
        :param Sequence['GetProviderAwsCloudwatchScrapeJobCustomNamespaceMetricArgs'] metrics: One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scrape_interval_seconds", scrape_interval_seconds)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the custom namespace to scrape.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="scrapeIntervalSeconds")
    def scrape_interval_seconds(self) -> builtins.int:
        """
        The interval in seconds to scrape the custom namespace.
        """
        return pulumi.get(self, "scrape_interval_seconds")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.GetProviderAwsCloudwatchScrapeJobCustomNamespaceMetricResult']]:
        """
        One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "metrics")


@pulumi.output_type
class GetProviderAwsCloudwatchScrapeJobCustomNamespaceMetricResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 statistics: Sequence[builtins.str]):
        """
        :param builtins.str name: The name of the metric to scrape.
        :param Sequence[builtins.str] statistics: A set of statistics to scrape.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "statistics", statistics)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the metric to scrape.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def statistics(self) -> Sequence[builtins.str]:
        """
        A set of statistics to scrape.
        """
        return pulumi.get(self, "statistics")


@pulumi.output_type
class GetProviderAwsCloudwatchScrapeJobServiceResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 scrape_interval_seconds: builtins.int,
                 tags_to_add_to_metrics: Sequence[builtins.str],
                 metrics: Optional[Sequence['outputs.GetProviderAwsCloudwatchScrapeJobServiceMetricResult']] = None,
                 resource_discovery_tag_filters: Optional[Sequence['outputs.GetProviderAwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilterResult']] = None):
        """
        :param builtins.str name: The name of the service to scrape. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported services, metrics, and their statistics.
        :param builtins.int scrape_interval_seconds: The interval in seconds to scrape the service. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported scrape intervals.
        :param Sequence[builtins.str] tags_to_add_to_metrics: A set of tags to add to all metrics exported by this scrape job, for use in PromQL queries.
        :param Sequence['GetProviderAwsCloudwatchScrapeJobServiceMetricArgs'] metrics: One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        :param Sequence['GetProviderAwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilterArgs'] resource_discovery_tag_filters: One or more configuration blocks to configure tag filters applied to discovery of resource entities in the associated AWS account. When accessing this as an attribute reference, it is a list of objects.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scrape_interval_seconds", scrape_interval_seconds)
        pulumi.set(__self__, "tags_to_add_to_metrics", tags_to_add_to_metrics)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if resource_discovery_tag_filters is not None:
            pulumi.set(__self__, "resource_discovery_tag_filters", resource_discovery_tag_filters)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the service to scrape. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported services, metrics, and their statistics.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="scrapeIntervalSeconds")
    def scrape_interval_seconds(self) -> builtins.int:
        """
        The interval in seconds to scrape the service. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported scrape intervals.
        """
        return pulumi.get(self, "scrape_interval_seconds")

    @property
    @pulumi.getter(name="tagsToAddToMetrics")
    def tags_to_add_to_metrics(self) -> Sequence[builtins.str]:
        """
        A set of tags to add to all metrics exported by this scrape job, for use in PromQL queries.
        """
        return pulumi.get(self, "tags_to_add_to_metrics")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.GetProviderAwsCloudwatchScrapeJobServiceMetricResult']]:
        """
        One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="resourceDiscoveryTagFilters")
    def resource_discovery_tag_filters(self) -> Optional[Sequence['outputs.GetProviderAwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilterResult']]:
        """
        One or more configuration blocks to configure tag filters applied to discovery of resource entities in the associated AWS account. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "resource_discovery_tag_filters")


@pulumi.output_type
class GetProviderAwsCloudwatchScrapeJobServiceMetricResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 statistics: Sequence[builtins.str]):
        """
        :param builtins.str name: The name of the metric to scrape.
        :param Sequence[builtins.str] statistics: A set of statistics to scrape.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "statistics", statistics)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the metric to scrape.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def statistics(self) -> Sequence[builtins.str]:
        """
        A set of statistics to scrape.
        """
        return pulumi.get(self, "statistics")


@pulumi.output_type
class GetProviderAwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilterResult(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The key of the tag filter.
        :param builtins.str value: The value of the tag filter.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the tag filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the tag filter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetProviderAwsCloudwatchScrapeJobsScrapeJobResult(dict):
    def __init__(__self__, *,
                 aws_account_resource_id: builtins.str,
                 disabled_reason: builtins.str,
                 enabled: builtins.bool,
                 export_tags: builtins.bool,
                 id: builtins.str,
                 name: builtins.str,
                 regions: Sequence[builtins.str],
                 regions_subset_override_used: builtins.bool,
                 role_arn: builtins.str,
                 stack_id: builtins.str,
                 static_labels: Mapping[str, builtins.str],
                 custom_namespaces: Optional[Sequence['outputs.GetProviderAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceResult']] = None,
                 services: Optional[Sequence['outputs.GetProviderAwsCloudwatchScrapeJobsScrapeJobServiceResult']] = None):
        """
        :param builtins.str aws_account_resource_id: The ID assigned by the Grafana Cloud Provider API to an AWS Account resource that should be associated with this AWS CloudWatch Scrape Job. This can be provided by the `resource_id` attribute of the `cloudProvider.AwsAccount` resource.
        :param builtins.str disabled_reason: When the AWS CloudWatch Scrape Job is disabled, this will show the reason that it is in that state.
        :param builtins.bool enabled: Whether the AWS CloudWatch Scrape Job is enabled or not.
        :param builtins.bool export_tags: When enabled, AWS resource tags are exported as Prometheus labels to metrics formatted as `aws_<service_name>_info`.
        :param Sequence[builtins.str] regions: The set of AWS region names that this AWS CloudWatch Scrape Job is configured to scrape.
        :param builtins.bool regions_subset_override_used: When true, the `regions` attribute will be the set of regions configured in the override. When false, the `regions` attribute will be the set of regions belonging to the AWS Account resource that is associated with this AWS CloudWatch Scrape Job.
        :param builtins.str role_arn: The AWS ARN of the IAM role associated with the AWS Account resource that is being used by this AWS CloudWatch Scrape Job.
        :param Mapping[str, builtins.str] static_labels: A set of static labels to add to all metrics exported by this scrape job.
        :param Sequence['GetProviderAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceArgs'] custom_namespaces: Zero or more configuration blocks to configure custom namespaces for the AWS CloudWatch Scrape Job to scrape. Each block must have a distinct `name` attribute. When accessing this as an attribute reference, it is a list of objects.
        :param Sequence['GetProviderAwsCloudwatchScrapeJobsScrapeJobServiceArgs'] services: One or more configuration blocks to dictate what this AWS CloudWatch Scrape Job should scrape. Each block must have a distinct `name` attribute. When accessing this as an attribute reference, it is a list of objects.
        """
        pulumi.set(__self__, "aws_account_resource_id", aws_account_resource_id)
        pulumi.set(__self__, "disabled_reason", disabled_reason)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "export_tags", export_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "regions", regions)
        pulumi.set(__self__, "regions_subset_override_used", regions_subset_override_used)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "stack_id", stack_id)
        pulumi.set(__self__, "static_labels", static_labels)
        if custom_namespaces is not None:
            pulumi.set(__self__, "custom_namespaces", custom_namespaces)
        if services is not None:
            pulumi.set(__self__, "services", services)

    @property
    @pulumi.getter(name="awsAccountResourceId")
    def aws_account_resource_id(self) -> builtins.str:
        """
        The ID assigned by the Grafana Cloud Provider API to an AWS Account resource that should be associated with this AWS CloudWatch Scrape Job. This can be provided by the `resource_id` attribute of the `cloudProvider.AwsAccount` resource.
        """
        return pulumi.get(self, "aws_account_resource_id")

    @property
    @pulumi.getter(name="disabledReason")
    def disabled_reason(self) -> builtins.str:
        """
        When the AWS CloudWatch Scrape Job is disabled, this will show the reason that it is in that state.
        """
        return pulumi.get(self, "disabled_reason")

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether the AWS CloudWatch Scrape Job is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="exportTags")
    def export_tags(self) -> builtins.bool:
        """
        When enabled, AWS resource tags are exported as Prometheus labels to metrics formatted as `aws_<service_name>_info`.
        """
        return pulumi.get(self, "export_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def regions(self) -> Sequence[builtins.str]:
        """
        The set of AWS region names that this AWS CloudWatch Scrape Job is configured to scrape.
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="regionsSubsetOverrideUsed")
    def regions_subset_override_used(self) -> builtins.bool:
        """
        When true, the `regions` attribute will be the set of regions configured in the override. When false, the `regions` attribute will be the set of regions belonging to the AWS Account resource that is associated with this AWS CloudWatch Scrape Job.
        """
        return pulumi.get(self, "regions_subset_override_used")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The AWS ARN of the IAM role associated with the AWS Account resource that is being used by this AWS CloudWatch Scrape Job.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> builtins.str:
        return pulumi.get(self, "stack_id")

    @property
    @pulumi.getter(name="staticLabels")
    def static_labels(self) -> Mapping[str, builtins.str]:
        """
        A set of static labels to add to all metrics exported by this scrape job.
        """
        return pulumi.get(self, "static_labels")

    @property
    @pulumi.getter(name="customNamespaces")
    def custom_namespaces(self) -> Optional[Sequence['outputs.GetProviderAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceResult']]:
        """
        Zero or more configuration blocks to configure custom namespaces for the AWS CloudWatch Scrape Job to scrape. Each block must have a distinct `name` attribute. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "custom_namespaces")

    @property
    @pulumi.getter
    def services(self) -> Optional[Sequence['outputs.GetProviderAwsCloudwatchScrapeJobsScrapeJobServiceResult']]:
        """
        One or more configuration blocks to dictate what this AWS CloudWatch Scrape Job should scrape. Each block must have a distinct `name` attribute. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "services")


@pulumi.output_type
class GetProviderAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 scrape_interval_seconds: builtins.int,
                 metrics: Optional[Sequence['outputs.GetProviderAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceMetricResult']] = None):
        """
        :param builtins.str name: The name of the custom namespace to scrape.
        :param builtins.int scrape_interval_seconds: The interval in seconds to scrape the custom namespace.
        :param Sequence['GetProviderAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceMetricArgs'] metrics: One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scrape_interval_seconds", scrape_interval_seconds)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the custom namespace to scrape.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="scrapeIntervalSeconds")
    def scrape_interval_seconds(self) -> builtins.int:
        """
        The interval in seconds to scrape the custom namespace.
        """
        return pulumi.get(self, "scrape_interval_seconds")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.GetProviderAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceMetricResult']]:
        """
        One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "metrics")


@pulumi.output_type
class GetProviderAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceMetricResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 statistics: Sequence[builtins.str]):
        """
        :param builtins.str name: The name of the metric to scrape.
        :param Sequence[builtins.str] statistics: A set of statistics to scrape.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "statistics", statistics)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the metric to scrape.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def statistics(self) -> Sequence[builtins.str]:
        """
        A set of statistics to scrape.
        """
        return pulumi.get(self, "statistics")


@pulumi.output_type
class GetProviderAwsCloudwatchScrapeJobsScrapeJobServiceResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 scrape_interval_seconds: builtins.int,
                 tags_to_add_to_metrics: Sequence[builtins.str],
                 metrics: Optional[Sequence['outputs.GetProviderAwsCloudwatchScrapeJobsScrapeJobServiceMetricResult']] = None,
                 resource_discovery_tag_filters: Optional[Sequence['outputs.GetProviderAwsCloudwatchScrapeJobsScrapeJobServiceResourceDiscoveryTagFilterResult']] = None):
        """
        :param builtins.str name: The name of the service to scrape. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported services, metrics, and their statistics.
        :param builtins.int scrape_interval_seconds: The interval in seconds to scrape the service. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported scrape intervals.
        :param Sequence[builtins.str] tags_to_add_to_metrics: A set of tags to add to all metrics exported by this scrape job, for use in PromQL queries.
        :param Sequence['GetProviderAwsCloudwatchScrapeJobsScrapeJobServiceMetricArgs'] metrics: One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        :param Sequence['GetProviderAwsCloudwatchScrapeJobsScrapeJobServiceResourceDiscoveryTagFilterArgs'] resource_discovery_tag_filters: One or more configuration blocks to configure tag filters applied to discovery of resource entities in the associated AWS account. When accessing this as an attribute reference, it is a list of objects.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scrape_interval_seconds", scrape_interval_seconds)
        pulumi.set(__self__, "tags_to_add_to_metrics", tags_to_add_to_metrics)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if resource_discovery_tag_filters is not None:
            pulumi.set(__self__, "resource_discovery_tag_filters", resource_discovery_tag_filters)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the service to scrape. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported services, metrics, and their statistics.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="scrapeIntervalSeconds")
    def scrape_interval_seconds(self) -> builtins.int:
        """
        The interval in seconds to scrape the service. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported scrape intervals.
        """
        return pulumi.get(self, "scrape_interval_seconds")

    @property
    @pulumi.getter(name="tagsToAddToMetrics")
    def tags_to_add_to_metrics(self) -> Sequence[builtins.str]:
        """
        A set of tags to add to all metrics exported by this scrape job, for use in PromQL queries.
        """
        return pulumi.get(self, "tags_to_add_to_metrics")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.GetProviderAwsCloudwatchScrapeJobsScrapeJobServiceMetricResult']]:
        """
        One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="resourceDiscoveryTagFilters")
    def resource_discovery_tag_filters(self) -> Optional[Sequence['outputs.GetProviderAwsCloudwatchScrapeJobsScrapeJobServiceResourceDiscoveryTagFilterResult']]:
        """
        One or more configuration blocks to configure tag filters applied to discovery of resource entities in the associated AWS account. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "resource_discovery_tag_filters")


@pulumi.output_type
class GetProviderAwsCloudwatchScrapeJobsScrapeJobServiceMetricResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 statistics: Sequence[builtins.str]):
        """
        :param builtins.str name: The name of the metric to scrape.
        :param Sequence[builtins.str] statistics: A set of statistics to scrape.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "statistics", statistics)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the metric to scrape.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def statistics(self) -> Sequence[builtins.str]:
        """
        A set of statistics to scrape.
        """
        return pulumi.get(self, "statistics")


@pulumi.output_type
class GetProviderAwsCloudwatchScrapeJobsScrapeJobServiceResourceDiscoveryTagFilterResult(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The key of the tag filter.
        :param builtins.str value: The value of the tag filter.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the tag filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the tag filter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetProviderAzureCredentialAutoDiscoveryConfigurationResult(dict):
    def __init__(__self__, *,
                 resource_type_configurations: Sequence['outputs.GetProviderAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationResult'],
                 subscription_id: builtins.str):
        """
        :param Sequence['GetProviderAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationArgs'] resource_type_configurations: The list of resource type configurations.
        :param builtins.str subscription_id: The subscription ID of the Azure account.
        """
        pulumi.set(__self__, "resource_type_configurations", resource_type_configurations)
        pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="resourceTypeConfigurations")
    def resource_type_configurations(self) -> Sequence['outputs.GetProviderAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationResult']:
        """
        The list of resource type configurations.
        """
        return pulumi.get(self, "resource_type_configurations")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> builtins.str:
        """
        The subscription ID of the Azure account.
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class GetProviderAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationResult(dict):
    def __init__(__self__, *,
                 metric_configurations: Sequence['outputs.GetProviderAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationMetricConfigurationResult'],
                 resource_type_name: builtins.str):
        pulumi.set(__self__, "metric_configurations", metric_configurations)
        pulumi.set(__self__, "resource_type_name", resource_type_name)

    @property
    @pulumi.getter(name="metricConfigurations")
    def metric_configurations(self) -> Sequence['outputs.GetProviderAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationMetricConfigurationResult']:
        return pulumi.get(self, "metric_configurations")

    @property
    @pulumi.getter(name="resourceTypeName")
    def resource_type_name(self) -> builtins.str:
        return pulumi.get(self, "resource_type_name")


@pulumi.output_type
class GetProviderAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationMetricConfigurationResult(dict):
    def __init__(__self__, *,
                 aggregations: Sequence[builtins.str],
                 dimensions: Sequence[builtins.str],
                 name: builtins.str):
        pulumi.set(__self__, "aggregations", aggregations)
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def aggregations(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "aggregations")

    @property
    @pulumi.getter
    def dimensions(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetProviderAzureCredentialResourceDiscoveryTagFilterResult(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The key of the tag filter.
        :param builtins.str value: The value of the tag filter.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the tag filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the tag filter.
        """
        return pulumi.get(self, "value")


