# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PrivateDataSourceConnectNetworkTokenArgs', 'PrivateDataSourceConnectNetworkToken']

@pulumi.input_type
class PrivateDataSourceConnectNetworkTokenArgs:
    def __init__(__self__, *,
                 pdc_network_id: pulumi.Input[builtins.str],
                 region: pulumi.Input[builtins.str],
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a PrivateDataSourceConnectNetworkToken resource.
        :param pulumi.Input[builtins.str] pdc_network_id: ID of the private data source network for which to create a token.
        :param pulumi.Input[builtins.str] region: Region of the private data source network. Should be set to the same region as the private data source network. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-regions.
        :param pulumi.Input[builtins.str] display_name: Display name of the private data source network token. Defaults to the name.
        :param pulumi.Input[builtins.str] expires_at: Expiration date of the private data source network token. Does not expire by default.
        :param pulumi.Input[builtins.str] name: Name of the private data source network token.
        """
        pulumi.set(__self__, "pdc_network_id", pdc_network_id)
        pulumi.set(__self__, "region", region)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="pdcNetworkId")
    def pdc_network_id(self) -> pulumi.Input[builtins.str]:
        """
        ID of the private data source network for which to create a token.
        """
        return pulumi.get(self, "pdc_network_id")

    @pdc_network_id.setter
    def pdc_network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "pdc_network_id", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[builtins.str]:
        """
        Region of the private data source network. Should be set to the same region as the private data source network. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-regions.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Display name of the private data source network token. Defaults to the name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Expiration date of the private data source network token. Does not expire by default.
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expires_at", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the private data source network token.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _PrivateDataSourceConnectNetworkTokenState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pdc_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 token: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering PrivateDataSourceConnectNetworkToken resources.
        :param pulumi.Input[builtins.str] created_at: Creation date of the private data source network token.
        :param pulumi.Input[builtins.str] display_name: Display name of the private data source network token. Defaults to the name.
        :param pulumi.Input[builtins.str] expires_at: Expiration date of the private data source network token. Does not expire by default.
        :param pulumi.Input[builtins.str] name: Name of the private data source network token.
        :param pulumi.Input[builtins.str] pdc_network_id: ID of the private data source network for which to create a token.
        :param pulumi.Input[builtins.str] region: Region of the private data source network. Should be set to the same region as the private data source network. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-regions.
        :param pulumi.Input[builtins.str] updated_at: Last update date of the private data source network token.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pdc_network_id is not None:
            pulumi.set(__self__, "pdc_network_id", pdc_network_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation date of the private data source network token.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Display name of the private data source network token. Defaults to the name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Expiration date of the private data source network token. Does not expire by default.
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expires_at", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the private data source network token.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pdcNetworkId")
    def pdc_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the private data source network for which to create a token.
        """
        return pulumi.get(self, "pdc_network_id")

    @pdc_network_id.setter
    def pdc_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pdc_network_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region of the private data source network. Should be set to the same region as the private data source network. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-regions.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Last update date of the private data source network token.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("grafana:cloud/privateDataSourceConnectNetworkToken:PrivateDataSourceConnectNetworkToken")
class PrivateDataSourceConnectNetworkToken(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pdc_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        * [Official documentation](https://grafana.com/docs/grafana-cloud/connect-externally-hosted/private-data-source-connect/)
        * [API documentation](https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#create-a-token)

        Required access policy scopes:

        * accesspolicies:read
        * accesspolicies:write
        * accesspolicies:delete

        ## Example Usage

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        current = grafana.cloud.get_stack(slug="<your slug>")
        test = grafana.cloud.PrivateDataSourceConnectNetwork("test",
            region="prod-us-east-0",
            name="my-pdc",
            display_name="My PDC",
            stack_identifier=current.id)
        test_private_data_source_connect_network_token = grafana.cloud.PrivateDataSourceConnectNetworkToken("test",
            pdc_network_id=test.pdc_network_id,
            region=test.region,
            name="my-pdc-token",
            display_name="My PDC Token")
        ```

        ## Import

        ```sh
        $ pulumi import grafana:cloud/privateDataSourceConnectNetworkToken:PrivateDataSourceConnectNetworkToken name "{{ region }}:{{ tokenId }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] display_name: Display name of the private data source network token. Defaults to the name.
        :param pulumi.Input[builtins.str] expires_at: Expiration date of the private data source network token. Does not expire by default.
        :param pulumi.Input[builtins.str] name: Name of the private data source network token.
        :param pulumi.Input[builtins.str] pdc_network_id: ID of the private data source network for which to create a token.
        :param pulumi.Input[builtins.str] region: Region of the private data source network. Should be set to the same region as the private data source network. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-regions.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PrivateDataSourceConnectNetworkTokenArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        * [Official documentation](https://grafana.com/docs/grafana-cloud/connect-externally-hosted/private-data-source-connect/)
        * [API documentation](https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#create-a-token)

        Required access policy scopes:

        * accesspolicies:read
        * accesspolicies:write
        * accesspolicies:delete

        ## Example Usage

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        current = grafana.cloud.get_stack(slug="<your slug>")
        test = grafana.cloud.PrivateDataSourceConnectNetwork("test",
            region="prod-us-east-0",
            name="my-pdc",
            display_name="My PDC",
            stack_identifier=current.id)
        test_private_data_source_connect_network_token = grafana.cloud.PrivateDataSourceConnectNetworkToken("test",
            pdc_network_id=test.pdc_network_id,
            region=test.region,
            name="my-pdc-token",
            display_name="My PDC Token")
        ```

        ## Import

        ```sh
        $ pulumi import grafana:cloud/privateDataSourceConnectNetworkToken:PrivateDataSourceConnectNetworkToken name "{{ region }}:{{ tokenId }}"
        ```

        :param str resource_name: The name of the resource.
        :param PrivateDataSourceConnectNetworkTokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PrivateDataSourceConnectNetworkTokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pdc_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PrivateDataSourceConnectNetworkTokenArgs.__new__(PrivateDataSourceConnectNetworkTokenArgs)

            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["expires_at"] = expires_at
            __props__.__dict__["name"] = name
            if pdc_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'pdc_network_id'")
            __props__.__dict__["pdc_network_id"] = pdc_network_id
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["created_at"] = None
            __props__.__dict__["token"] = None
            __props__.__dict__["updated_at"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(PrivateDataSourceConnectNetworkToken, __self__).__init__(
            'grafana:cloud/privateDataSourceConnectNetworkToken:PrivateDataSourceConnectNetworkToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            expires_at: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            pdc_network_id: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            token: Optional[pulumi.Input[builtins.str]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None) -> 'PrivateDataSourceConnectNetworkToken':
        """
        Get an existing PrivateDataSourceConnectNetworkToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] created_at: Creation date of the private data source network token.
        :param pulumi.Input[builtins.str] display_name: Display name of the private data source network token. Defaults to the name.
        :param pulumi.Input[builtins.str] expires_at: Expiration date of the private data source network token. Does not expire by default.
        :param pulumi.Input[builtins.str] name: Name of the private data source network token.
        :param pulumi.Input[builtins.str] pdc_network_id: ID of the private data source network for which to create a token.
        :param pulumi.Input[builtins.str] region: Region of the private data source network. Should be set to the same region as the private data source network. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-regions.
        :param pulumi.Input[builtins.str] updated_at: Last update date of the private data source network token.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PrivateDataSourceConnectNetworkTokenState.__new__(_PrivateDataSourceConnectNetworkTokenState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["expires_at"] = expires_at
        __props__.__dict__["name"] = name
        __props__.__dict__["pdc_network_id"] = pdc_network_id
        __props__.__dict__["region"] = region
        __props__.__dict__["token"] = token
        __props__.__dict__["updated_at"] = updated_at
        return PrivateDataSourceConnectNetworkToken(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Creation date of the private data source network token.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Display name of the private data source network token. Defaults to the name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Expiration date of the private data source network token. Does not expire by default.
        """
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the private data source network token.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pdcNetworkId")
    def pdc_network_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the private data source network for which to create a token.
        """
        return pulumi.get(self, "pdc_network_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region of the private data source network. Should be set to the same region as the private data source network. Use the region list API to get the list of available regions: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-regions.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "token")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        Last update date of the private data source network token.
        """
        return pulumi.get(self, "updated_at")

