# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAwsCloudwatchScrapeJobsResult',
    'AwaitableGetAwsCloudwatchScrapeJobsResult',
    'get_aws_cloudwatch_scrape_jobs',
    'get_aws_cloudwatch_scrape_jobs_output',
]

@pulumi.output_type
class GetAwsCloudwatchScrapeJobsResult:
    """
    A collection of values returned by getAwsCloudwatchScrapeJobs.
    """
    def __init__(__self__, id=None, scrape_jobs=None, stack_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if scrape_jobs and not isinstance(scrape_jobs, list):
            raise TypeError("Expected argument 'scrape_jobs' to be a list")
        pulumi.set(__self__, "scrape_jobs", scrape_jobs)
        if stack_id and not isinstance(stack_id, str):
            raise TypeError("Expected argument 'stack_id' to be a str")
        pulumi.set(__self__, "stack_id", stack_id)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="scrapeJobs")
    def scrape_jobs(self) -> Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobsScrapeJobResult']]:
        """
        A list of AWS CloudWatch Scrape Job objects associated with the given StackID.
        """
        return pulumi.get(self, "scrape_jobs")

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> builtins.str:
        return pulumi.get(self, "stack_id")


class AwaitableGetAwsCloudwatchScrapeJobsResult(GetAwsCloudwatchScrapeJobsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAwsCloudwatchScrapeJobsResult(
            id=self.id,
            scrape_jobs=self.scrape_jobs,
            stack_id=self.stack_id)


def get_aws_cloudwatch_scrape_jobs(scrape_jobs: Optional[Sequence[Union['GetAwsCloudwatchScrapeJobsScrapeJobArgs', 'GetAwsCloudwatchScrapeJobsScrapeJobArgsDict']]] = None,
                                   stack_id: Optional[builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAwsCloudwatchScrapeJobsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana

    test = grafana.cloud.get_stack(slug="gcloudstacktest")
    test_get_aws_cloudwatch_scrape_jobs = grafana.cloudProvider.get_aws_cloudwatch_scrape_jobs(stack_id=test.id)
    ```


    :param Sequence[Union['GetAwsCloudwatchScrapeJobsScrapeJobArgs', 'GetAwsCloudwatchScrapeJobsScrapeJobArgsDict']] scrape_jobs: A list of AWS CloudWatch Scrape Job objects associated with the given StackID.
    """
    __args__ = dict()
    __args__['scrapeJobs'] = scrape_jobs
    __args__['stackId'] = stack_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('grafana:cloudProvider/getAwsCloudwatchScrapeJobs:getAwsCloudwatchScrapeJobs', __args__, opts=opts, typ=GetAwsCloudwatchScrapeJobsResult).value

    return AwaitableGetAwsCloudwatchScrapeJobsResult(
        id=pulumi.get(__ret__, 'id'),
        scrape_jobs=pulumi.get(__ret__, 'scrape_jobs'),
        stack_id=pulumi.get(__ret__, 'stack_id'))
def get_aws_cloudwatch_scrape_jobs_output(scrape_jobs: Optional[pulumi.Input[Optional[Sequence[Union['GetAwsCloudwatchScrapeJobsScrapeJobArgs', 'GetAwsCloudwatchScrapeJobsScrapeJobArgsDict']]]]] = None,
                                          stack_id: Optional[pulumi.Input[builtins.str]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAwsCloudwatchScrapeJobsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana

    test = grafana.cloud.get_stack(slug="gcloudstacktest")
    test_get_aws_cloudwatch_scrape_jobs = grafana.cloudProvider.get_aws_cloudwatch_scrape_jobs(stack_id=test.id)
    ```


    :param Sequence[Union['GetAwsCloudwatchScrapeJobsScrapeJobArgs', 'GetAwsCloudwatchScrapeJobsScrapeJobArgsDict']] scrape_jobs: A list of AWS CloudWatch Scrape Job objects associated with the given StackID.
    """
    __args__ = dict()
    __args__['scrapeJobs'] = scrape_jobs
    __args__['stackId'] = stack_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('grafana:cloudProvider/getAwsCloudwatchScrapeJobs:getAwsCloudwatchScrapeJobs', __args__, opts=opts, typ=GetAwsCloudwatchScrapeJobsResult)
    return __ret__.apply(lambda __response__: GetAwsCloudwatchScrapeJobsResult(
        id=pulumi.get(__response__, 'id'),
        scrape_jobs=pulumi.get(__response__, 'scrape_jobs'),
        stack_id=pulumi.get(__response__, 'stack_id')))
