# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ScimConfigArgs', 'ScimConfig']

@pulumi.input_type
class ScimConfigArgs:
    def __init__(__self__, *,
                 allow_non_provisioned_users: pulumi.Input[builtins.bool],
                 enable_group_sync: pulumi.Input[builtins.bool],
                 enable_user_sync: pulumi.Input[builtins.bool],
                 org_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ScimConfig resource.
        :param pulumi.Input[builtins.bool] allow_non_provisioned_users: Whether to allow non-provisioned users to access Grafana.
        :param pulumi.Input[builtins.bool] enable_group_sync: Whether group synchronization is enabled.
        :param pulumi.Input[builtins.bool] enable_user_sync: Whether user synchronization is enabled.
        :param pulumi.Input[builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        pulumi.set(__self__, "allow_non_provisioned_users", allow_non_provisioned_users)
        pulumi.set(__self__, "enable_group_sync", enable_group_sync)
        pulumi.set(__self__, "enable_user_sync", enable_user_sync)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)

    @property
    @pulumi.getter(name="allowNonProvisionedUsers")
    def allow_non_provisioned_users(self) -> pulumi.Input[builtins.bool]:
        """
        Whether to allow non-provisioned users to access Grafana.
        """
        return pulumi.get(self, "allow_non_provisioned_users")

    @allow_non_provisioned_users.setter
    def allow_non_provisioned_users(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "allow_non_provisioned_users", value)

    @property
    @pulumi.getter(name="enableGroupSync")
    def enable_group_sync(self) -> pulumi.Input[builtins.bool]:
        """
        Whether group synchronization is enabled.
        """
        return pulumi.get(self, "enable_group_sync")

    @enable_group_sync.setter
    def enable_group_sync(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enable_group_sync", value)

    @property
    @pulumi.getter(name="enableUserSync")
    def enable_user_sync(self) -> pulumi.Input[builtins.bool]:
        """
        Whether user synchronization is enabled.
        """
        return pulumi.get(self, "enable_user_sync")

    @enable_user_sync.setter
    def enable_user_sync(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enable_user_sync", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)


@pulumi.input_type
class _ScimConfigState:
    def __init__(__self__, *,
                 allow_non_provisioned_users: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_group_sync: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_user_sync: Optional[pulumi.Input[builtins.bool]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ScimConfig resources.
        :param pulumi.Input[builtins.bool] allow_non_provisioned_users: Whether to allow non-provisioned users to access Grafana.
        :param pulumi.Input[builtins.bool] enable_group_sync: Whether group synchronization is enabled.
        :param pulumi.Input[builtins.bool] enable_user_sync: Whether user synchronization is enabled.
        :param pulumi.Input[builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        if allow_non_provisioned_users is not None:
            pulumi.set(__self__, "allow_non_provisioned_users", allow_non_provisioned_users)
        if enable_group_sync is not None:
            pulumi.set(__self__, "enable_group_sync", enable_group_sync)
        if enable_user_sync is not None:
            pulumi.set(__self__, "enable_user_sync", enable_user_sync)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)

    @property
    @pulumi.getter(name="allowNonProvisionedUsers")
    def allow_non_provisioned_users(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to allow non-provisioned users to access Grafana.
        """
        return pulumi.get(self, "allow_non_provisioned_users")

    @allow_non_provisioned_users.setter
    def allow_non_provisioned_users(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_non_provisioned_users", value)

    @property
    @pulumi.getter(name="enableGroupSync")
    def enable_group_sync(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether group synchronization is enabled.
        """
        return pulumi.get(self, "enable_group_sync")

    @enable_group_sync.setter
    def enable_group_sync(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_group_sync", value)

    @property
    @pulumi.getter(name="enableUserSync")
    def enable_user_sync(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether user synchronization is enabled.
        """
        return pulumi.get(self, "enable_user_sync")

    @enable_user_sync.setter
    def enable_user_sync(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_user_sync", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "org_id", value)


@pulumi.type_token("grafana:enterprise/scimConfig:ScimConfig")
class ScimConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_non_provisioned_users: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_group_sync: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_user_sync: Optional[pulumi.Input[builtins.bool]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        **Note:** This resource is available only with Grafana Enterprise.

        * [Official documentation](https://grafana.com/docs/grafana/latest/setup-grafana/configure-security/configure-scim-provisioning/)

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        default = grafana.enterprise.ScimConfig("default",
            enable_user_sync=True,
            enable_group_sync=False,
            allow_non_provisioned_users=False)
        ```

        ## Import

        ```sh
        $ pulumi import grafana:enterprise/scimConfig:ScimConfig name ""
        ```

        ```sh
        $ pulumi import grafana:enterprise/scimConfig:ScimConfig name "{{ orgID }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allow_non_provisioned_users: Whether to allow non-provisioned users to access Grafana.
        :param pulumi.Input[builtins.bool] enable_group_sync: Whether group synchronization is enabled.
        :param pulumi.Input[builtins.bool] enable_user_sync: Whether user synchronization is enabled.
        :param pulumi.Input[builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScimConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        **Note:** This resource is available only with Grafana Enterprise.

        * [Official documentation](https://grafana.com/docs/grafana/latest/setup-grafana/configure-security/configure-scim-provisioning/)

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        default = grafana.enterprise.ScimConfig("default",
            enable_user_sync=True,
            enable_group_sync=False,
            allow_non_provisioned_users=False)
        ```

        ## Import

        ```sh
        $ pulumi import grafana:enterprise/scimConfig:ScimConfig name ""
        ```

        ```sh
        $ pulumi import grafana:enterprise/scimConfig:ScimConfig name "{{ orgID }}"
        ```

        :param str resource_name: The name of the resource.
        :param ScimConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScimConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_non_provisioned_users: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_group_sync: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_user_sync: Optional[pulumi.Input[builtins.bool]] = None,
                 org_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScimConfigArgs.__new__(ScimConfigArgs)

            if allow_non_provisioned_users is None and not opts.urn:
                raise TypeError("Missing required property 'allow_non_provisioned_users'")
            __props__.__dict__["allow_non_provisioned_users"] = allow_non_provisioned_users
            if enable_group_sync is None and not opts.urn:
                raise TypeError("Missing required property 'enable_group_sync'")
            __props__.__dict__["enable_group_sync"] = enable_group_sync
            if enable_user_sync is None and not opts.urn:
                raise TypeError("Missing required property 'enable_user_sync'")
            __props__.__dict__["enable_user_sync"] = enable_user_sync
            __props__.__dict__["org_id"] = org_id
        super(ScimConfig, __self__).__init__(
            'grafana:enterprise/scimConfig:ScimConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_non_provisioned_users: Optional[pulumi.Input[builtins.bool]] = None,
            enable_group_sync: Optional[pulumi.Input[builtins.bool]] = None,
            enable_user_sync: Optional[pulumi.Input[builtins.bool]] = None,
            org_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ScimConfig':
        """
        Get an existing ScimConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allow_non_provisioned_users: Whether to allow non-provisioned users to access Grafana.
        :param pulumi.Input[builtins.bool] enable_group_sync: Whether group synchronization is enabled.
        :param pulumi.Input[builtins.bool] enable_user_sync: Whether user synchronization is enabled.
        :param pulumi.Input[builtins.str] org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScimConfigState.__new__(_ScimConfigState)

        __props__.__dict__["allow_non_provisioned_users"] = allow_non_provisioned_users
        __props__.__dict__["enable_group_sync"] = enable_group_sync
        __props__.__dict__["enable_user_sync"] = enable_user_sync
        __props__.__dict__["org_id"] = org_id
        return ScimConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowNonProvisionedUsers")
    def allow_non_provisioned_users(self) -> pulumi.Output[builtins.bool]:
        """
        Whether to allow non-provisioned users to access Grafana.
        """
        return pulumi.get(self, "allow_non_provisioned_users")

    @property
    @pulumi.getter(name="enableGroupSync")
    def enable_group_sync(self) -> pulumi.Output[builtins.bool]:
        """
        Whether group synchronization is enabled.
        """
        return pulumi.get(self, "enable_group_sync")

    @property
    @pulumi.getter(name="enableUserSync")
    def enable_user_sync(self) -> pulumi.Output[builtins.bool]:
        """
        Whether user synchronization is enabled.
        """
        return pulumi.get(self, "enable_user_sync")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        return pulumi.get(self, "org_id")

