# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetDataSourceResult',
    'AwaitableGetDataSourceResult',
    'get_data_source',
    'get_data_source_output',
]

warnings.warn("""grafana.index/getdatasource.getDataSource has been deprecated in favor of grafana.oss/getdatasource.getDataSource""", DeprecationWarning)

@pulumi.output_type
class GetDataSourceResult:
    """
    A collection of values returned by getDataSource.
    """
    def __init__(__self__, access_mode=None, basic_auth_enabled=None, basic_auth_username=None, database_name=None, id=None, is_default=None, json_data_encoded=None, name=None, org_id=None, private_data_source_connect_network_id=None, type=None, uid=None, url=None, username=None):
        if access_mode and not isinstance(access_mode, str):
            raise TypeError("Expected argument 'access_mode' to be a str")
        pulumi.set(__self__, "access_mode", access_mode)
        if basic_auth_enabled and not isinstance(basic_auth_enabled, bool):
            raise TypeError("Expected argument 'basic_auth_enabled' to be a bool")
        pulumi.set(__self__, "basic_auth_enabled", basic_auth_enabled)
        if basic_auth_username and not isinstance(basic_auth_username, str):
            raise TypeError("Expected argument 'basic_auth_username' to be a str")
        pulumi.set(__self__, "basic_auth_username", basic_auth_username)
        if database_name and not isinstance(database_name, str):
            raise TypeError("Expected argument 'database_name' to be a str")
        pulumi.set(__self__, "database_name", database_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_default and not isinstance(is_default, bool):
            raise TypeError("Expected argument 'is_default' to be a bool")
        pulumi.set(__self__, "is_default", is_default)
        if json_data_encoded and not isinstance(json_data_encoded, str):
            raise TypeError("Expected argument 'json_data_encoded' to be a str")
        pulumi.set(__self__, "json_data_encoded", json_data_encoded)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if private_data_source_connect_network_id and not isinstance(private_data_source_connect_network_id, str):
            raise TypeError("Expected argument 'private_data_source_connect_network_id' to be a str")
        pulumi.set(__self__, "private_data_source_connect_network_id", private_data_source_connect_network_id)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> builtins.str:
        """
        The method by which Grafana will access the data source: `proxy` or `direct`.
        """
        return pulumi.get(self, "access_mode")

    @property
    @pulumi.getter(name="basicAuthEnabled")
    def basic_auth_enabled(self) -> builtins.bool:
        """
        Whether to enable basic auth for the data source.
        """
        return pulumi.get(self, "basic_auth_enabled")

    @property
    @pulumi.getter(name="basicAuthUsername")
    def basic_auth_username(self) -> builtins.str:
        """
        Basic auth username.
        """
        return pulumi.get(self, "basic_auth_username")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        """
        (Required by some data source types) The name of the database to use on the selected data source server.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> builtins.bool:
        """
        Whether to set the data source as default. This should only be `true` to a single data source.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="jsonDataEncoded")
    def json_data_encoded(self) -> builtins.str:
        """
        Serialized JSON string containing the json data. This attribute can be used to pass configuration options to the data source. To figure out what options a datasource has available, see its docs or inspect the network data when saving it from the Grafana UI. Note that keys in this map are usually camelCased.
        """
        return pulumi.get(self, "json_data_encoded")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[builtins.str]:
        """
        The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="privateDataSourceConnectNetworkId")
    def private_data_source_connect_network_id(self) -> builtins.str:
        """
        (Can only be used with data sources in Grafana Cloud) The ID of the Private Data source Connect network to use with this data source.
        """
        return pulumi.get(self, "private_data_source_connect_network_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The data source type. Must be one of the supported data source keywords.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uid(self) -> builtins.str:
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The URL for the data source. The type of URL required varies depending on the chosen data source type.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        (Required by some data source types) The username to use to authenticate to the data source.
        """
        return pulumi.get(self, "username")


class AwaitableGetDataSourceResult(GetDataSourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataSourceResult(
            access_mode=self.access_mode,
            basic_auth_enabled=self.basic_auth_enabled,
            basic_auth_username=self.basic_auth_username,
            database_name=self.database_name,
            id=self.id,
            is_default=self.is_default,
            json_data_encoded=self.json_data_encoded,
            name=self.name,
            org_id=self.org_id,
            private_data_source_connect_network_id=self.private_data_source_connect_network_id,
            type=self.type,
            uid=self.uid,
            url=self.url,
            username=self.username)


def get_data_source(name: Optional[builtins.str] = None,
                    org_id: Optional[builtins.str] = None,
                    uid: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataSourceResult:
    """
    Get details about a Grafana Datasource querying by either name, uid or ID

    ## Example Usage

    ```python
    import pulumi
    import json
    import pulumi_grafana as grafana
    import pulumiverse_grafana as grafana

    prometheus = grafana.oss.DataSource("prometheus",
        type="prometheus",
        name="prometheus-ds-test",
        uid="prometheus-ds-test-uid",
        url="https://my-instance.com",
        basic_auth_enabled=True,
        basic_auth_username="username",
        json_data_encoded=json.dumps({
            "httpMethod": "POST",
            "prometheusType": "Mimir",
            "prometheusVersion": "2.4.0",
        }),
        secure_json_data_encoded=json.dumps({
            "basicAuthPassword": "password",
        }))
    from_name = grafana.oss.get_data_source_output(name=prometheus.name)
    from_uid = grafana.oss.get_data_source_output(uid=prometheus.uid)
    ```


    :param builtins.str org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
    """
    pulumi.log.warn("""get_data_source is deprecated: grafana.index/getdatasource.getDataSource has been deprecated in favor of grafana.oss/getdatasource.getDataSource""")
    __args__ = dict()
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['uid'] = uid
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('grafana:index/getDataSource:getDataSource', __args__, opts=opts, typ=GetDataSourceResult).value

    return AwaitableGetDataSourceResult(
        access_mode=pulumi.get(__ret__, 'access_mode'),
        basic_auth_enabled=pulumi.get(__ret__, 'basic_auth_enabled'),
        basic_auth_username=pulumi.get(__ret__, 'basic_auth_username'),
        database_name=pulumi.get(__ret__, 'database_name'),
        id=pulumi.get(__ret__, 'id'),
        is_default=pulumi.get(__ret__, 'is_default'),
        json_data_encoded=pulumi.get(__ret__, 'json_data_encoded'),
        name=pulumi.get(__ret__, 'name'),
        org_id=pulumi.get(__ret__, 'org_id'),
        private_data_source_connect_network_id=pulumi.get(__ret__, 'private_data_source_connect_network_id'),
        type=pulumi.get(__ret__, 'type'),
        uid=pulumi.get(__ret__, 'uid'),
        url=pulumi.get(__ret__, 'url'),
        username=pulumi.get(__ret__, 'username'))
def get_data_source_output(name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           org_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           uid: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDataSourceResult]:
    """
    Get details about a Grafana Datasource querying by either name, uid or ID

    ## Example Usage

    ```python
    import pulumi
    import json
    import pulumi_grafana as grafana
    import pulumiverse_grafana as grafana

    prometheus = grafana.oss.DataSource("prometheus",
        type="prometheus",
        name="prometheus-ds-test",
        uid="prometheus-ds-test-uid",
        url="https://my-instance.com",
        basic_auth_enabled=True,
        basic_auth_username="username",
        json_data_encoded=json.dumps({
            "httpMethod": "POST",
            "prometheusType": "Mimir",
            "prometheusVersion": "2.4.0",
        }),
        secure_json_data_encoded=json.dumps({
            "basicAuthPassword": "password",
        }))
    from_name = grafana.oss.get_data_source_output(name=prometheus.name)
    from_uid = grafana.oss.get_data_source_output(uid=prometheus.uid)
    ```


    :param builtins.str org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
    """
    pulumi.log.warn("""get_data_source is deprecated: grafana.index/getdatasource.getDataSource has been deprecated in favor of grafana.oss/getdatasource.getDataSource""")
    __args__ = dict()
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['uid'] = uid
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('grafana:index/getDataSource:getDataSource', __args__, opts=opts, typ=GetDataSourceResult)
    return __ret__.apply(lambda __response__: GetDataSourceResult(
        access_mode=pulumi.get(__response__, 'access_mode'),
        basic_auth_enabled=pulumi.get(__response__, 'basic_auth_enabled'),
        basic_auth_username=pulumi.get(__response__, 'basic_auth_username'),
        database_name=pulumi.get(__response__, 'database_name'),
        id=pulumi.get(__response__, 'id'),
        is_default=pulumi.get(__response__, 'is_default'),
        json_data_encoded=pulumi.get(__response__, 'json_data_encoded'),
        name=pulumi.get(__response__, 'name'),
        org_id=pulumi.get(__response__, 'org_id'),
        private_data_source_connect_network_id=pulumi.get(__response__, 'private_data_source_connect_network_id'),
        type=pulumi.get(__response__, 'type'),
        uid=pulumi.get(__response__, 'uid'),
        url=pulumi.get(__response__, 'url'),
        username=pulumi.get(__response__, 'username')))
