# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ProjectArgs', 'Project']

@pulumi.input_type
class ProjectArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Project resource.
        :param pulumi.Input[builtins.str] name: Human-friendly identifier of the project.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Human-friendly identifier of the project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ProjectState:
    def __init__(__self__, *,
                 created: Optional[pulumi.Input[builtins.str]] = None,
                 grafana_folder_uid: Optional[pulumi.Input[builtins.str]] = None,
                 is_default: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Project resources.
        :param pulumi.Input[builtins.str] created: The date when the project was created.
        :param pulumi.Input[builtins.str] grafana_folder_uid: The Grafana folder uid.
        :param pulumi.Input[builtins.bool] is_default: Use this project as default for running tests when no explicit project identifier is provided.
        :param pulumi.Input[builtins.str] name: Human-friendly identifier of the project.
        :param pulumi.Input[builtins.str] updated: The date when the project was last updated.
        """
        if created is not None:
            pulumi.set(__self__, "created", created)
        if grafana_folder_uid is not None:
            pulumi.set(__self__, "grafana_folder_uid", grafana_folder_uid)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if updated is not None:
            pulumi.set(__self__, "updated", updated)

    @property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date when the project was created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created", value)

    @property
    @pulumi.getter(name="grafanaFolderUid")
    def grafana_folder_uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Grafana folder uid.
        """
        return pulumi.get(self, "grafana_folder_uid")

    @grafana_folder_uid.setter
    def grafana_folder_uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "grafana_folder_uid", value)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Use this project as default for running tests when no explicit project identifier is provided.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Human-friendly identifier of the project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date when the project was last updated.
        """
        return pulumi.get(self, "updated")

    @updated.setter
    def updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated", value)


@pulumi.type_token("grafana:k6/project:Project")
class Project(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a k6 project.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        test_project = grafana.k6.Project("test_project", name="Terraform Test Project")
        ```

        ## Import

        ```sh
        $ pulumi import grafana:k6/project:Project name "{{ id }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: Human-friendly identifier of the project.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProjectArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a k6 project.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        test_project = grafana.k6.Project("test_project", name="Terraform Test Project")
        ```

        ## Import

        ```sh
        $ pulumi import grafana:k6/project:Project name "{{ id }}"
        ```

        :param str resource_name: The name of the resource.
        :param ProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectArgs.__new__(ProjectArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["created"] = None
            __props__.__dict__["grafana_folder_uid"] = None
            __props__.__dict__["is_default"] = None
            __props__.__dict__["updated"] = None
        super(Project, __self__).__init__(
            'grafana:k6/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created: Optional[pulumi.Input[builtins.str]] = None,
            grafana_folder_uid: Optional[pulumi.Input[builtins.str]] = None,
            is_default: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            updated: Optional[pulumi.Input[builtins.str]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] created: The date when the project was created.
        :param pulumi.Input[builtins.str] grafana_folder_uid: The Grafana folder uid.
        :param pulumi.Input[builtins.bool] is_default: Use this project as default for running tests when no explicit project identifier is provided.
        :param pulumi.Input[builtins.str] name: Human-friendly identifier of the project.
        :param pulumi.Input[builtins.str] updated: The date when the project was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectState.__new__(_ProjectState)

        __props__.__dict__["created"] = created
        __props__.__dict__["grafana_folder_uid"] = grafana_folder_uid
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["name"] = name
        __props__.__dict__["updated"] = updated
        return Project(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[builtins.str]:
        """
        The date when the project was created.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter(name="grafanaFolderUid")
    def grafana_folder_uid(self) -> pulumi.Output[builtins.str]:
        """
        The Grafana folder uid.
        """
        return pulumi.get(self, "grafana_folder_uid")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[builtins.bool]:
        """
        Use this project as default for running tests when no explicit project identifier is provided.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Human-friendly identifier of the project.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def updated(self) -> pulumi.Output[builtins.str]:
        """
        The date when the project was last updated.
        """
        return pulumi.get(self, "updated")

