# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ProjectLimitsArgs', 'ProjectLimits']

@pulumi.input_type
class ProjectLimitsArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[builtins.str],
                 duration_max_per_test: Optional[pulumi.Input[builtins.int]] = None,
                 vu_browser_max_per_test: Optional[pulumi.Input[builtins.int]] = None,
                 vu_max_per_test: Optional[pulumi.Input[builtins.int]] = None,
                 vuh_max_per_month: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a ProjectLimits resource.
        :param pulumi.Input[builtins.str] project_id: The identifier of the project to manage limits for.
        :param pulumi.Input[builtins.int] duration_max_per_test: Maximum duration of a test in seconds.
        :param pulumi.Input[builtins.int] vu_browser_max_per_test: Maximum number of concurrent browser virtual users (VUs) used in one test.
        :param pulumi.Input[builtins.int] vu_max_per_test: Maximum number of concurrent virtual users (VUs) used in one test.
        :param pulumi.Input[builtins.int] vuh_max_per_month: Maximum amount of virtual user hours (VU/h) used per one calendar month.
        """
        pulumi.set(__self__, "project_id", project_id)
        if duration_max_per_test is not None:
            pulumi.set(__self__, "duration_max_per_test", duration_max_per_test)
        if vu_browser_max_per_test is not None:
            pulumi.set(__self__, "vu_browser_max_per_test", vu_browser_max_per_test)
        if vu_max_per_test is not None:
            pulumi.set(__self__, "vu_max_per_test", vu_max_per_test)
        if vuh_max_per_month is not None:
            pulumi.set(__self__, "vuh_max_per_month", vuh_max_per_month)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[builtins.str]:
        """
        The identifier of the project to manage limits for.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="durationMaxPerTest")
    def duration_max_per_test(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum duration of a test in seconds.
        """
        return pulumi.get(self, "duration_max_per_test")

    @duration_max_per_test.setter
    def duration_max_per_test(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "duration_max_per_test", value)

    @property
    @pulumi.getter(name="vuBrowserMaxPerTest")
    def vu_browser_max_per_test(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum number of concurrent browser virtual users (VUs) used in one test.
        """
        return pulumi.get(self, "vu_browser_max_per_test")

    @vu_browser_max_per_test.setter
    def vu_browser_max_per_test(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vu_browser_max_per_test", value)

    @property
    @pulumi.getter(name="vuMaxPerTest")
    def vu_max_per_test(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum number of concurrent virtual users (VUs) used in one test.
        """
        return pulumi.get(self, "vu_max_per_test")

    @vu_max_per_test.setter
    def vu_max_per_test(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vu_max_per_test", value)

    @property
    @pulumi.getter(name="vuhMaxPerMonth")
    def vuh_max_per_month(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum amount of virtual user hours (VU/h) used per one calendar month.
        """
        return pulumi.get(self, "vuh_max_per_month")

    @vuh_max_per_month.setter
    def vuh_max_per_month(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vuh_max_per_month", value)


@pulumi.input_type
class _ProjectLimitsState:
    def __init__(__self__, *,
                 duration_max_per_test: Optional[pulumi.Input[builtins.int]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 vu_browser_max_per_test: Optional[pulumi.Input[builtins.int]] = None,
                 vu_max_per_test: Optional[pulumi.Input[builtins.int]] = None,
                 vuh_max_per_month: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering ProjectLimits resources.
        :param pulumi.Input[builtins.int] duration_max_per_test: Maximum duration of a test in seconds.
        :param pulumi.Input[builtins.str] project_id: The identifier of the project to manage limits for.
        :param pulumi.Input[builtins.int] vu_browser_max_per_test: Maximum number of concurrent browser virtual users (VUs) used in one test.
        :param pulumi.Input[builtins.int] vu_max_per_test: Maximum number of concurrent virtual users (VUs) used in one test.
        :param pulumi.Input[builtins.int] vuh_max_per_month: Maximum amount of virtual user hours (VU/h) used per one calendar month.
        """
        if duration_max_per_test is not None:
            pulumi.set(__self__, "duration_max_per_test", duration_max_per_test)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if vu_browser_max_per_test is not None:
            pulumi.set(__self__, "vu_browser_max_per_test", vu_browser_max_per_test)
        if vu_max_per_test is not None:
            pulumi.set(__self__, "vu_max_per_test", vu_max_per_test)
        if vuh_max_per_month is not None:
            pulumi.set(__self__, "vuh_max_per_month", vuh_max_per_month)

    @property
    @pulumi.getter(name="durationMaxPerTest")
    def duration_max_per_test(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum duration of a test in seconds.
        """
        return pulumi.get(self, "duration_max_per_test")

    @duration_max_per_test.setter
    def duration_max_per_test(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "duration_max_per_test", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of the project to manage limits for.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="vuBrowserMaxPerTest")
    def vu_browser_max_per_test(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum number of concurrent browser virtual users (VUs) used in one test.
        """
        return pulumi.get(self, "vu_browser_max_per_test")

    @vu_browser_max_per_test.setter
    def vu_browser_max_per_test(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vu_browser_max_per_test", value)

    @property
    @pulumi.getter(name="vuMaxPerTest")
    def vu_max_per_test(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum number of concurrent virtual users (VUs) used in one test.
        """
        return pulumi.get(self, "vu_max_per_test")

    @vu_max_per_test.setter
    def vu_max_per_test(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vu_max_per_test", value)

    @property
    @pulumi.getter(name="vuhMaxPerMonth")
    def vuh_max_per_month(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum amount of virtual user hours (VU/h) used per one calendar month.
        """
        return pulumi.get(self, "vuh_max_per_month")

    @vuh_max_per_month.setter
    def vuh_max_per_month(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vuh_max_per_month", value)


@pulumi.type_token("grafana:k6/projectLimits:ProjectLimits")
class ProjectLimits(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 duration_max_per_test: Optional[pulumi.Input[builtins.int]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 vu_browser_max_per_test: Optional[pulumi.Input[builtins.int]] = None,
                 vu_max_per_test: Optional[pulumi.Input[builtins.int]] = None,
                 vuh_max_per_month: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        Manages limits for a k6 project.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        test_project_limits = grafana.k6.Project("test_project_limits", name="Terraform Project Test Limits")
        test_limits = grafana.k6.ProjectLimits("test_limits",
            project_id=test_project_limits.id,
            vuh_max_per_month=1000,
            vu_max_per_test=100,
            vu_browser_max_per_test=10,
            duration_max_per_test=3600)
        ```

        ## Import

        ```sh
        $ pulumi import grafana:k6/projectLimits:ProjectLimits name "{{ project_id }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] duration_max_per_test: Maximum duration of a test in seconds.
        :param pulumi.Input[builtins.str] project_id: The identifier of the project to manage limits for.
        :param pulumi.Input[builtins.int] vu_browser_max_per_test: Maximum number of concurrent browser virtual users (VUs) used in one test.
        :param pulumi.Input[builtins.int] vu_max_per_test: Maximum number of concurrent virtual users (VUs) used in one test.
        :param pulumi.Input[builtins.int] vuh_max_per_month: Maximum amount of virtual user hours (VU/h) used per one calendar month.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectLimitsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages limits for a k6 project.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        test_project_limits = grafana.k6.Project("test_project_limits", name="Terraform Project Test Limits")
        test_limits = grafana.k6.ProjectLimits("test_limits",
            project_id=test_project_limits.id,
            vuh_max_per_month=1000,
            vu_max_per_test=100,
            vu_browser_max_per_test=10,
            duration_max_per_test=3600)
        ```

        ## Import

        ```sh
        $ pulumi import grafana:k6/projectLimits:ProjectLimits name "{{ project_id }}"
        ```

        :param str resource_name: The name of the resource.
        :param ProjectLimitsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectLimitsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 duration_max_per_test: Optional[pulumi.Input[builtins.int]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 vu_browser_max_per_test: Optional[pulumi.Input[builtins.int]] = None,
                 vu_max_per_test: Optional[pulumi.Input[builtins.int]] = None,
                 vuh_max_per_month: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectLimitsArgs.__new__(ProjectLimitsArgs)

            __props__.__dict__["duration_max_per_test"] = duration_max_per_test
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["vu_browser_max_per_test"] = vu_browser_max_per_test
            __props__.__dict__["vu_max_per_test"] = vu_max_per_test
            __props__.__dict__["vuh_max_per_month"] = vuh_max_per_month
        super(ProjectLimits, __self__).__init__(
            'grafana:k6/projectLimits:ProjectLimits',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            duration_max_per_test: Optional[pulumi.Input[builtins.int]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            vu_browser_max_per_test: Optional[pulumi.Input[builtins.int]] = None,
            vu_max_per_test: Optional[pulumi.Input[builtins.int]] = None,
            vuh_max_per_month: Optional[pulumi.Input[builtins.int]] = None) -> 'ProjectLimits':
        """
        Get an existing ProjectLimits resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] duration_max_per_test: Maximum duration of a test in seconds.
        :param pulumi.Input[builtins.str] project_id: The identifier of the project to manage limits for.
        :param pulumi.Input[builtins.int] vu_browser_max_per_test: Maximum number of concurrent browser virtual users (VUs) used in one test.
        :param pulumi.Input[builtins.int] vu_max_per_test: Maximum number of concurrent virtual users (VUs) used in one test.
        :param pulumi.Input[builtins.int] vuh_max_per_month: Maximum amount of virtual user hours (VU/h) used per one calendar month.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectLimitsState.__new__(_ProjectLimitsState)

        __props__.__dict__["duration_max_per_test"] = duration_max_per_test
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["vu_browser_max_per_test"] = vu_browser_max_per_test
        __props__.__dict__["vu_max_per_test"] = vu_max_per_test
        __props__.__dict__["vuh_max_per_month"] = vuh_max_per_month
        return ProjectLimits(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="durationMaxPerTest")
    def duration_max_per_test(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Maximum duration of a test in seconds.
        """
        return pulumi.get(self, "duration_max_per_test")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the project to manage limits for.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="vuBrowserMaxPerTest")
    def vu_browser_max_per_test(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Maximum number of concurrent browser virtual users (VUs) used in one test.
        """
        return pulumi.get(self, "vu_browser_max_per_test")

    @property
    @pulumi.getter(name="vuMaxPerTest")
    def vu_max_per_test(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Maximum number of concurrent virtual users (VUs) used in one test.
        """
        return pulumi.get(self, "vu_max_per_test")

    @property
    @pulumi.getter(name="vuhMaxPerMonth")
    def vuh_max_per_month(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Maximum amount of virtual user hours (VU/h) used per one calendar month.
        """
        return pulumi.get(self, "vuh_max_per_month")

