# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AlertArgs', 'Alert']

@pulumi.input_type
class AlertArgs:
    def __init__(__self__, *,
                 title: pulumi.Input[builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 anomaly_condition: Optional[pulumi.Input[builtins.str]] = None,
                 for_: Optional[pulumi.Input[builtins.str]] = None,
                 job_id: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 no_data_state: Optional[pulumi.Input[builtins.str]] = None,
                 outlier_id: Optional[pulumi.Input[builtins.str]] = None,
                 threshold: Optional[pulumi.Input[builtins.str]] = None,
                 window: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Alert resource.
        :param pulumi.Input[builtins.str] title: The title of the alert.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Annotations to add to the alert generated in Grafana.
        :param pulumi.Input[builtins.str] anomaly_condition: The condition for when to consider a point as anomalous.
        :param pulumi.Input[builtins.str] for_: How long values must be anomalous before firing an alert.
        :param pulumi.Input[builtins.str] job_id: The forecast this alert belongs to.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels to add to the alert generated in Grafana.
        :param pulumi.Input[builtins.str] no_data_state: How the alert should be processed when no data is returned by the underlying series
        :param pulumi.Input[builtins.str] outlier_id: The forecast this alert belongs to.
        :param pulumi.Input[builtins.str] threshold: The threshold of points over the window that need to be anomalous to alert.
        :param pulumi.Input[builtins.str] window: How much time to average values over
        """
        pulumi.set(__self__, "title", title)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if anomaly_condition is not None:
            pulumi.set(__self__, "anomaly_condition", anomaly_condition)
        if for_ is not None:
            pulumi.set(__self__, "for_", for_)
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if no_data_state is not None:
            pulumi.set(__self__, "no_data_state", no_data_state)
        if outlier_id is not None:
            pulumi.set(__self__, "outlier_id", outlier_id)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if window is not None:
            pulumi.set(__self__, "window", window)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[builtins.str]:
        """
        The title of the alert.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Annotations to add to the alert generated in Grafana.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="anomalyCondition")
    def anomaly_condition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The condition for when to consider a point as anomalous.
        """
        return pulumi.get(self, "anomaly_condition")

    @anomaly_condition.setter
    def anomaly_condition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "anomaly_condition", value)

    @property
    @pulumi.getter(name="for")
    def for_(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How long values must be anomalous before firing an alert.
        """
        return pulumi.get(self, "for_")

    @for_.setter
    def for_(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "for_", value)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The forecast this alert belongs to.
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "job_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels to add to the alert generated in Grafana.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="noDataState")
    def no_data_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How the alert should be processed when no data is returned by the underlying series
        """
        return pulumi.get(self, "no_data_state")

    @no_data_state.setter
    def no_data_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "no_data_state", value)

    @property
    @pulumi.getter(name="outlierId")
    def outlier_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The forecast this alert belongs to.
        """
        return pulumi.get(self, "outlier_id")

    @outlier_id.setter
    def outlier_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "outlier_id", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The threshold of points over the window that need to be anomalous to alert.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter
    def window(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How much time to average values over
        """
        return pulumi.get(self, "window")

    @window.setter
    def window(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "window", value)


@pulumi.input_type
class _AlertState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 anomaly_condition: Optional[pulumi.Input[builtins.str]] = None,
                 for_: Optional[pulumi.Input[builtins.str]] = None,
                 job_id: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 no_data_state: Optional[pulumi.Input[builtins.str]] = None,
                 outlier_id: Optional[pulumi.Input[builtins.str]] = None,
                 threshold: Optional[pulumi.Input[builtins.str]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 window: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Alert resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Annotations to add to the alert generated in Grafana.
        :param pulumi.Input[builtins.str] anomaly_condition: The condition for when to consider a point as anomalous.
        :param pulumi.Input[builtins.str] for_: How long values must be anomalous before firing an alert.
        :param pulumi.Input[builtins.str] job_id: The forecast this alert belongs to.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels to add to the alert generated in Grafana.
        :param pulumi.Input[builtins.str] no_data_state: How the alert should be processed when no data is returned by the underlying series
        :param pulumi.Input[builtins.str] outlier_id: The forecast this alert belongs to.
        :param pulumi.Input[builtins.str] threshold: The threshold of points over the window that need to be anomalous to alert.
        :param pulumi.Input[builtins.str] title: The title of the alert.
        :param pulumi.Input[builtins.str] window: How much time to average values over
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if anomaly_condition is not None:
            pulumi.set(__self__, "anomaly_condition", anomaly_condition)
        if for_ is not None:
            pulumi.set(__self__, "for_", for_)
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if no_data_state is not None:
            pulumi.set(__self__, "no_data_state", no_data_state)
        if outlier_id is not None:
            pulumi.set(__self__, "outlier_id", outlier_id)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if window is not None:
            pulumi.set(__self__, "window", window)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Annotations to add to the alert generated in Grafana.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="anomalyCondition")
    def anomaly_condition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The condition for when to consider a point as anomalous.
        """
        return pulumi.get(self, "anomaly_condition")

    @anomaly_condition.setter
    def anomaly_condition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "anomaly_condition", value)

    @property
    @pulumi.getter(name="for")
    def for_(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How long values must be anomalous before firing an alert.
        """
        return pulumi.get(self, "for_")

    @for_.setter
    def for_(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "for_", value)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The forecast this alert belongs to.
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "job_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels to add to the alert generated in Grafana.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="noDataState")
    def no_data_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How the alert should be processed when no data is returned by the underlying series
        """
        return pulumi.get(self, "no_data_state")

    @no_data_state.setter
    def no_data_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "no_data_state", value)

    @property
    @pulumi.getter(name="outlierId")
    def outlier_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The forecast this alert belongs to.
        """
        return pulumi.get(self, "outlier_id")

    @outlier_id.setter
    def outlier_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "outlier_id", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The threshold of points over the window that need to be anomalous to alert.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The title of the alert.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def window(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How much time to average values over
        """
        return pulumi.get(self, "window")

    @window.setter
    def window(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "window", value)


@pulumi.type_token("grafana:machineLearning/alert:Alert")
class Alert(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 anomaly_condition: Optional[pulumi.Input[builtins.str]] = None,
                 for_: Optional[pulumi.Input[builtins.str]] = None,
                 job_id: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 no_data_state: Optional[pulumi.Input[builtins.str]] = None,
                 outlier_id: Optional[pulumi.Input[builtins.str]] = None,
                 threshold: Optional[pulumi.Input[builtins.str]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 window: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Forecast Alert

        This alert uses a forecast.

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        test_alert_job = grafana.machine_learning.Job("test_alert_job",
            name="Test Job",
            metric="tf_test_alert_job",
            datasource_type="prometheus",
            datasource_uid="abcd12345",
            query_params={
                "expr": "grafanacloud_grafana_instance_active_user_count",
            })
        test_job_alert = grafana.machine_learning.Alert("test_job_alert",
            job_id=test_alert_job.id,
            title="Test Alert",
            anomaly_condition="any",
            threshold=">0.8",
            window="15m",
            no_data_state="OK")
        ```

        ### Outlier Alert

        This alert uses an outlier detector.

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        test_alert_outlier_detector = grafana.machine_learning.OutlierDetector("test_alert_outlier_detector",
            name="Test Outlier",
            metric="tf_test_alert_outlier",
            datasource_type="prometheus",
            datasource_uid="AbCd12345",
            query_params={
                "expr": "grafanacloud_grafana_instance_active_user_count",
            },
            interval=300,
            algorithm={
                "name": "dbscan",
                "sensitivity": 0.5,
                "config": {
                    "epsilon": 1,
                },
            })
        test_outlier_alert = grafana.machine_learning.Alert("test_outlier_alert",
            outlier_id=test_alert_outlier_detector.id,
            title="Test Alert",
            window="1h")
        ```

        ## Import

        ```sh
        $ pulumi import grafana:machineLearning/alert:Alert name "{{ id }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Annotations to add to the alert generated in Grafana.
        :param pulumi.Input[builtins.str] anomaly_condition: The condition for when to consider a point as anomalous.
        :param pulumi.Input[builtins.str] for_: How long values must be anomalous before firing an alert.
        :param pulumi.Input[builtins.str] job_id: The forecast this alert belongs to.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels to add to the alert generated in Grafana.
        :param pulumi.Input[builtins.str] no_data_state: How the alert should be processed when no data is returned by the underlying series
        :param pulumi.Input[builtins.str] outlier_id: The forecast this alert belongs to.
        :param pulumi.Input[builtins.str] threshold: The threshold of points over the window that need to be anomalous to alert.
        :param pulumi.Input[builtins.str] title: The title of the alert.
        :param pulumi.Input[builtins.str] window: How much time to average values over
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlertArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Forecast Alert

        This alert uses a forecast.

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        test_alert_job = grafana.machine_learning.Job("test_alert_job",
            name="Test Job",
            metric="tf_test_alert_job",
            datasource_type="prometheus",
            datasource_uid="abcd12345",
            query_params={
                "expr": "grafanacloud_grafana_instance_active_user_count",
            })
        test_job_alert = grafana.machine_learning.Alert("test_job_alert",
            job_id=test_alert_job.id,
            title="Test Alert",
            anomaly_condition="any",
            threshold=">0.8",
            window="15m",
            no_data_state="OK")
        ```

        ### Outlier Alert

        This alert uses an outlier detector.

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        test_alert_outlier_detector = grafana.machine_learning.OutlierDetector("test_alert_outlier_detector",
            name="Test Outlier",
            metric="tf_test_alert_outlier",
            datasource_type="prometheus",
            datasource_uid="AbCd12345",
            query_params={
                "expr": "grafanacloud_grafana_instance_active_user_count",
            },
            interval=300,
            algorithm={
                "name": "dbscan",
                "sensitivity": 0.5,
                "config": {
                    "epsilon": 1,
                },
            })
        test_outlier_alert = grafana.machine_learning.Alert("test_outlier_alert",
            outlier_id=test_alert_outlier_detector.id,
            title="Test Alert",
            window="1h")
        ```

        ## Import

        ```sh
        $ pulumi import grafana:machineLearning/alert:Alert name "{{ id }}"
        ```

        :param str resource_name: The name of the resource.
        :param AlertArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 anomaly_condition: Optional[pulumi.Input[builtins.str]] = None,
                 for_: Optional[pulumi.Input[builtins.str]] = None,
                 job_id: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 no_data_state: Optional[pulumi.Input[builtins.str]] = None,
                 outlier_id: Optional[pulumi.Input[builtins.str]] = None,
                 threshold: Optional[pulumi.Input[builtins.str]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 window: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertArgs.__new__(AlertArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["anomaly_condition"] = anomaly_condition
            __props__.__dict__["for_"] = for_
            __props__.__dict__["job_id"] = job_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["no_data_state"] = no_data_state
            __props__.__dict__["outlier_id"] = outlier_id
            __props__.__dict__["threshold"] = threshold
            if title is None and not opts.urn:
                raise TypeError("Missing required property 'title'")
            __props__.__dict__["title"] = title
            __props__.__dict__["window"] = window
        super(Alert, __self__).__init__(
            'grafana:machineLearning/alert:Alert',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            anomaly_condition: Optional[pulumi.Input[builtins.str]] = None,
            for_: Optional[pulumi.Input[builtins.str]] = None,
            job_id: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            no_data_state: Optional[pulumi.Input[builtins.str]] = None,
            outlier_id: Optional[pulumi.Input[builtins.str]] = None,
            threshold: Optional[pulumi.Input[builtins.str]] = None,
            title: Optional[pulumi.Input[builtins.str]] = None,
            window: Optional[pulumi.Input[builtins.str]] = None) -> 'Alert':
        """
        Get an existing Alert resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Annotations to add to the alert generated in Grafana.
        :param pulumi.Input[builtins.str] anomaly_condition: The condition for when to consider a point as anomalous.
        :param pulumi.Input[builtins.str] for_: How long values must be anomalous before firing an alert.
        :param pulumi.Input[builtins.str] job_id: The forecast this alert belongs to.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels to add to the alert generated in Grafana.
        :param pulumi.Input[builtins.str] no_data_state: How the alert should be processed when no data is returned by the underlying series
        :param pulumi.Input[builtins.str] outlier_id: The forecast this alert belongs to.
        :param pulumi.Input[builtins.str] threshold: The threshold of points over the window that need to be anomalous to alert.
        :param pulumi.Input[builtins.str] title: The title of the alert.
        :param pulumi.Input[builtins.str] window: How much time to average values over
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertState.__new__(_AlertState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["anomaly_condition"] = anomaly_condition
        __props__.__dict__["for_"] = for_
        __props__.__dict__["job_id"] = job_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["no_data_state"] = no_data_state
        __props__.__dict__["outlier_id"] = outlier_id
        __props__.__dict__["threshold"] = threshold
        __props__.__dict__["title"] = title
        __props__.__dict__["window"] = window
        return Alert(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Annotations to add to the alert generated in Grafana.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="anomalyCondition")
    def anomaly_condition(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The condition for when to consider a point as anomalous.
        """
        return pulumi.get(self, "anomaly_condition")

    @property
    @pulumi.getter(name="for")
    def for_(self) -> pulumi.Output[builtins.str]:
        """
        How long values must be anomalous before firing an alert.
        """
        return pulumi.get(self, "for_")

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The forecast this alert belongs to.
        """
        return pulumi.get(self, "job_id")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Labels to add to the alert generated in Grafana.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="noDataState")
    def no_data_state(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        How the alert should be processed when no data is returned by the underlying series
        """
        return pulumi.get(self, "no_data_state")

    @property
    @pulumi.getter(name="outlierId")
    def outlier_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The forecast this alert belongs to.
        """
        return pulumi.get(self, "outlier_id")

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The threshold of points over the window that need to be anomalous to alert.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[builtins.str]:
        """
        The title of the alert.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def window(self) -> pulumi.Output[builtins.str]:
        """
        How much time to average values over
        """
        return pulumi.get(self, "window")

