# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'IntegrationDefaultRoute',
    'IntegrationDefaultRouteMsteams',
    'IntegrationDefaultRouteSlack',
    'IntegrationDefaultRouteTelegram',
    'IntegrationTemplates',
    'IntegrationTemplatesEmail',
    'IntegrationTemplatesMicrosoftTeams',
    'IntegrationTemplatesMobileApp',
    'IntegrationTemplatesPhoneCall',
    'IntegrationTemplatesSlack',
    'IntegrationTemplatesSms',
    'IntegrationTemplatesTelegram',
    'IntegrationTemplatesWeb',
    'RouteMsteams',
    'RouteSlack',
    'RouteTelegram',
    'ScheduleSlack',
    'GetUsersUserResult',
]

@pulumi.output_type
class IntegrationDefaultRoute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "escalationChainId":
            suggest = "escalation_chain_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationDefaultRoute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationDefaultRoute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationDefaultRoute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 escalation_chain_id: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 msteams: Optional['outputs.IntegrationDefaultRouteMsteams'] = None,
                 slack: Optional['outputs.IntegrationDefaultRouteSlack'] = None,
                 telegram: Optional['outputs.IntegrationDefaultRouteTelegram'] = None):
        """
        :param builtins.str escalation_chain_id: The ID of the escalation chain.
        :param 'IntegrationDefaultRouteMsteamsArgs' msteams: MS teams-specific settings for a route.
        :param 'IntegrationDefaultRouteSlackArgs' slack: Slack-specific settings for a route.
        :param 'IntegrationDefaultRouteTelegramArgs' telegram: Telegram-specific settings for a route.
        """
        if escalation_chain_id is not None:
            pulumi.set(__self__, "escalation_chain_id", escalation_chain_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if msteams is not None:
            pulumi.set(__self__, "msteams", msteams)
        if slack is not None:
            pulumi.set(__self__, "slack", slack)
        if telegram is not None:
            pulumi.set(__self__, "telegram", telegram)

    @property
    @pulumi.getter(name="escalationChainId")
    def escalation_chain_id(self) -> Optional[builtins.str]:
        """
        The ID of the escalation chain.
        """
        return pulumi.get(self, "escalation_chain_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def msteams(self) -> Optional['outputs.IntegrationDefaultRouteMsteams']:
        """
        MS teams-specific settings for a route.
        """
        return pulumi.get(self, "msteams")

    @property
    @pulumi.getter
    def slack(self) -> Optional['outputs.IntegrationDefaultRouteSlack']:
        """
        Slack-specific settings for a route.
        """
        return pulumi.get(self, "slack")

    @property
    @pulumi.getter
    def telegram(self) -> Optional['outputs.IntegrationDefaultRouteTelegram']:
        """
        Telegram-specific settings for a route.
        """
        return pulumi.get(self, "telegram")


@pulumi.output_type
class IntegrationDefaultRouteMsteams(dict):
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None,
                 id: Optional[builtins.str] = None):
        """
        :param builtins.bool enabled: Enable notification in MS teams. Defaults to `true`.
        :param builtins.str id: MS teams channel id. Alerts will be directed to this channel in Microsoft teams.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Enable notification in MS teams. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        MS teams channel id. Alerts will be directed to this channel in Microsoft teams.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class IntegrationDefaultRouteSlack(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelId":
            suggest = "channel_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationDefaultRouteSlack. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationDefaultRouteSlack.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationDefaultRouteSlack.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_id: Optional[builtins.str] = None,
                 enabled: Optional[builtins.bool] = None):
        """
        :param builtins.str channel_id: Slack channel id. Alerts will be directed to this channel in Slack.
        :param builtins.bool enabled: Enable notification in Slack. Defaults to `true`.
        """
        if channel_id is not None:
            pulumi.set(__self__, "channel_id", channel_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> Optional[builtins.str]:
        """
        Slack channel id. Alerts will be directed to this channel in Slack.
        """
        return pulumi.get(self, "channel_id")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Enable notification in Slack. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class IntegrationDefaultRouteTelegram(dict):
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None,
                 id: Optional[builtins.str] = None):
        """
        :param builtins.bool enabled: Enable notification in Telegram. Defaults to `true`.
        :param builtins.str id: Telegram channel id. Alerts will be directed to this channel in Telegram.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Enable notification in Telegram. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Telegram channel id. Alerts will be directed to this channel in Telegram.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class IntegrationTemplates(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acknowledgeSignal":
            suggest = "acknowledge_signal"
        elif key == "groupingKey":
            suggest = "grouping_key"
        elif key == "microsoftTeams":
            suggest = "microsoft_teams"
        elif key == "mobileApp":
            suggest = "mobile_app"
        elif key == "phoneCall":
            suggest = "phone_call"
        elif key == "resolveSignal":
            suggest = "resolve_signal"
        elif key == "sourceLink":
            suggest = "source_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationTemplates. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationTemplates.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationTemplates.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acknowledge_signal: Optional[builtins.str] = None,
                 email: Optional['outputs.IntegrationTemplatesEmail'] = None,
                 grouping_key: Optional[builtins.str] = None,
                 microsoft_teams: Optional['outputs.IntegrationTemplatesMicrosoftTeams'] = None,
                 mobile_app: Optional['outputs.IntegrationTemplatesMobileApp'] = None,
                 phone_call: Optional['outputs.IntegrationTemplatesPhoneCall'] = None,
                 resolve_signal: Optional[builtins.str] = None,
                 slack: Optional['outputs.IntegrationTemplatesSlack'] = None,
                 sms: Optional['outputs.IntegrationTemplatesSms'] = None,
                 source_link: Optional[builtins.str] = None,
                 telegram: Optional['outputs.IntegrationTemplatesTelegram'] = None,
                 web: Optional['outputs.IntegrationTemplatesWeb'] = None):
        """
        :param builtins.str acknowledge_signal: Template for sending a signal to acknowledge the Incident.
        :param 'IntegrationTemplatesEmailArgs' email: Templates for Email.
        :param builtins.str grouping_key: Template for the key by which alerts are grouped.
        :param 'IntegrationTemplatesMicrosoftTeamsArgs' microsoft_teams: Templates for Microsoft Teams. **NOTE**: Microsoft Teams templates are only available on Grafana Cloud.
        :param 'IntegrationTemplatesMobileAppArgs' mobile_app: Templates for Mobile app push notifications.
        :param 'IntegrationTemplatesPhoneCallArgs' phone_call: Templates for Phone Call.
        :param builtins.str resolve_signal: Template for sending a signal to resolve the Incident.
        :param 'IntegrationTemplatesSlackArgs' slack: Templates for Slack.
        :param 'IntegrationTemplatesSmsArgs' sms: Templates for SMS.
        :param builtins.str source_link: Template for a source link.
        :param 'IntegrationTemplatesTelegramArgs' telegram: Templates for Telegram.
        :param 'IntegrationTemplatesWebArgs' web: Templates for Web.
        """
        if acknowledge_signal is not None:
            pulumi.set(__self__, "acknowledge_signal", acknowledge_signal)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if grouping_key is not None:
            pulumi.set(__self__, "grouping_key", grouping_key)
        if microsoft_teams is not None:
            pulumi.set(__self__, "microsoft_teams", microsoft_teams)
        if mobile_app is not None:
            pulumi.set(__self__, "mobile_app", mobile_app)
        if phone_call is not None:
            pulumi.set(__self__, "phone_call", phone_call)
        if resolve_signal is not None:
            pulumi.set(__self__, "resolve_signal", resolve_signal)
        if slack is not None:
            pulumi.set(__self__, "slack", slack)
        if sms is not None:
            pulumi.set(__self__, "sms", sms)
        if source_link is not None:
            pulumi.set(__self__, "source_link", source_link)
        if telegram is not None:
            pulumi.set(__self__, "telegram", telegram)
        if web is not None:
            pulumi.set(__self__, "web", web)

    @property
    @pulumi.getter(name="acknowledgeSignal")
    def acknowledge_signal(self) -> Optional[builtins.str]:
        """
        Template for sending a signal to acknowledge the Incident.
        """
        return pulumi.get(self, "acknowledge_signal")

    @property
    @pulumi.getter
    def email(self) -> Optional['outputs.IntegrationTemplatesEmail']:
        """
        Templates for Email.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="groupingKey")
    def grouping_key(self) -> Optional[builtins.str]:
        """
        Template for the key by which alerts are grouped.
        """
        return pulumi.get(self, "grouping_key")

    @property
    @pulumi.getter(name="microsoftTeams")
    def microsoft_teams(self) -> Optional['outputs.IntegrationTemplatesMicrosoftTeams']:
        """
        Templates for Microsoft Teams. **NOTE**: Microsoft Teams templates are only available on Grafana Cloud.
        """
        return pulumi.get(self, "microsoft_teams")

    @property
    @pulumi.getter(name="mobileApp")
    def mobile_app(self) -> Optional['outputs.IntegrationTemplatesMobileApp']:
        """
        Templates for Mobile app push notifications.
        """
        return pulumi.get(self, "mobile_app")

    @property
    @pulumi.getter(name="phoneCall")
    def phone_call(self) -> Optional['outputs.IntegrationTemplatesPhoneCall']:
        """
        Templates for Phone Call.
        """
        return pulumi.get(self, "phone_call")

    @property
    @pulumi.getter(name="resolveSignal")
    def resolve_signal(self) -> Optional[builtins.str]:
        """
        Template for sending a signal to resolve the Incident.
        """
        return pulumi.get(self, "resolve_signal")

    @property
    @pulumi.getter
    def slack(self) -> Optional['outputs.IntegrationTemplatesSlack']:
        """
        Templates for Slack.
        """
        return pulumi.get(self, "slack")

    @property
    @pulumi.getter
    def sms(self) -> Optional['outputs.IntegrationTemplatesSms']:
        """
        Templates for SMS.
        """
        return pulumi.get(self, "sms")

    @property
    @pulumi.getter(name="sourceLink")
    def source_link(self) -> Optional[builtins.str]:
        """
        Template for a source link.
        """
        return pulumi.get(self, "source_link")

    @property
    @pulumi.getter
    def telegram(self) -> Optional['outputs.IntegrationTemplatesTelegram']:
        """
        Templates for Telegram.
        """
        return pulumi.get(self, "telegram")

    @property
    @pulumi.getter
    def web(self) -> Optional['outputs.IntegrationTemplatesWeb']:
        """
        Templates for Web.
        """
        return pulumi.get(self, "web")


@pulumi.output_type
class IntegrationTemplatesEmail(dict):
    def __init__(__self__, *,
                 message: Optional[builtins.str] = None,
                 title: Optional[builtins.str] = None):
        """
        :param builtins.str message: Template for Alert message.
        :param builtins.str title: Template for Alert title.
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        Template for Alert message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def title(self) -> Optional[builtins.str]:
        """
        Template for Alert title.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class IntegrationTemplatesMicrosoftTeams(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageUrl":
            suggest = "image_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationTemplatesMicrosoftTeams. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationTemplatesMicrosoftTeams.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationTemplatesMicrosoftTeams.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_url: Optional[builtins.str] = None,
                 message: Optional[builtins.str] = None,
                 title: Optional[builtins.str] = None):
        """
        :param builtins.str image_url: Template for Alert image url.
        :param builtins.str message: Template for Alert message.
        :param builtins.str title: Template for Alert title.
        """
        if image_url is not None:
            pulumi.set(__self__, "image_url", image_url)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> Optional[builtins.str]:
        """
        Template for Alert image url.
        """
        return pulumi.get(self, "image_url")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        Template for Alert message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def title(self) -> Optional[builtins.str]:
        """
        Template for Alert title.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class IntegrationTemplatesMobileApp(dict):
    def __init__(__self__, *,
                 message: Optional[builtins.str] = None,
                 title: Optional[builtins.str] = None):
        """
        :param builtins.str message: Template for Alert message.
        :param builtins.str title: Template for Alert title.
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        Template for Alert message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def title(self) -> Optional[builtins.str]:
        """
        Template for Alert title.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class IntegrationTemplatesPhoneCall(dict):
    def __init__(__self__, *,
                 title: Optional[builtins.str] = None):
        """
        :param builtins.str title: Template for Alert title.
        """
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def title(self) -> Optional[builtins.str]:
        """
        Template for Alert title.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class IntegrationTemplatesSlack(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageUrl":
            suggest = "image_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationTemplatesSlack. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationTemplatesSlack.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationTemplatesSlack.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_url: Optional[builtins.str] = None,
                 message: Optional[builtins.str] = None,
                 title: Optional[builtins.str] = None):
        """
        :param builtins.str image_url: Template for Alert image url.
        :param builtins.str message: Template for Alert message.
        :param builtins.str title: Template for Alert title.
        """
        if image_url is not None:
            pulumi.set(__self__, "image_url", image_url)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> Optional[builtins.str]:
        """
        Template for Alert image url.
        """
        return pulumi.get(self, "image_url")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        Template for Alert message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def title(self) -> Optional[builtins.str]:
        """
        Template for Alert title.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class IntegrationTemplatesSms(dict):
    def __init__(__self__, *,
                 title: Optional[builtins.str] = None):
        """
        :param builtins.str title: Template for Alert title.
        """
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def title(self) -> Optional[builtins.str]:
        """
        Template for Alert title.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class IntegrationTemplatesTelegram(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageUrl":
            suggest = "image_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationTemplatesTelegram. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationTemplatesTelegram.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationTemplatesTelegram.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_url: Optional[builtins.str] = None,
                 message: Optional[builtins.str] = None,
                 title: Optional[builtins.str] = None):
        """
        :param builtins.str image_url: Template for Alert image url.
        :param builtins.str message: Template for Alert message.
        :param builtins.str title: Template for Alert title.
        """
        if image_url is not None:
            pulumi.set(__self__, "image_url", image_url)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> Optional[builtins.str]:
        """
        Template for Alert image url.
        """
        return pulumi.get(self, "image_url")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        Template for Alert message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def title(self) -> Optional[builtins.str]:
        """
        Template for Alert title.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class IntegrationTemplatesWeb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageUrl":
            suggest = "image_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationTemplatesWeb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationTemplatesWeb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationTemplatesWeb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_url: Optional[builtins.str] = None,
                 message: Optional[builtins.str] = None,
                 title: Optional[builtins.str] = None):
        """
        :param builtins.str image_url: Template for Alert image url.
        :param builtins.str message: Template for Alert message.
        :param builtins.str title: Template for Alert title.
        """
        if image_url is not None:
            pulumi.set(__self__, "image_url", image_url)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> Optional[builtins.str]:
        """
        Template for Alert image url.
        """
        return pulumi.get(self, "image_url")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        Template for Alert message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def title(self) -> Optional[builtins.str]:
        """
        Template for Alert title.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class RouteMsteams(dict):
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None,
                 id: Optional[builtins.str] = None):
        """
        :param builtins.bool enabled: Enable notification in MS teams. Defaults to `true`.
        :param builtins.str id: MS teams channel id. Alerts will be directed to this channel in Microsoft teams.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Enable notification in MS teams. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        MS teams channel id. Alerts will be directed to this channel in Microsoft teams.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class RouteSlack(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelId":
            suggest = "channel_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RouteSlack. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RouteSlack.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RouteSlack.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_id: Optional[builtins.str] = None,
                 enabled: Optional[builtins.bool] = None):
        """
        :param builtins.str channel_id: Slack channel id. Alerts will be directed to this channel in Slack.
        :param builtins.bool enabled: Enable notification in Slack. Defaults to `true`.
        """
        if channel_id is not None:
            pulumi.set(__self__, "channel_id", channel_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> Optional[builtins.str]:
        """
        Slack channel id. Alerts will be directed to this channel in Slack.
        """
        return pulumi.get(self, "channel_id")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Enable notification in Slack. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class RouteTelegram(dict):
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None,
                 id: Optional[builtins.str] = None):
        """
        :param builtins.bool enabled: Enable notification in Telegram. Defaults to `true`.
        :param builtins.str id: Telegram channel id. Alerts will be directed to this channel in Telegram.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Enable notification in Telegram. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Telegram channel id. Alerts will be directed to this channel in Telegram.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ScheduleSlack(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelId":
            suggest = "channel_id"
        elif key == "userGroupId":
            suggest = "user_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleSlack. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleSlack.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleSlack.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_id: Optional[builtins.str] = None,
                 user_group_id: Optional[builtins.str] = None):
        """
        :param builtins.str channel_id: Slack channel id. Reminder about schedule shifts will be directed to this channel in Slack.
        :param builtins.str user_group_id: Slack user group id. Members of user group will be updated when on-call users change.
        """
        if channel_id is not None:
            pulumi.set(__self__, "channel_id", channel_id)
        if user_group_id is not None:
            pulumi.set(__self__, "user_group_id", user_group_id)

    @property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> Optional[builtins.str]:
        """
        Slack channel id. Reminder about schedule shifts will be directed to this channel in Slack.
        """
        return pulumi.get(self, "channel_id")

    @property
    @pulumi.getter(name="userGroupId")
    def user_group_id(self) -> Optional[builtins.str]:
        """
        Slack user group id. Members of user group will be updated when on-call users change.
        """
        return pulumi.get(self, "user_group_id")


@pulumi.output_type
class GetUsersUserResult(dict):
    def __init__(__self__, *,
                 email: builtins.str,
                 id: builtins.str,
                 role: builtins.str,
                 username: builtins.str):
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def email(self) -> builtins.str:
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def role(self) -> builtins.str:
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        return pulumi.get(self, "username")


